/*
 * Decompiled with CFR 0.152.
 */
package lbms.plugins.mldht.kad;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import lbms.plugins.mldht.DHTConfiguration;
import lbms.plugins.mldht.kad.DHT;
import lbms.plugins.mldht.kad.DHTBase;
import lbms.plugins.mldht.kad.DHTConstants;
import lbms.plugins.mldht.kad.KBucket;
import lbms.plugins.mldht.kad.KBucketEntry;
import lbms.plugins.mldht.kad.Key;
import lbms.plugins.mldht.kad.Prefix;
import lbms.plugins.mldht.kad.RPCCallBase;
import lbms.plugins.mldht.kad.RPCServer;
import lbms.plugins.mldht.kad.messages.MessageBase;
import lbms.plugins.mldht.kad.tasks.NodeLookup;
import lbms.plugins.mldht.kad.tasks.PingRefreshTask;
import lbms.plugins.mldht.kad.tasks.Task;
import lbms.plugins.mldht.kad.tasks.TaskListener;
import lbms.plugins.mldht.kad.utils.AddressUtils;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.LightHashMap;

public class Node {
    private Object routingTableCoWLock = new Object();
    private volatile List<RoutingTableEntry> routingTable = new ArrayList<RoutingTableEntry>();
    private DHT dht;
    private int num_receives;
    private int numReceivesAtLastCheck;
    private long timeOfLastPingCheck;
    private long timeOfLastReceiveCountChange;
    private long timeOfRecovery;
    private boolean survivalMode;
    private int num_entries;
    private ConcurrentHashMap<Key, RPCServer> usedIDs = new ConcurrentHashMap();
    private volatile Map<InetSocketAddress, RoutingTableEntry> knownNodes = new HashMap<InetSocketAddress, RoutingTableEntry>();
    private static Map<String, Serializable> dataStore;

    public Node(DHT dht) {
        this.dht = dht;
        this.num_receives = 0;
        this.num_entries = 0;
        this.routingTable.add(new RoutingTableEntry(new Prefix(), new KBucket(this)));
    }

    void recieved(DHTBase dh_table, MessageBase msg) {
        KBucketEntry newEntry = new KBucketEntry(msg.getOrigin(), msg.getID());
        newEntry.setVersion(msg.getVersion());
        boolean nodeIDchanged = false;
        RoutingTableEntry cachedEntry = this.knownNodes.get(newEntry.getAddress());
        if (cachedEntry != null) {
            nodeIDchanged = cachedEntry.bucket.checkForIDChange(msg);
        }
        if (!nodeIDchanged) {
            if (msg.getType() == MessageBase.Type.RSP_MSG) {
                RoutingTableEntry entry = this.findBucketForId(msg.getID());
                entry.bucket.notifyOfResponse(msg);
            }
            this.insertEntry(newEntry, false);
        }
        ++this.num_receives;
    }

    public void insertEntry(KBucketEntry entry, boolean internalInsert) {
        if (this.usedIDs.containsKey(entry.getID()) || AddressUtils.isBogon(entry.getAddress())) {
            return;
        }
        Key nodeID = entry.getID();
        RoutingTableEntry tableEntry = this.findBucketForId(nodeID);
        while (tableEntry.bucket.getNumEntries() >= 8 && tableEntry.prefix.getDepth() < 159) {
            boolean isLocalBucket = false;
            for (Key k : this.allLocalIDs()) {
                isLocalBucket |= tableEntry.prefix.isPrefixOf(k);
            }
            if (!isLocalBucket) break;
            this.splitEntry(tableEntry);
            tableEntry = this.findBucketForId(nodeID);
        }
        int oldSize = tableEntry.bucket.getNumEntries();
        if (internalInsert) {
            tableEntry.bucket.modifyMainBucket(null, entry);
        } else {
            tableEntry.bucket.insertOrRefresh(entry);
        }
        this.num_entries += tableEntry.bucket.getNumEntries() - oldSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void splitEntry(RoutingTableEntry entry) {
        Object object = this.routingTableCoWLock;
        synchronized (object) {
            ArrayList<RoutingTableEntry> newTable = new ArrayList<RoutingTableEntry>(this.routingTable);
            if (!newTable.contains(entry)) {
                return;
            }
            newTable.remove(entry);
            newTable.add(new RoutingTableEntry(entry.prefix.splitPrefixBranch(false), new KBucket(this)));
            newTable.add(new RoutingTableEntry(entry.prefix.splitPrefixBranch(true), new KBucket(this)));
            Collections.sort(newTable);
            this.routingTable = newTable;
            for (KBucketEntry e : entry.bucket.getEntries()) {
                this.insertEntry(e, true);
            }
            for (KBucketEntry e : entry.bucket.getReplacementEntries()) {
                this.insertEntry(e, true);
            }
        }
    }

    public static int findIdxForId(List<RoutingTableEntry> table, Key id) {
        int lowerBound = 0;
        int upperBound = table.size() - 1;
        while (lowerBound <= upperBound) {
            int pivotIdx = lowerBound + upperBound >>> 1;
            Prefix pivot = table.get((int)pivotIdx).prefix;
            if (pivot.isPrefixOf(id)) {
                return pivotIdx;
            }
            if (pivot.compareTo(id) < 0) {
                lowerBound = pivotIdx + 1;
                continue;
            }
            upperBound = pivotIdx - 1;
        }
        throw new IllegalStateException("This shouldn't happen, really");
    }

    public RoutingTableEntry findBucketForId(Key id) {
        List<RoutingTableEntry> table = this.routingTable;
        return table.get(Node.findIdxForId(table, id));
    }

    public Key getRootID() {
        if (dataStore != null) {
            return (Key)dataStore.get("commonKey");
        }
        return Key.MIN_KEY;
    }

    public Set<Key> allLocalIDs() {
        return this.usedIDs.keySet();
    }

    public DHT getDHT() {
        return this.dht;
    }

    void onTimeout(RPCCallBase call) {
        if (this.survivalMode) {
            return;
        }
        InetSocketAddress dest = call.getRequest().getDestination();
        if (call.getExpectedID() != null) {
            this.findBucketForId(call.getExpectedID()).bucket.onTimeout(dest);
        } else {
            RoutingTableEntry entry = this.knownNodes.get(dest);
            if (entry != null) {
                entry.bucket.onTimeout(dest);
            }
        }
    }

    public boolean isInSurvivalMode() {
        return this.survivalMode;
    }

    void removeServer(RPCServer server) {
        if (server.getDerivedID() != null) {
            this.usedIDs.remove(server.getDerivedID(), server);
        }
    }

    Key registerServer(RPCServer server) {
        int idx = 0;
        Key k = null;
        while (this.usedIDs.putIfAbsent(k = this.getRootID().getDerivedKey(idx), server) != null) {
            ++idx;
        }
        return k;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void doBucketChecks(long now) {
        void var3_8;
        if (this.num_receives != this.numReceivesAtLastCheck) {
            if (this.survivalMode) {
                if (this.timeOfRecovery == 0L) {
                    this.timeOfRecovery = now;
                    this.timeOfLastPingCheck = 0L;
                }
                if (now - this.timeOfRecovery > 120000L) {
                    this.survivalMode = false;
                    this.timeOfRecovery = 0L;
                }
            }
            this.timeOfLastReceiveCountChange = now;
            this.numReceivesAtLastCheck = this.num_receives;
        } else if (now - this.timeOfLastReceiveCountChange > 60000L) {
            this.survivalMode = true;
            for (RPCServer rPCServer : this.dht.getServers()) {
                rPCServer.getTimeoutFilter().reset();
            }
            this.timeOfRecovery = 0L;
        }
        if (this.survivalMode && now - this.timeOfLastPingCheck > 240000L) {
            return;
        }
        this.timeOfLastPingCheck = now;
        Object object = this.routingTableCoWLock;
        synchronized (object) {
            int i = 1;
            while (i < this.routingTable.size()) {
                RoutingTableEntry e1 = this.routingTable.get(i - 1);
                RoutingTableEntry e2 = this.routingTable.get(i);
                if (e1.prefix.isSiblingOf(e2.prefix)) {
                    ArrayList<RoutingTableEntry> newTable;
                    if (e1.getBucket().getNumEntries() == 0) {
                        newTable = new ArrayList<RoutingTableEntry>(this.routingTable);
                        newTable.remove(e1);
                        newTable.remove(e2);
                        newTable.add(new RoutingTableEntry(e2.prefix.getParentPrefix(), e2.getBucket()));
                        Collections.sort(newTable);
                        this.routingTable = newTable;
                        --i;
                    } else if (e2.getBucket().getNumEntries() == 0) {
                        newTable = new ArrayList<RoutingTableEntry>(this.routingTable);
                        newTable.remove(e1);
                        newTable.remove(e2);
                        newTable.add(new RoutingTableEntry(e1.prefix.getParentPrefix(), e1.getBucket()));
                        Collections.sort(newTable);
                        this.routingTable = newTable;
                        --i;
                    } else if (e1.getBucket().getNumEntries() + e2.getBucket().getNumEntries() < 8) {
                        newTable = new ArrayList<RoutingTableEntry>(this.routingTable);
                        newTable.remove(e1);
                        newTable.remove(e2);
                        newTable.add(new RoutingTableEntry(e1.prefix.getParentPrefix(), new KBucket(this)));
                        Collections.sort(newTable);
                        this.routingTable = newTable;
                        for (KBucketEntry e : e1.bucket.getEntries()) {
                            this.insertEntry(e, true);
                        }
                        for (KBucketEntry e : e2.bucket.getEntries()) {
                            this.insertEntry(e, true);
                        }
                        --i;
                    }
                }
                ++i;
            }
        }
        boolean bl = false;
        for (RoutingTableEntry e : this.routingTable) {
            KBucket b = e.bucket;
            List<KBucketEntry> entries = b.getEntries();
            boolean wasFull = b.getNumEntries() >= 8;
            boolean allBad = true;
            for (KBucketEntry entry : entries) {
                if (wasFull && DHTConstants.BOOTSTRAP_NODE_ADDRESSES.contains(entry.getAddress())) {
                    b.removeEntry(entry, true);
                }
                if (this.allLocalIDs().contains(entry.getID())) {
                    b.removeEntry(entry, true);
                }
                allBad &= entry.isBad();
            }
            if (!this.survivalMode && allBad) {
                e.bucket = new KBucket(this);
                continue;
            }
            if (b.needsToBeRefreshed()) {
                DHT.logDebug("Refreshing Bucket: " + e.prefix);
                PingRefreshTask nl = this.dht.refreshBucket(b);
                if (nl != null) {
                    b.setRefreshTask(nl);
                    nl.setInfo("Refreshing Bucket #" + e.prefix);
                }
            } else if (!this.survivalMode) {
                b.checkBadEntries();
            }
            var3_8 += e.bucket.getNumEntries();
        }
        this.num_entries = var3_8;
        this.rebuildAddressCache();
    }

    private void rebuildAddressCache() {
        LightHashMap<InetSocketAddress, RoutingTableEntry> newKnownMap = new LightHashMap<InetSocketAddress, RoutingTableEntry>(this.num_entries);
        List<RoutingTableEntry> table = this.routingTable;
        int i = 0;
        int n = table.size();
        while (i < n) {
            RoutingTableEntry entry = table.get(i);
            List<KBucketEntry> entries = entry.bucket.getEntries();
            int j = 0;
            int m = entries.size();
            while (j < m) {
                newKnownMap.put(entries.get(j).getAddress(), entry);
                ++j;
            }
            ++i;
        }
        this.knownNodes = newKnownMap;
    }

    public void fillBuckets(DHTBase dh_table) {
        int i = 0;
        while (i < this.routingTable.size()) {
            RoutingTableEntry entry = this.routingTable.get(i);
            if (entry.bucket.getNumEntries() < 8) {
                DHT.logDebug("Filling Bucket: " + entry.prefix);
                NodeLookup nl = dh_table.fillBucket(entry.prefix.createRandomKeyFromPrefix(), entry.bucket);
                if (nl != null) {
                    entry.bucket.setRefreshTask(nl);
                    nl.setInfo("Filling Bucket #" + entry.prefix);
                }
            }
            ++i;
        }
    }

    void saveTable(File file, boolean forClose) throws IOException {
        if (dataStore == null) {
            return;
        }
        ObjectOutputStream oos = null;
        File tempFile = new File(String.valueOf(file.getPath()) + ".tmp");
        try {
            oos = new ObjectOutputStream(new FileOutputStream(tempFile));
            HashMap<String, Object> tableMap = new HashMap<String, Object>();
            dataStore.put("table" + this.dht.getType().name(), tableMap);
            tableMap.put("oldKey", this.getRootID());
            KBucket[] bucket = new KBucket[this.routingTable.size()];
            int i = 0;
            while (i < bucket.length) {
                bucket[i] = this.routingTable.get(i).bucket;
                ++i;
            }
            tableMap.put("bucket", bucket);
            tableMap.put("log2estimate", this.dht.getEstimator().getRawDistanceEstimate());
            tableMap.put("timestamp", System.currentTimeMillis());
            oos.writeObject(dataStore);
            oos.close();
            if (!file.exists() || file.delete()) {
                tempFile.renameTo(file);
            }
        }
        finally {
            if (oos != null) {
                oos.close();
            }
        }
        if (forClose) {
            dataStore = null;
        }
    }

    /*
     * Unable to fully structure code
     */
    static synchronized void initDataStore(DHTConfiguration config) {
        block21: {
            block22: {
                file = config.getNodeCachePath();
                if (Node.dataStore != null) {
                    return;
                }
                ois = null;
                if (file.exists()) break block21;
                if (ois == null) break block22;
                try {
                    ois.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (Node.dataStore == null) {
                Node.dataStore = new HashMap<String, Serializable>();
                Node.dataStore.put("commonKey", Key.createRandomKey());
            }
            return;
        }
        try {
            try {
                ois = new ObjectInputStream(new FileInputStream(file));
                Node.dataStore = (Map)ois.readObject();
            }
            catch (Exception e) {
                e.printStackTrace();
                if (ois != null) {
                    try {
                        ois.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (Node.dataStore != null) ** GOTO lbl61
                Node.dataStore = new HashMap<String, Serializable>();
                Node.dataStore.put("commonKey", Key.createRandomKey());
            }
        }
        catch (Throwable var4_8) {
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (Node.dataStore == null) {
                Node.dataStore = new HashMap<String, Serializable>();
                Node.dataStore.put("commonKey", Key.createRandomKey());
            }
            throw var4_8;
        }
        if (ois != null) {
            try {
                ois.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (Node.dataStore == null) {
            Node.dataStore = new HashMap<String, Serializable>();
            Node.dataStore.put("commonKey", Key.createRandomKey());
        }
lbl61:
        // 5 sources

        if (!config.isPersistingID()) {
            Node.dataStore.put("commonKey", Key.createRandomKey());
        }
    }

    void loadTable(final Runnable runWhenLoaded) {
        boolean runDeferred = false;
        try {
            PingRefreshTask prt;
            Map table = (Map)((Object)dataStore.get("table" + this.dht.getType().name()));
            if (table == null) {
                return;
            }
            KBucket[] loadedBuckets = (KBucket[])table.get("bucket");
            Key oldID = (Key)table.get("oldKey");
            this.dht.getEstimator().setInitialRawDistanceEstimate((Double)table.get("log2estimate"));
            long timestamp = (Long)table.get("timestamp");
            int entriesLoaded = 0;
            int i = 0;
            while (i < loadedBuckets.length) {
                KBucket b = loadedBuckets[i];
                if (b != null) {
                    entriesLoaded += b.getNumEntries();
                    entriesLoaded += b.getReplacementEntries().size();
                    for (KBucketEntry e : b.getEntries()) {
                        this.insertEntry(e, true);
                    }
                    for (KBucketEntry e : b.getReplacementEntries()) {
                        this.insertEntry(e, true);
                    }
                }
                ++i;
            }
            this.rebuildAddressCache();
            if (entriesLoaded > 0 && (prt = this.dht.refreshBuckets(this.routingTable, true)) != null) {
                runDeferred = true;
                prt.setInfo("Pinging cached entries.");
                TaskListener bootstrapListener = new TaskListener(){

                    @Override
                    public void finished(Task t) {
                        if (runWhenLoaded != null) {
                            runWhenLoaded.run();
                        }
                    }
                };
                prt.addListener(bootstrapListener);
            }
            DHT.logInfo("Loaded " + entriesLoaded + " from cache. Cache was " + (System.currentTimeMillis() - timestamp) / 60000L + "min old. Reusing old id = " + oldID.equals(this.getRootID()));
            return;
        }
        catch (Throwable e) {
            DHT.logError("Failed to load from cache: " + Debug.getNestedExceptionMessage(e));
        }
        finally {
            if (!runDeferred && runWhenLoaded != null) {
                runWhenLoaded.run();
            }
        }
    }

    public int getNumEntriesInRoutingTable() {
        return this.num_entries;
    }

    public List<RoutingTableEntry> getBuckets() {
        return Collections.unmodifiableList(this.routingTable);
    }

    public static final class RoutingTableEntry
    implements Comparable<RoutingTableEntry> {
        public final Prefix prefix;
        private KBucket bucket;

        public RoutingTableEntry(Prefix prefix, KBucket bucket) {
            this.prefix = prefix;
            this.bucket = bucket;
        }

        public KBucket getBucket() {
            return this.bucket;
        }

        @Override
        public int compareTo(RoutingTableEntry o) {
            return this.prefix.compareTo(o.prefix);
        }
    }
}

