/*
 * Decompiled with CFR 0.152.
 */
package com.vuze.client.plugins.utp.core;

import com.vuze.client.plugins.utp.core.UTPCallback;
import com.vuze.client.plugins.utp.core.UTPInterfaceException;
import java.io.File;
import org.gudy.azureus2.core3.util.Constants;

public class UTPInterface {
    private static final boolean DEBUG_DLLS = false;

    public static boolean load(UTPCallback callback) {
        File plugin_user_dir = callback.getPluginUserDir();
        File plugin_install_dir = callback.getPluginInstallDir();
        File log_file = null;
        try {
            log_file = new File(new File(plugin_user_dir.getParentFile().getParentFile(), "logs"), "uTP_native.log");
            if (log_file.exists() && log_file.length() > 0x100000L) {
                File bak = new File(String.valueOf(log_file.getAbsolutePath()) + ".bak");
                bak.delete();
                log_file.renameTo(bak);
            }
        }
        catch (Throwable e) {
            callback.log("Failed to tidy up old log files", e);
        }
        try {
            if (Constants.isWindows) {
                File dll_dir = System.getProperty("os.arch", "").contains("64") ? new File(plugin_install_dir, "x64") : new File(plugin_install_dir, "win32");
                System.load(new File(dll_dir, "msvcr100.dll").getAbsolutePath());
                System.load(new File(dll_dir, "utp.dll").getAbsolutePath());
            } else if (Constants.isOSX_10_5_OrHigher) {
                System.load(new File(plugin_install_dir, "libutp.jnilib").getAbsolutePath());
            } else {
                throw new Exception("Unsupported platform");
            }
            UTPInterface.initialise(Constants.IS_CVS_VERSION ? log_file.getAbsolutePath() : null, callback);
            return true;
        }
        catch (Throwable e) {
            callback.log("Failed to load dll", e);
            return false;
        }
    }

    private static native void initialise(String var0, UTPCallback var1) throws UTPInterfaceException;

    public static native void checkTimeouts();

    public static native long[] connect(String var0, int var1) throws UTPInterfaceException;

    public static native boolean receive(String var0, int var1, byte[] var2, int var3) throws UTPInterfaceException;

    public static native boolean write(long var0, int var2) throws UTPInterfaceException;

    public static native void receiveBufferDrained(long var0) throws UTPInterfaceException;

    public static native void close(long var0) throws UTPInterfaceException;

    public static native void setSocketOptions(long var0) throws UTPInterfaceException;
}

