/*
 * Decompiled with CFR 0.152.
 */
package com.vuze.android.core.az;

import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.plugins.xmwebui.client.XMRPCClientTest;
import com.aelitis.azureus.plugins.xmwebui.client.connect.XMClientAccount;
import com.aelitis.azureus.plugins.xmwebui.client.connect.XMClientConnection;
import com.aelitis.azureus.plugins.xmwebui.client.connect.XMClientConnectionAdapter;
import java.io.File;
import java.util.List;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.ui.console.ConsoleInput;
import org.gudy.azureus2.ui.console.commands.IConsoleCommand;

public class ConsoleDebugCommand
extends IConsoleCommand {
    private XMClientConnection current_connection;

    public ConsoleDebugCommand() {
        super("andro");
    }

    @Override
    public String getCommandDescriptions() {
        return "andro xmtest";
    }

    @Override
    public void execute(String cmd, final ConsoleInput console, List<String> arguments) {
        if (arguments.size() < 1) {
            console.out.println("Invalid sub-command");
            return;
        }
        String sub_cmd = arguments.get(0);
        List<String> args = arguments.subList(1, arguments.size());
        if (sub_cmd.equalsIgnoreCase("xmtest")) {
            XMRPCClientTest.main(args.toArray(new String[args.size()]));
        } else if (sub_cmd.equalsIgnoreCase("xmcon_open")) {
            if (this.current_connection != null) {
                console.out.println("Already connected");
            } else {
                this.current_connection = new XMClientConnection(new Account(args), new XMClientConnectionAdapter(){

                    @Override
                    public void setConnected(XMClientConnection connection, boolean connected) {
                        if (connected) {
                            console.out.println("Proxy: " + connection.getProxyURL());
                        } else {
                            console.out.println("Not connected");
                        }
                    }

                    @Override
                    public void logError(String str) {
                        console.out.println("Error: " + str);
                    }

                    @Override
                    public void log(String str) {
                        console.out.println(str);
                    }
                });
                this.current_connection.connect();
            }
        } else if (sub_cmd.equalsIgnoreCase("xmcon_close")) {
            if (this.current_connection != null) {
                this.current_connection.destroy();
                this.current_connection = null;
            } else {
                console.out.println("Not connected");
            }
        }
    }

    private class Account
    implements XMClientAccount {
        private final boolean FORCE_PROXY = true;
        private String access_code;
        private String secure_pw;

        private Account(List<String> args) {
            this.access_code = args.get(0);
            this.secure_pw = args.get(1);
        }

        @Override
        public String getAccessCode() {
            return this.access_code;
        }

        @Override
        public boolean isBasicEnabled() {
            return false;
        }

        @Override
        public boolean isBasicDefaults() {
            return true;
        }

        @Override
        public String getBasicUser() {
            return "";
        }

        @Override
        public String getBasicPassword() {
            return "";
        }

        @Override
        public boolean isForceProxy() {
            return true;
        }

        @Override
        public String getSecureUser() {
            return "vuze";
        }

        @Override
        public String getSecurePassword() {
            return this.secure_pw;
        }

        @Override
        public File getResourceDir() {
            PluginInterface pi;
            File plugin_dir;
            File web;
            if (AzureusCoreFactory.isCoreRunning() && (web = new File(new File(plugin_dir = new File((pi = AzureusCoreFactory.getSingleton().getPluginManager().getPluginInterfaceByID("xmwebui")).getPluginDirectoryName()), "transmission"), "web")).exists()) {
                return web;
            }
            return new File("C:\\Test\\android\\sdcard\\plugins\\xmwebui\\transmission\\web");
        }
    }
}

