/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.magnet;

import com.aelitis.azureus.core.proxy.AEProxyFactory;
import com.aelitis.azureus.core.tag.Tag;
import com.aelitis.azureus.core.tag.TagManagerFactory;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.plugins.magnet.MagnetPluginListener;
import com.aelitis.azureus.plugins.magnet.MagnetPluginProgressListener;
import com.aelitis.net.magneturi.MagnetURIHandler;
import com.aelitis.net.magneturi.MagnetURIHandlerException;
import com.aelitis.net.magneturi.MagnetURIHandlerListener;
import com.aelitis.net.magneturi.MagnetURIHandlerProgressListener;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentAnnounceURLGroup;
import org.gudy.azureus2.core3.torrent.TOTorrentAnnounceURLSet;
import org.gudy.azureus2.core3.torrent.TOTorrentFactory;
import org.gudy.azureus2.core3.util.AENetworkClassifier;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.ByteArrayHashMap;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginListener;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadException;
import org.gudy.azureus2.plugins.sharing.ShareException;
import org.gudy.azureus2.plugins.sharing.ShareResourceDir;
import org.gudy.azureus2.plugins.sharing.ShareResourceFile;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.ui.UIInstance;
import org.gudy.azureus2.plugins.ui.UIManagerListener;
import org.gudy.azureus2.plugins.ui.config.BooleanParameter;
import org.gudy.azureus2.plugins.ui.config.IntParameter;
import org.gudy.azureus2.plugins.ui.config.Parameter;
import org.gudy.azureus2.plugins.ui.menus.MenuItem;
import org.gudy.azureus2.plugins.ui.menus.MenuItemListener;
import org.gudy.azureus2.plugins.ui.model.BasicPluginConfigModel;
import org.gudy.azureus2.plugins.ui.tables.TableContextMenuItem;
import org.gudy.azureus2.plugins.ui.tables.TableRow;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderAdapter;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderException;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderFactory;
import org.gudy.azureus2.pluginsimpl.local.PluginCoreUtils;

public class MagnetPlugin
implements Plugin {
    public static final int FL_NONE = 0;
    public static final int FL_DISABLE_MD_LOOKUP = 1;
    private static final String SECONDARY_LOOKUP = "http://magnet.vuze.com/";
    private static final int SECONDARY_LOOKUP_DELAY = 20000;
    private static final int SECONDARY_LOOKUP_MAX_TIME = 120000;
    private static final int MD_LOOKUP_DELAY_SECS_DEFAULT = 20;
    private static final String PLUGIN_NAME = "Magnet URI Handler";
    private static final String PLUGIN_CONFIGSECTION_ID = "plugins.magnetplugin";
    private PluginInterface plugin_interface;
    private CopyOnWriteList listeners = new CopyOnWriteList();
    private boolean first_download = true;
    private static final int PLUGIN_DOWNLOAD_TIMEOUT_SECS_DEFAULT = 600;
    private BooleanParameter secondary_lookup;
    private BooleanParameter md_lookup;
    private IntParameter md_lookup_delay;
    private IntParameter timeout_param;
    private Map<String, BooleanParameter> net_params = new HashMap<String, BooleanParameter>();
    private static ByteArrayHashMap<DownloadActivity> download_activities = new ByteArrayHashMap();

    public static void load(PluginInterface plugin_interface) {
        plugin_interface.getPluginProperties().setProperty("plugin.version", "1.0");
        plugin_interface.getPluginProperties().setProperty("plugin.name", PLUGIN_NAME);
    }

    @Override
    public void initialize(PluginInterface _plugin_interface) {
        Download[] downloads;
        this.plugin_interface = _plugin_interface;
        MagnetURIHandler uri_handler = MagnetURIHandler.getSingleton();
        BasicPluginConfigModel config = this.plugin_interface.getUIManager().createBasicPluginConfigModel("plugins", PLUGIN_CONFIGSECTION_ID);
        config.addInfoParameter2("MagnetPlugin.current.port", String.valueOf(uri_handler.getPort()));
        this.secondary_lookup = config.addBooleanParameter2("MagnetPlugin.use.lookup.service", "MagnetPlugin.use.lookup.service", true);
        this.md_lookup = config.addBooleanParameter2("MagnetPlugin.use.md.download", "MagnetPlugin.use.md.download", true);
        this.md_lookup_delay = config.addIntParameter2("MagnetPlugin.use.md.download.delay", "MagnetPlugin.use.md.download.delay", 20);
        this.md_lookup.addEnabledOnSelection(this.md_lookup_delay);
        this.timeout_param = config.addIntParameter2("MagnetPlugin.timeout.secs", "MagnetPlugin.timeout.secs", 600);
        Parameter[] nps = new Parameter[AENetworkClassifier.AT_NETWORKS.length];
        int i = 0;
        while (i < nps.length) {
            String nn = AENetworkClassifier.AT_NETWORKS[i];
            String config_name = "Network Selection Default." + nn;
            String msg_text = "ConfigView.section.connection.networks." + nn;
            final BooleanParameter param = config.addBooleanParameter2(config_name, msg_text, COConfigurationManager.getBooleanParameter(config_name));
            COConfigurationManager.addParameterListener(config_name, new ParameterListener(){

                @Override
                public void parameterChanged(String name) {
                    param.setDefaultValue(COConfigurationManager.getBooleanParameter(name));
                }
            });
            nps[i] = param;
            this.net_params.put(nn, param);
            ++i;
        }
        config.createGroup("label.default.nets", nps);
        MenuItemListener listener = new MenuItemListener(){

            @Override
            public void selected(MenuItem _menu, Object _target) {
                TableRow[] rows = (TableRow[])_target;
                String cb_all_data = "";
                TableRow[] tableRowArray = rows;
                int n = rows.length;
                int n2 = 0;
                while (n2 < n) {
                    block12: {
                        String cb_data;
                        String name;
                        Torrent torrent;
                        Download download;
                        block14: {
                            Object ds;
                            block15: {
                                block13: {
                                    TableRow row = tableRowArray[n2];
                                    ds = row.getDataSource();
                                    download = null;
                                    if (!(ds instanceof ShareResourceFile)) break block13;
                                    try {
                                        torrent = ((ShareResourceFile)ds).getItem().getTorrent();
                                    }
                                    catch (ShareException e) {
                                        break block12;
                                    }
                                    name = ((ShareResourceFile)ds).getName();
                                    break block14;
                                }
                                if (!(ds instanceof ShareResourceDir)) break block15;
                                try {
                                    torrent = ((ShareResourceDir)ds).getItem().getTorrent();
                                }
                                catch (ShareException e) {
                                    break block12;
                                }
                                name = ((ShareResourceDir)ds).getName();
                                break block14;
                            }
                            if (!(ds instanceof Download)) break block12;
                            download = (Download)ds;
                            torrent = download.getTorrent();
                            name = download.getName();
                        }
                        String string = cb_data = download == null ? UrlUtils.getMagnetURI(name, torrent) : UrlUtils.getMagnetURI(download);
                        if (download != null) {
                            List<Tag> tags = TagManagerFactory.getTagManager().getTagsForTaggable(3, PluginCoreUtils.unwrap(download));
                            for (Tag tag : tags) {
                                if (!tag.isPublic()) continue;
                                cb_data = String.valueOf(cb_data) + "&tag=" + UrlUtils.encode(tag.getTagName(true));
                            }
                        }
                        cb_all_data = String.valueOf(cb_all_data) + (cb_all_data.length() == 0 ? "" : "\n") + cb_data;
                    }
                    ++n2;
                }
                try {
                    MagnetPlugin.this.plugin_interface.getUIManager().copyToClipBoard(cb_all_data);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        };
        final TableContextMenuItem menu1 = this.plugin_interface.getUIManager().getTableManager().addContextMenuItem("MyTorrents", "MagnetPlugin.contextmenu.exporturi");
        final TableContextMenuItem menu2 = this.plugin_interface.getUIManager().getTableManager().addContextMenuItem("MySeeders", "MagnetPlugin.contextmenu.exporturi");
        final TableContextMenuItem menu3 = this.plugin_interface.getUIManager().getTableManager().addContextMenuItem("MyShares", "MagnetPlugin.contextmenu.exporturi");
        menu1.addMultiListener(listener);
        menu2.addMultiListener(listener);
        menu3.addMultiListener(listener);
        uri_handler.addListener(new MagnetURIHandlerListener(){

            @Override
            public byte[] badge() {
                InputStream is = this.getClass().getClassLoader().getResourceAsStream("com/aelitis/azureus/plugins/magnet/Magnet.gif");
                if (is == null) {
                    return null;
                }
                try {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    try {
                        int len;
                        byte[] buffer = new byte[8192];
                        while ((len = is.read(buffer)) > 0) {
                            baos.write(buffer, 0, len);
                        }
                    }
                    finally {
                        is.close();
                    }
                    return baos.toByteArray();
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                    return null;
                }
            }

            @Override
            public byte[] download(final MagnetURIHandlerProgressListener muh_listener, byte[] hash, String args, InetSocketAddress[] sources, long timeout) throws MagnetURIHandlerException {
                try {
                    Torrent torrent;
                    Download dl = MagnetPlugin.this.plugin_interface.getDownloadManager().getDownload(hash);
                    if (dl != null && (torrent = dl.getTorrent()) != null) {
                        byte[] torrent_data = torrent.writeToBEncodedData();
                        torrent_data = MagnetPlugin.this.addTrackersAndWebSeedsEtc(torrent_data, args, new HashSet());
                        return torrent_data;
                    }
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
                return MagnetPlugin.this.download(new MagnetPluginProgressListener(){

                    @Override
                    public void reportSize(long size) {
                        muh_listener.reportSize(size);
                    }

                    @Override
                    public void reportActivity(String str) {
                        muh_listener.reportActivity(str);
                    }

                    @Override
                    public void reportCompleteness(int percent) {
                        muh_listener.reportCompleteness(percent);
                    }

                    @Override
                    public void reportContributor(InetSocketAddress address) {
                    }

                    @Override
                    public boolean cancelled() {
                        return muh_listener.cancelled();
                    }

                    @Override
                    public boolean verbose() {
                        return muh_listener.verbose();
                    }
                }, hash, args, sources, timeout, 0);
            }

            @Override
            public boolean download(URL url) throws MagnetURIHandlerException {
                try {
                    MagnetPlugin.this.plugin_interface.getDownloadManager().addDownload(url, false);
                    return true;
                }
                catch (DownloadException e) {
                    throw new MagnetURIHandlerException("Operation failed", e);
                }
            }

            @Override
            public boolean set(String name, Map values) {
                List l = MagnetPlugin.this.listeners.getList();
                int i = 0;
                while (i < l.size()) {
                    if (((MagnetPluginListener)l.get(i)).set(name, values)) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }

            @Override
            public int get(String name, Map values) {
                List l = MagnetPlugin.this.listeners.getList();
                int i = 0;
                while (i < l.size()) {
                    int res = ((MagnetPluginListener)l.get(i)).get(name, values);
                    if (res != Integer.MIN_VALUE) {
                        return res;
                    }
                    ++i;
                }
                return Integer.MIN_VALUE;
            }
        });
        this.plugin_interface.addListener(new PluginListener(){

            @Override
            public void initializationComplete() {
                AEThread2 t = new AEThread2("MagnetPlugin:init", true){

                    @Override
                    public void run() {
                        MagnetPlugin.this.plugin_interface.getDistributedDatabase();
                    }
                };
                t.start();
            }

            @Override
            public void closedownInitiated() {
            }

            @Override
            public void closedownComplete() {
            }
        });
        this.plugin_interface.getUIManager().addUIListener(new UIManagerListener(){

            @Override
            public void UIAttached(UIInstance instance) {
                if (instance.getUIType() == 1) {
                    try {
                        Class.forName("com.aelitis.azureus.plugins.magnet.swt.MagnetPluginUISWT").getConstructor(UIInstance.class, TableContextMenuItem[].class).newInstance(instance, new TableContextMenuItem[]{menu1, menu2, menu3});
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
            }

            @Override
            public void UIDetached(UIInstance instance) {
            }
        });
        final ArrayList<Download> to_delete = new ArrayList<Download>();
        Download[] downloadArray = downloads = this.plugin_interface.getDownloadManager().getDownloads();
        int n = downloads.length;
        int n2 = 0;
        while (n2 < n) {
            Download download = downloadArray[n2];
            if (download.getFlag(512L)) {
                to_delete.add(download);
            }
            ++n2;
        }
        if (to_delete.size() > 0) {
            AEThread2 t = new AEThread2("MagnetPlugin:delmds", true){

                @Override
                public void run() {
                    for (Download download : to_delete) {
                        try {
                            download.stop();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        try {
                            download.remove(true, true);
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                    }
                }
            };
            t.start();
        }
    }

    public boolean isNetworkEnabled(String net) {
        return this.net_params.get(net).getValue();
    }

    public URL getMagnetURL(Download d) {
        Torrent torrent = d.getTorrent();
        if (torrent == null) {
            return null;
        }
        return this.getMagnetURL(torrent.getHash());
    }

    public URL getMagnetURL(byte[] hash) {
        try {
            return new URL("magnet:?xt=urn:btih:" + Base32.encode(hash));
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            return null;
        }
    }

    public byte[] badge() {
        return null;
    }

    public byte[] download(MagnetPluginProgressListener listener, byte[] hash, String args, InetSocketAddress[] sources, long timeout, int flags) throws MagnetURIHandlerException {
        DownloadResult result = this.downloadSupport(listener, hash, args, sources, timeout, flags);
        if (result == null) {
            return null;
        }
        return this.addTrackersAndWebSeedsEtc(result, args);
    }

    private byte[] addTrackersAndWebSeedsEtc(DownloadResult result, String args) {
        byte[] torrent_data = result.getTorrentData();
        Set networks = result.getNetworks();
        return this.addTrackersAndWebSeedsEtc(torrent_data, args, networks);
    }

    private byte[] addTrackersAndWebSeedsEtc(byte[] torrent_data, String args, Set<String> networks) {
        ArrayList<String> new_web_seeds = new ArrayList<String>();
        ArrayList<String> new_trackers = new ArrayList<String>();
        HashSet<String> tags = new HashSet<String>();
        if (args != null) {
            String[] bits;
            String[] stringArray = bits = args.split("&");
            int n = bits.length;
            int n2 = 0;
            while (n2 < n) {
                String bit = stringArray[n2];
                String[] x = bit.split("=");
                if (x.length == 2) {
                    String lhs = x[0].toLowerCase();
                    if (lhs.equals("ws")) {
                        try {
                            new_web_seeds.add(new URL(UrlUtils.decode(x[1])).toExternalForm());
                        }
                        catch (Throwable throwable) {}
                    } else if (lhs.equals("tr")) {
                        try {
                            new_trackers.add(new URL(UrlUtils.decode(x[1])).toExternalForm());
                        }
                        catch (Throwable throwable) {}
                    } else if (lhs.equals("tag")) {
                        tags.add(UrlUtils.decode(x[1]));
                    }
                }
                ++n2;
            }
        }
        if (new_web_seeds.size() > 0 || new_trackers.size() > 0 || networks.size() > 0) {
            try {
                TOTorrent torrent = TOTorrentFactory.deserialiseFromBEncodedByteArray(torrent_data);
                boolean update_torrent = false;
                if (new_web_seeds.size() > 0) {
                    Object obj = torrent.getAdditionalProperty("url-list");
                    ArrayList<String> existing = new ArrayList<String>();
                    if (obj instanceof byte[]) {
                        try {
                            new_web_seeds.remove(new URL(new String((byte[])obj, "UTF-8")).toExternalForm());
                        }
                        catch (Throwable throwable) {}
                    } else if (obj instanceof List) {
                        List l = (List)obj;
                        for (byte[] b : l) {
                            try {
                                existing.add(new URL(new String(b, "UTF-8")).toExternalForm());
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                    }
                    boolean update_ws = false;
                    for (String e : new_web_seeds) {
                        if (existing.contains(e)) continue;
                        existing.add(e);
                        update_ws = true;
                    }
                    if (update_ws) {
                        ArrayList<byte[]> l = new ArrayList<byte[]>();
                        for (String s : existing) {
                            l.add(s.getBytes("UTF-8"));
                        }
                        torrent.setAdditionalProperty("url-list", l);
                        update_torrent = true;
                    }
                }
                if (new_trackers.size() > 0) {
                    TOTorrentAnnounceURLSet[] sets;
                    URL announce_url = torrent.getAnnounceURL();
                    new_trackers.remove(announce_url.toExternalForm());
                    TOTorrentAnnounceURLGroup group = torrent.getAnnounceURLGroup();
                    TOTorrentAnnounceURLSet[] tOTorrentAnnounceURLSetArray = sets = group.getAnnounceURLSets();
                    int n = sets.length;
                    int s = 0;
                    while (s < n) {
                        URL[] set_urls;
                        TOTorrentAnnounceURLSet set = tOTorrentAnnounceURLSetArray[s];
                        URL[] uRLArray = set_urls = set.getAnnounceURLs();
                        int n3 = set_urls.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            URL set_url = uRLArray[n4];
                            new_trackers.remove(set_url.toExternalForm());
                            ++n4;
                        }
                        ++s;
                    }
                    if (new_trackers.size() > 0) {
                        TOTorrentAnnounceURLSet[] new_sets = new TOTorrentAnnounceURLSet[sets.length + new_trackers.size()];
                        int i = 0;
                        while (i < sets.length) {
                            new_sets[i] = sets[i];
                            ++i;
                        }
                        i = 0;
                        while (i < new_trackers.size()) {
                            TOTorrentAnnounceURLSet new_set;
                            new_sets[i + sets.length] = new_set = group.createAnnounceURLSet(new URL[]{new URL((String)new_trackers.get(i))});
                            ++i;
                        }
                        group.setAnnounceURLSets(new_sets);
                        update_torrent = true;
                    }
                }
                if (networks.size() > 0) {
                    TorrentUtils.setNetworkCache(torrent, new ArrayList<String>(networks));
                    update_torrent = true;
                }
                if (tags.size() > 0) {
                    TorrentUtils.setTagCache(torrent, new ArrayList<String>(tags));
                    update_torrent = true;
                }
                if (update_torrent) {
                    torrent_data = BEncoder.encode(torrent.serialiseToMap());
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return torrent_data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DownloadResult downloadSupport(MagnetPluginProgressListener listener, byte[] hash, String args, InetSocketAddress[] sources, long timeout, int flags) throws MagnetURIHandlerException {
        DownloadActivity activity;
        block19: {
            boolean new_activity = false;
            ByteArrayHashMap<DownloadActivity> byteArrayHashMap = download_activities;
            synchronized (byteArrayHashMap) {
                activity = download_activities.get(hash);
                if (activity == null) {
                    activity = new DownloadActivity();
                    download_activities.put(hash, activity);
                    new_activity = true;
                }
            }
            if (new_activity) {
                try {
                    try {
                        activity.setResult(this._downloadSupport(listener, hash, args, sources, timeout, flags));
                    }
                    catch (Throwable e) {
                        activity.setResult(e);
                        ByteArrayHashMap<DownloadActivity> byteArrayHashMap2 = download_activities;
                        synchronized (byteArrayHashMap2) {
                            download_activities.remove(hash);
                            break block19;
                        }
                    }
                }
                catch (Throwable throwable) {
                    ByteArrayHashMap<DownloadActivity> byteArrayHashMap3 = download_activities;
                    synchronized (byteArrayHashMap3) {
                        download_activities.remove(hash);
                    }
                    throw throwable;
                }
                ByteArrayHashMap<DownloadActivity> byteArrayHashMap4 = download_activities;
                synchronized (byteArrayHashMap4) {
                    download_activities.remove(hash);
                }
            }
        }
        return activity.getResult();
    }

    /*
     * Exception decompiling
     */
    private DownloadResult _downloadSupport(MagnetPluginProgressListener listener, byte[] hash, String args, InetSocketAddress[] sources, long _timeout, int flags) throws MagnetURIHandlerException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [55[MONITOR]], but top level block is 98[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void doSecondaryLookup(final MagnetPluginProgressListener listener, final Object[] result, byte[] hash, Set<String> networks_enabled, String args) {
        listener.reportActivity(this.getMessageText("report.secondarylookup", null));
        AEProxyFactory.PluginProxy plugin_proxy = null;
        try {
            ResourceDownloader rd;
            URL original_sl_url;
            URL sl_url = original_sl_url = new URL("http://magnet.vuze.com/magnetLookup?hash=" + Base32.encode(hash) + (args.length() == 0 ? "" : "&args=" + UrlUtils.encode(args)));
            Proxy proxy = null;
            if (!networks_enabled.contains("Public")) {
                plugin_proxy = AEProxyFactory.getPluginProxy("secondary magnet lookup", sl_url);
                if (plugin_proxy == null) {
                    throw new NoRouteToHostException("plugin proxy unavailable");
                }
                proxy = plugin_proxy.getProxy();
                sl_url = plugin_proxy.getURL();
            }
            ResourceDownloaderFactory rdf = this.plugin_interface.getUtilities().getResourceDownloaderFactory();
            if (proxy == null) {
                rd = rdf.create(sl_url);
            } else {
                rd = rdf.create(sl_url, proxy);
                rd.setProperty("URL_HOST", original_sl_url.getHost());
            }
            final AEProxyFactory.PluginProxy f_pp = plugin_proxy;
            rd.addListener(new ResourceDownloaderAdapter(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public boolean completed(ResourceDownloader downloader, InputStream data) {
                    try {
                        listener.reportActivity(MagnetPlugin.this.getMessageText("report.secondarylookup.ok", null));
                        Object[] objectArray = result;
                        synchronized (result) {
                            result[0] = data;
                            // ** MonitorExit[var3_3] (shouldn't be in output)
                            return true;
                        }
                    }
                    finally {
                        this.complete();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void failed(ResourceDownloader downloader, ResourceDownloaderException e) {
                    try {
                        Object[] objectArray = result;
                        synchronized (result) {
                            result[0] = e;
                            // ** MonitorExit[var3_3] (shouldn't be in output)
                            listener.reportActivity(MagnetPlugin.this.getMessageText("report.secondarylookup.fail"));
                        }
                    }
                    finally {
                        this.complete();
                    }
                    {
                        return;
                    }
                }

                private void complete() {
                    if (f_pp != null) {
                        f_pp.setOK(true);
                    }
                }
            });
            rd.asyncDownload();
        }
        catch (Throwable e) {
            if (plugin_proxy != null) {
                plugin_proxy.setOK(true);
            }
            listener.reportActivity(this.getMessageText("report.secondarylookup.fail", Debug.getNestedExceptionMessage(e)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] getSecondaryLookupResult(Object[] result) throws ResourceDownloaderException {
        if (result == null) {
            return null;
        }
        Object[] objectArray = result;
        synchronized (result) {
            Object x = result[0];
            result[0] = null;
            // ** MonitorExit[var3_2] (shouldn't be in output)
            if (x instanceof InputStream) {
                InputStream is = (InputStream)x;
                try {
                    TOTorrent t = TOTorrentFactory.deserialiseFromBEncodedInputStream(is);
                    TorrentUtils.setPeerCacheValid(t);
                    return BEncoder.encode(t.serialiseToMap());
                }
                catch (Throwable throwable) {}
            } else if (x instanceof ResourceDownloaderException) {
                throw (ResourceDownloaderException)x;
            }
            return null;
        }
    }

    protected String getMessageText(String resource) {
        return this.plugin_interface.getUtilities().getLocaleUtilities().getLocalisedMessageText("MagnetPlugin." + resource);
    }

    protected String getMessageText(String resource, String param) {
        return this.plugin_interface.getUtilities().getLocaleUtilities().getLocalisedMessageText("MagnetPlugin." + resource, new String[]{param});
    }

    public void addListener(MagnetPluginListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(MagnetPluginListener listener) {
        this.listeners.remove(listener);
    }

    private static class DownloadActivity {
        private volatile DownloadResult result;
        private volatile MagnetURIHandlerException error;
        private AESemaphore sem = new AESemaphore("MP:DA");

        private DownloadActivity() {
        }

        public void setResult(DownloadResult _result) {
            this.result = _result;
            this.sem.releaseForever();
        }

        public void setResult(Throwable _error) {
            this.error = _error instanceof MagnetURIHandlerException ? (MagnetURIHandlerException)_error : new MagnetURIHandlerException("Download failed", _error);
            this.sem.releaseForever();
        }

        public DownloadResult getResult() throws MagnetURIHandlerException {
            this.sem.reserve();
            if (this.error != null) {
                throw this.error;
            }
            return this.result;
        }
    }

    private class DownloadResult {
        private byte[] data;
        private Set<String> networks;

        private DownloadResult(byte[] torrent_data, Set<String> networks_enabled, Set<String> additional_networks) {
            this.data = torrent_data;
            this.networks = new HashSet<String>();
            this.networks.addAll(networks_enabled);
            this.networks.addAll(additional_networks);
        }

        private byte[] getTorrentData() {
            return this.data;
        }

        private Set<String> getNetworks() {
            return this.networks;
        }
    }
}

