/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.extseed.util;

import com.aelitis.azureus.core.networkmanager.admin.NetworkAdmin;
import com.aelitis.azureus.core.proxy.AEProxyFactory;
import com.aelitis.azureus.plugins.extseed.ExternalSeedException;
import com.aelitis.azureus.plugins.extseed.util.ExternalSeedHTTPDownloader;
import com.aelitis.azureus.plugins.extseed.util.ExternalSeedHTTPDownloaderListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.Socket;
import java.net.URL;
import java.util.HashSet;
import java.util.StringTokenizer;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import org.gudy.azureus2.core3.security.SEPasswordListener;
import org.gudy.azureus2.core3.security.SESecurityManager;
import org.gudy.azureus2.core3.util.AENetworkClassifier;
import org.gudy.azureus2.core3.util.Debug;

public class ExternalSeedHTTPDownloaderRange
implements ExternalSeedHTTPDownloader,
SEPasswordListener {
    public static final String NL = "\r\n";
    private final URL very_original_url;
    private String user_agent;
    private URL redirected_url;
    private int consec_redirect_fails;
    private int last_response;
    private int last_response_retry_after_secs;

    public ExternalSeedHTTPDownloaderRange(URL _url, String _user_agent) {
        this.very_original_url = _url;
        this.user_agent = _user_agent;
    }

    public URL getURL() {
        return this.very_original_url;
    }

    @Override
    public void download(int length, ExternalSeedHTTPDownloaderListener listener, boolean con_fail_is_perm_fail) throws ExternalSeedException {
        this.download(new String[0], new String[0], length, listener, con_fail_is_perm_fail);
    }

    @Override
    public void downloadRange(long offset, int length, ExternalSeedHTTPDownloaderListener listener, boolean con_fail_is_perm_fail) throws ExternalSeedException {
        this.download(new String[]{"Range"}, new String[]{"bytes=" + offset + "-" + (offset + (long)length - 1L)}, length, listener, con_fail_is_perm_fail);
    }

    public void download(String[] prop_names, String[] prop_values, int length, ExternalSeedHTTPDownloaderListener listener, boolean con_fail_is_perm_fail) throws ExternalSeedException {
        block46: {
            boolean connected = false;
            InputStream is = null;
            String outcome = "";
            AEProxyFactory.PluginProxy plugin_proxy = null;
            boolean proxy_ok = false;
            try {
                try {
                    int response;
                    HttpURLConnection connection;
                    SESecurityManager.setThreadPasswordHandler(this);
                    if (NetworkAdmin.getSingleton().hasMissingForcedBind()) {
                        throw new ExternalSeedException("Forced bind address is missing");
                    }
                    HashSet<String> redirect_urls = new HashSet<String>();
                    block12: while (true) {
                        URL original_url;
                        URL current_url = original_url = this.redirected_url == null ? this.very_original_url : this.redirected_url;
                        if (plugin_proxy != null) {
                            plugin_proxy.setOK(true);
                            plugin_proxy = null;
                        }
                        Proxy current_proxy = null;
                        if (AENetworkClassifier.categoriseAddress(original_url.getHost()) != "Public" && (plugin_proxy = AEProxyFactory.getPluginProxy("webseed", original_url)) != null) {
                            current_url = plugin_proxy.getURL();
                            current_proxy = plugin_proxy.getProxy();
                        }
                        int ssl_loop = 0;
                        while (true) {
                            if (ssl_loop >= 2) continue block12;
                            try {
                                String move_to;
                                int time_remaining;
                                connection = current_proxy == null ? (HttpURLConnection)current_url.openConnection() : (HttpURLConnection)current_url.openConnection(current_proxy);
                                if (connection instanceof HttpsURLConnection) {
                                    HttpsURLConnection ssl_con = (HttpsURLConnection)connection;
                                    ssl_con.setHostnameVerifier(new HostnameVerifier(){

                                        @Override
                                        public boolean verify(String host, SSLSession session) {
                                            return true;
                                        }
                                    });
                                }
                                connection.setRequestProperty("Connection", "Keep-Alive");
                                connection.setRequestProperty("User-Agent", this.user_agent);
                                int i = 0;
                                while (i < prop_names.length) {
                                    connection.setRequestProperty(prop_names[i], prop_values[i]);
                                    ++i;
                                }
                                if (plugin_proxy != null) {
                                    connection.setRequestProperty("HOST", String.valueOf(plugin_proxy.getURLHostRewrite()) + (original_url.getPort() == -1 ? "" : ":" + original_url.getPort()));
                                }
                                if ((time_remaining = listener.getPermittedTime()) > 0) {
                                    connection.setConnectTimeout(time_remaining);
                                }
                                connection.connect();
                                time_remaining = listener.getPermittedTime();
                                if (time_remaining < 0) {
                                    throw new IOException("Timeout during connect");
                                }
                                connection.setReadTimeout(time_remaining);
                                connected = true;
                                response = connection.getResponseCode();
                                if (response == 202 || response == 200 || response == 206) {
                                    if (this.redirected_url == null) break block12;
                                    this.consec_redirect_fails = 0;
                                    break block12;
                                }
                                if ((response == 302 || response == 301) && (move_to = connection.getHeaderField("location")) != null) {
                                    if (redirect_urls.contains(move_to) || redirect_urls.size() > 32) {
                                        throw new ExternalSeedException("redirect loop");
                                    }
                                    redirect_urls.add(move_to);
                                    this.redirected_url = new URL(move_to);
                                    continue block12;
                                }
                                if (this.redirected_url == null) break block12;
                                ++this.consec_redirect_fails;
                                this.redirected_url = null;
                                continue block12;
                            }
                            catch (SSLException e) {
                                if (ssl_loop != 0 || SESecurityManager.installServerCertificates(current_url) == null) {
                                    throw e;
                                }
                                ++ssl_loop;
                            }
                        }
                        break;
                    }
                    if (plugin_proxy == null) {
                        URL final_url = connection.getURL();
                        if (this.consec_redirect_fails < 10 && !this.very_original_url.toExternalForm().equals(final_url.toExternalForm())) {
                            this.redirected_url = final_url;
                        }
                    }
                    this.last_response = response;
                    this.last_response_retry_after_secs = -1;
                    if (response == 503) {
                        long retry_after_date = connection.getHeaderFieldDate("Retry-After", -1L);
                        if (retry_after_date <= -1L) {
                            this.last_response_retry_after_secs = connection.getHeaderFieldInt("Retry-After", -1);
                        } else {
                            this.last_response_retry_after_secs = (int)((retry_after_date - System.currentTimeMillis()) / 1000L);
                            if (this.last_response_retry_after_secs < 0) {
                                this.last_response_retry_after_secs = -1;
                            }
                        }
                    }
                    is = connection.getInputStream();
                    proxy_ok = true;
                    if (response == 202 || response == 200 || response == 206) {
                        int pos = 0;
                        byte[] buffer = null;
                        int buffer_pos = 0;
                        int buffer_len = 0;
                        while (pos < length) {
                            int len;
                            if (buffer == null) {
                                buffer = listener.getBuffer();
                                buffer_pos = listener.getBufferPosition();
                                buffer_len = listener.getBufferLength();
                            }
                            listener.setBufferPosition(buffer_pos);
                            int to_read = buffer_len - buffer_pos;
                            int permitted = listener.getPermittedBytes();
                            if (permitted < to_read) {
                                to_read = permitted;
                            }
                            if ((len = is.read(buffer, buffer_pos, to_read)) < 0) break;
                            listener.reportBytesRead(len);
                            pos += len;
                            if ((buffer_pos += len) != buffer_len) continue;
                            listener.done();
                            buffer = null;
                            buffer_pos = 0;
                        }
                        if (pos != length) {
                            String log_str;
                            if (buffer == null) {
                                log_str = "No buffer assigned";
                            } else {
                                log_str = new String(buffer, 0, length);
                                if (log_str.length() > 64) {
                                    log_str = log_str.substring(0, 64);
                                }
                            }
                            outcome = "Connection failed: data too short - " + length + "/" + pos + " [" + log_str + "]";
                            throw new ExternalSeedException(outcome);
                        }
                        outcome = "read " + pos + " bytes";
                        break block46;
                    }
                    outcome = "Connection failed: " + connection.getResponseMessage();
                    ExternalSeedException error = new ExternalSeedException(outcome);
                    error.setPermanentFailure(true);
                    throw error;
                }
                catch (IOException e) {
                    if (con_fail_is_perm_fail && !connected) {
                        outcome = "Connection failed: " + e.getMessage();
                        ExternalSeedException error = new ExternalSeedException(outcome);
                        error.setPermanentFailure(true);
                        throw error;
                    }
                    outcome = "Connection failed: " + Debug.getNestedExceptionMessage(e);
                    if (this.last_response_retry_after_secs >= 0) {
                        outcome = String.valueOf(outcome) + ", Retry-After: " + this.last_response_retry_after_secs + " seconds";
                    }
                    ExternalSeedException excep = new ExternalSeedException(outcome, e);
                    if (e instanceof FileNotFoundException) {
                        excep.setPermanentFailure(true);
                    }
                    throw excep;
                }
                catch (Throwable e) {
                    if (e instanceof ExternalSeedException) {
                        throw (ExternalSeedException)e;
                    }
                    outcome = "Connection failed: " + Debug.getNestedExceptionMessage(e);
                    throw new ExternalSeedException("Connection failed", e);
                }
            }
            finally {
                SESecurityManager.unsetThreadPasswordHandler();
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable) {}
                }
                if (plugin_proxy != null) {
                    plugin_proxy.setOK(proxy_ok);
                }
            }
        }
    }

    @Override
    public void downloadSocket(int length, ExternalSeedHTTPDownloaderListener listener, boolean con_fail_is_perm_fail) throws ExternalSeedException {
        this.downloadSocket(new String[0], new String[0], length, listener, con_fail_is_perm_fail);
    }

    public void downloadSocket(String[] prop_names, String[] prop_values, int length, ExternalSeedHTTPDownloaderListener listener, boolean con_fail_is_perm_fail) throws ExternalSeedException {
        block35: {
            Socket socket = null;
            boolean connected = false;
            AEProxyFactory.PluginProxy plugin_proxy = null;
            boolean proxy_ok = false;
            try {
                try {
                    URL original_url;
                    String output_header = "GET " + this.very_original_url.getPath() + "?" + this.very_original_url.getQuery() + " HTTP/1.1" + NL + "Host: " + this.very_original_url.getHost() + (this.very_original_url.getPort() == -1 ? "" : ":" + this.very_original_url.getPort()) + NL + "Accept: */*" + NL + "Connection: Close" + NL + "User-Agent: " + this.user_agent + NL;
                    int i = 0;
                    while (i < prop_names.length) {
                        output_header = String.valueOf(output_header) + prop_names[i] + ":" + prop_values[i] + NL;
                        ++i;
                    }
                    output_header = String.valueOf(output_header) + NL;
                    int time_remaining = listener.getPermittedTime();
                    URL current_url = original_url = this.very_original_url;
                    Proxy current_proxy = null;
                    if (AENetworkClassifier.categoriseAddress(this.very_original_url.getHost()) != "Public" && (plugin_proxy = AEProxyFactory.getPluginProxy("webseed", original_url)) != null) {
                        current_url = plugin_proxy.getURL();
                        current_proxy = plugin_proxy.getProxy();
                    }
                    if (time_remaining > 0) {
                        socket = current_proxy == null ? new Socket() : new Socket(current_proxy);
                        socket.connect(new InetSocketAddress(current_url.getHost(), current_url.getPort() == -1 ? current_url.getDefaultPort() : current_url.getPort()), time_remaining);
                    } else if (current_proxy == null) {
                        socket = new Socket(current_url.getHost(), current_url.getPort() == -1 ? current_url.getDefaultPort() : current_url.getPort());
                    } else {
                        socket = new Socket(current_proxy);
                        socket.connect(new InetSocketAddress(current_url.getHost(), current_url.getPort() == -1 ? current_url.getDefaultPort() : current_url.getPort()));
                    }
                    connected = true;
                    proxy_ok = true;
                    time_remaining = listener.getPermittedTime();
                    if (time_remaining < 0) {
                        throw new IOException("Timeout during connect");
                    }
                    if (time_remaining > 0) {
                        socket.setSoTimeout(time_remaining);
                    }
                    OutputStream os = socket.getOutputStream();
                    os.write(output_header.getBytes("ISO-8859-1"));
                    os.flush();
                    InputStream is = socket.getInputStream();
                    try {
                        int response;
                        byte[] buffer;
                        String input_header = "";
                        do {
                            int len;
                            if ((len = is.read(buffer = new byte[1])) >= 0) continue;
                            throw new IOException("input too short reading header");
                        } while (!(input_header = String.valueOf(input_header) + (char)buffer[0]).endsWith("\r\n\r\n"));
                        int line_end = input_header.indexOf(NL);
                        if (line_end == -1) {
                            throw new IOException("header too short");
                        }
                        String first_line = input_header.substring(0, line_end);
                        StringTokenizer tok = new StringTokenizer(first_line, " ");
                        tok.nextToken();
                        this.last_response = response = Integer.parseInt(tok.nextToken());
                        this.last_response_retry_after_secs = -1;
                        String response_str = tok.nextToken();
                        if (response == 202 || response == 200 || response == 206) {
                            byte[] buffer2 = null;
                            int buffer_pos = 0;
                            int buffer_len = 0;
                            int pos = 0;
                            while (pos < length) {
                                int len;
                                if (buffer2 == null) {
                                    buffer2 = listener.getBuffer();
                                    buffer_pos = listener.getBufferPosition();
                                    buffer_len = listener.getBufferLength();
                                }
                                int to_read = buffer_len - buffer_pos;
                                int permitted = listener.getPermittedBytes();
                                if (permitted < to_read) {
                                    to_read = permitted;
                                }
                                if ((len = is.read(buffer2, buffer_pos, to_read)) < 0) break;
                                listener.reportBytesRead(len);
                                pos += len;
                                if ((buffer_pos += len) != buffer_len) continue;
                                listener.done();
                                buffer2 = null;
                                buffer_pos = 0;
                            }
                            if (pos != length) {
                                String log_str = buffer2 == null ? "No buffer assigned" : new String(buffer2, 0, buffer_pos > 64 ? 64 : buffer_pos);
                                throw new ExternalSeedException("Connection failed: data too short - " + length + "/" + pos + " [last=" + log_str + "]");
                            }
                            break block35;
                        }
                        if (response == 503) {
                            byte[] buffer3;
                            int len;
                            String data_str = "";
                            while ((len = is.read(buffer3 = new byte[1])) >= 0) {
                                data_str = String.valueOf(data_str) + (char)buffer3[0];
                            }
                            this.last_response_retry_after_secs = Integer.parseInt(data_str);
                            throw new IOException("Server overloaded");
                        }
                        ExternalSeedException error = new ExternalSeedException("Connection failed: " + response_str);
                        error.setPermanentFailure(true);
                        throw error;
                    }
                    finally {
                        is.close();
                    }
                }
                catch (IOException e) {
                    if (con_fail_is_perm_fail && !connected) {
                        ExternalSeedException error = new ExternalSeedException("Connection failed: " + e.getMessage());
                        error.setPermanentFailure(true);
                        throw error;
                    }
                    String outcome = "Connection failed: " + Debug.getNestedExceptionMessage(e);
                    if (this.last_response_retry_after_secs >= 0) {
                        outcome = String.valueOf(outcome) + ", Retry-After: " + this.last_response_retry_after_secs + " seconds";
                    }
                    throw new ExternalSeedException(outcome, e);
                }
                catch (Throwable e) {
                    if (e instanceof ExternalSeedException) {
                        throw (ExternalSeedException)e;
                    }
                    throw new ExternalSeedException("Connection failed", e);
                }
            }
            finally {
                if (socket != null) {
                    try {
                        socket.close();
                    }
                    catch (Throwable throwable) {}
                }
                if (plugin_proxy != null) {
                    plugin_proxy.setOK(proxy_ok);
                }
            }
        }
    }

    @Override
    public void deactivate() {
    }

    @Override
    public PasswordAuthentication getAuthentication(String realm, URL tracker) {
        return null;
    }

    @Override
    public void setAuthenticationOutcome(String realm, URL tracker, boolean success) {
    }

    @Override
    public void clearPasswords() {
    }

    @Override
    public int getLastResponse() {
        return this.last_response;
    }

    @Override
    public int getLast503RetrySecs() {
        return this.last_response_retry_after_secs;
    }

    public static void main(String[] args) {
        try {
            String url_str = "";
            ExternalSeedHTTPDownloaderRange downloader = new ExternalSeedHTTPDownloaderRange(new URL(url_str), "Azureus");
            downloader.downloadRange(0L, 1, new ExternalSeedHTTPDownloaderListener(){
                private int position;

                @Override
                public byte[] getBuffer() throws ExternalSeedException {
                    return new byte[1024];
                }

                @Override
                public void setBufferPosition(int _position) {
                    this.position = _position;
                }

                @Override
                public int getBufferPosition() {
                    return this.position;
                }

                @Override
                public int getBufferLength() {
                    return 1024;
                }

                @Override
                public int getPermittedBytes() throws ExternalSeedException {
                    return 1024;
                }

                @Override
                public int getPermittedTime() {
                    return Integer.MAX_VALUE;
                }

                @Override
                public void reportBytesRead(int num) {
                    System.out.println("read " + num);
                }

                @Override
                public boolean isCancelled() {
                    return false;
                }

                @Override
                public void done() {
                    System.out.println("done");
                }
            }, true);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

