/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.vuzefile;

import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.core.vuzefile.VuzeFile;
import com.aelitis.azureus.core.vuzefile.VuzeFileComponent;
import com.aelitis.azureus.core.vuzefile.VuzeFileImpl;
import com.aelitis.azureus.core.vuzefile.VuzeFileProcessor;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.Map;
import org.gudy.azureus2.core3.util.BDecoder;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.plugins.utils.StaticUtilities;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;

public class VuzeFileHandler {
    private static VuzeFileHandler singleton = new VuzeFileHandler();
    private CopyOnWriteList<VuzeFileProcessor> processors = new CopyOnWriteList();

    public static VuzeFileHandler getSingleton() {
        return singleton;
    }

    protected VuzeFileHandler() {
    }

    public VuzeFile loadVuzeFile(String target) {
        try {
            File test_file = new File(target);
            if (test_file.isFile()) {
                return this.getVuzeFile(new FileInputStream(test_file));
            }
            URL url = new URI(target).toURL();
            String protocol = url.getProtocol().toLowerCase();
            if (protocol.equals("http") || protocol.equals("https")) {
                ResourceDownloader rd = StaticUtilities.getResourceDownloaderFactory().create(url);
                return this.getVuzeFile(rd.download());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public VuzeFile loadVuzeFile(byte[] bytes) {
        return this.loadVuzeFile(new ByteArrayInputStream(bytes));
    }

    public VuzeFile loadVuzeFile(InputStream is) {
        return this.getVuzeFile(is);
    }

    /*
     * Loose catch block
     */
    public VuzeFile loadVuzeFile(File file) {
        VuzeFile vuzeFile;
        FileInputStream is;
        block12: {
            is = null;
            is = new FileInputStream(file);
            vuzeFile = this.getVuzeFile(is);
            if (is == null) break block12;
            try {
                ((InputStream)is).close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return vuzeFile;
        catch (Throwable e) {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return null;
            catch (Throwable throwable) {
                if (is != null) {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (Throwable throwable2) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    protected VuzeFile getVuzeFile(InputStream is) {
        VuzeFile vuzeFile;
        BufferedInputStream bis = new BufferedInputStream(is);
        try {
            Map map;
            int next;
            bis.mark(100);
            boolean is_json = false;
            while ((next = bis.read()) != -1) {
                char c = (char)next;
                if (Character.isWhitespace(c)) continue;
                is_json = c == '{';
                break;
            }
            bis.reset();
            if (is_json) {
                byte[] bytes = FileUtil.readInputStreamAsByteArray(bis, 0x200000);
                map = BDecoder.decodeFromJSON(new String(bytes, "UTF-8"));
            } else {
                map = BDecoder.decode(bis);
            }
            vuzeFile = this.loadVuzeFile(map);
        }
        catch (Throwable throwable) {
            try {
                is.close();
                throw throwable;
            }
            catch (Throwable throwable2) {
                return null;
            }
        }
        is.close();
        return vuzeFile;
    }

    public VuzeFile loadVuzeFile(Map map) {
        if (map.containsKey("vuze") && !map.containsKey("info")) {
            return new VuzeFileImpl(this, (Map)map.get("vuze"));
        }
        return null;
    }

    public VuzeFile loadAndHandleVuzeFile(String target, int expected_types) {
        VuzeFile vf = this.loadVuzeFile(target);
        if (vf == null) {
            return null;
        }
        this.handleFiles(new VuzeFile[]{vf}, expected_types);
        return vf;
    }

    public void handleFiles(VuzeFile[] files, int expected_types) {
        for (VuzeFileProcessor proc : this.processors) {
            try {
                proc.process(files, expected_types);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        int i = 0;
        while (i < files.length) {
            VuzeFile vf = files[i];
            VuzeFileComponent[] comps = vf.getComponents();
            int j = 0;
            while (j < comps.length) {
                VuzeFileComponent comp2 = comps[j];
                if (!comp2.isProcessed()) {
                    Debug.out("Failed to handle Vuze file component " + comp2.getContent());
                }
                ++j;
            }
            ++i;
        }
    }

    public VuzeFile create() {
        return new VuzeFileImpl(this);
    }

    public void addProcessor(VuzeFileProcessor proc) {
        this.processors.add(proc);
    }
}

