/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.util.bloom.impl;

import com.aelitis.azureus.core.util.bloom.BloomFilter;
import com.aelitis.azureus.core.util.bloom.impl.BloomFilterImpl;
import java.util.Arrays;
import java.util.Map;

public class BloomFilterAddOnly
extends BloomFilterImpl {
    private byte[] map;

    public BloomFilterAddOnly(int _max_entries) {
        super(_max_entries);
        this.map = new byte[(this.getMaxEntries() + 7) / 8];
    }

    public BloomFilterAddOnly(Map<String, Object> x) {
        super(x);
        this.map = (byte[])x.get("map");
    }

    @Override
    protected void serialiseToMap(Map<String, Object> x) {
        super.serialiseToMap(x);
        x.put("map", this.map.clone());
    }

    @Override
    public BloomFilter getReplica() {
        return new BloomFilterAddOnly(this.getMaxEntries());
    }

    @Override
    protected int trimValue(int value) {
        if (value < 0) {
            return 0;
        }
        if (value > 1) {
            return 1;
        }
        return value;
    }

    @Override
    protected int getValue(int index) {
        byte b = this.map[index / 8];
        return b >> index % 8 & 1;
    }

    @Override
    protected int incValue(int index) {
        int original_value = this.getValue(index);
        if (original_value >= 1) {
            return 1;
        }
        this.setValue(index, (byte)(original_value + 1));
        return original_value;
    }

    @Override
    protected int decValue(int index) {
        int original_value = this.getValue(index);
        if (original_value <= 0) {
            return 0;
        }
        this.setValue(index, (byte)(original_value - 1));
        return original_value;
    }

    private void setValue(int index, byte value) {
        byte b = this.map[index / 8];
        if (value == 0) {
            throw new RuntimeException("remove not supported");
        }
        this.map[index / 8] = b = (byte)(b | 1 << index % 8);
    }

    @Override
    public void clear() {
        Arrays.fill(this.map, (byte)0);
        super.clear();
    }
}

