/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.util;

import java.util.HashMap;
import java.util.Map;

public class CopyOnWriteMap<K, V> {
    private volatile Map<K, V> map = new HashMap(4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V put(K key, V val) {
        CopyOnWriteMap copyOnWriteMap = this;
        synchronized (copyOnWriteMap) {
            HashMap<K, V> new_map = new HashMap<K, V>(this.map);
            V result = new_map.put(key, val);
            this.map = new_map;
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putAll(Map<K, V> m) {
        CopyOnWriteMap copyOnWriteMap = this;
        synchronized (copyOnWriteMap) {
            HashMap<K, V> new_map = new HashMap<K, V>(this.map);
            new_map.putAll(m);
            this.map = new_map;
        }
    }

    public void putAll(CopyOnWriteMap<K, V> m) {
        this.putAll(m.map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V remove(Object key) {
        CopyOnWriteMap copyOnWriteMap = this;
        synchronized (copyOnWriteMap) {
            HashMap<K, V> new_map = new HashMap<K, V>(this.map);
            V res = new_map.remove(key);
            this.map = new_map;
            return res;
        }
    }

    public V get(K key) {
        return this.map.get(key);
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }
}

