/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.tag.impl;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import com.aelitis.azureus.core.tag.Tag;
import com.aelitis.azureus.core.tag.TagFeatureProperties;
import com.aelitis.azureus.core.tag.TagListener;
import com.aelitis.azureus.core.tag.TagType;
import com.aelitis.azureus.core.tag.TagTypeListener;
import com.aelitis.azureus.core.tag.Taggable;
import com.aelitis.azureus.core.tag.TaggableLifecycleAdapter;
import com.aelitis.azureus.core.tag.impl.TagManagerImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.gudy.azureus2.core3.disk.DiskManager;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.util.AENetworkClassifier;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AsyncDispatcher;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.TimerEventPeriodic;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.pluginsimpl.local.PluginCoreUtils;

public class TagPropertyConstraintHandler
implements TagTypeListener {
    private final AzureusCore azureus_core;
    private final TagManagerImpl tag_manager;
    private boolean initialised;
    private boolean initial_assignment_complete;
    private Map<Tag, TagConstraint> constrained_tags = new HashMap<Tag, TagConstraint>();
    private Map<Tag, Map<DownloadManager, Long>> apply_history = new HashMap<Tag, Map<DownloadManager, Long>>();
    private AsyncDispatcher dispatcher = new AsyncDispatcher("tag:constraints");
    private TimerEventPeriodic timer;

    private TagPropertyConstraintHandler() {
        this.azureus_core = null;
        this.tag_manager = null;
    }

    protected TagPropertyConstraintHandler(AzureusCore _core, TagManagerImpl _tm) {
        this.azureus_core = _core;
        this.tag_manager = _tm;
        this.tag_manager.addTaggableLifecycleListener(2L, new TaggableLifecycleAdapter(){

            @Override
            public void initialised(List<Taggable> current_taggables) {
                try {
                    TagType tt = TagPropertyConstraintHandler.this.tag_manager.getTagType(3);
                    tt.addTagTypeListener(TagPropertyConstraintHandler.this, true);
                }
                catch (Throwable throwable) {
                    AzureusCoreFactory.addCoreRunningListener(new AzureusCoreRunningListener(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void azureusCoreRunning(AzureusCore core) {
                            Map map = TagPropertyConstraintHandler.this.constrained_tags;
                            synchronized (map) {
                                TagPropertyConstraintHandler.this.initialised = true;
                                TagPropertyConstraintHandler.this.apply(core.getGlobalManager().getDownloadManagers(), true);
                            }
                        }
                    });
                    throw throwable;
                }
                AzureusCoreFactory.addCoreRunningListener(new /* invalid duplicate definition of identical inner class */);
            }

            @Override
            public void taggableCreated(Taggable taggable) {
                TagPropertyConstraintHandler.this.apply((DownloadManager)taggable, null, false);
            }
        });
    }

    @Override
    public void tagTypeChanged(TagType tag_type) {
    }

    @Override
    public void tagAdded(Tag tag) {
        TagFeatureProperties tfp = (TagFeatureProperties)((Object)tag);
        TagFeatureProperties.TagProperty prop = tfp.getProperty("constraint");
        if (prop != null) {
            prop.addListener(new TagFeatureProperties.TagPropertyListener(){

                @Override
                public void propertyChanged(TagFeatureProperties.TagProperty property) {
                    TagPropertyConstraintHandler.this.handleProperty(property);
                }

                @Override
                public void propertySync(TagFeatureProperties.TagProperty property) {
                }
            });
            this.handleProperty(prop);
        }
        tag.addTagListener(new TagListener(){

            @Override
            public void taggableSync(Tag tag) {
            }

            @Override
            public void taggableRemoved(Tag tag, Taggable tagged) {
                TagPropertyConstraintHandler.this.apply((DownloadManager)tagged, tag, true);
            }

            @Override
            public void taggableAdded(Tag tag, Taggable tagged) {
                TagPropertyConstraintHandler.this.apply((DownloadManager)tagged, tag, true);
            }
        }, false);
    }

    @Override
    public void tagChanged(Tag tag) {
    }

    private void checkTimer() {
        if (this.constrained_tags.size() > 0) {
            if (this.timer == null) {
                this.timer = SimpleTimer.addPeriodicEvent("tag:constraint:timer", 30000L, new TimerEventPerformer(){

                    @Override
                    public void perform(TimerEvent event2) {
                        TagPropertyConstraintHandler.this.apply_history.clear();
                        TagPropertyConstraintHandler.this.apply();
                    }
                });
            }
        } else if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
            this.apply_history.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tagRemoved(Tag tag) {
        Map<Tag, TagConstraint> map = this.constrained_tags;
        synchronized (map) {
            if (this.constrained_tags.containsKey(tag)) {
                this.constrained_tags.remove(tag);
                this.checkTimer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleProperty(TagFeatureProperties.TagProperty property) {
        Tag tag = property.getTag();
        Map<Tag, TagConstraint> map = this.constrained_tags;
        synchronized (map) {
            String constraint;
            String[] temp = property.getStringList();
            String string = constraint = temp == null || temp.length < 1 ? "" : temp[0].trim();
            if (constraint.length() == 0) {
                if (this.constrained_tags.containsKey(tag)) {
                    this.constrained_tags.remove(tag);
                }
            } else {
                TagConstraint con = this.constrained_tags.get(tag);
                if (con != null && con.getConstraint().equals(constraint)) {
                    return;
                }
                Set<Taggable> existing = tag.getTagged();
                for (Taggable e : existing) {
                    tag.removeTaggable(e);
                }
                con = new TagConstraint(this, tag, constraint);
                this.constrained_tags.put(tag, con);
                if (this.initialised) {
                    this.apply(con);
                }
            }
            this.checkTimer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void apply(final DownloadManager dm, Tag related_tag, boolean auto) {
        if (dm.isDestroyed()) {
            return;
        }
        Map<Tag, TagConstraint> map = this.constrained_tags;
        synchronized (map) {
            if (this.constrained_tags.size() == 0 || !this.initialised) {
                return;
            }
            if (auto && !this.initial_assignment_complete) {
                return;
            }
        }
        this.dispatcher.dispatch(new AERunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void runSupport() {
                ArrayList cons;
                Map map = TagPropertyConstraintHandler.this.constrained_tags;
                synchronized (map) {
                    cons = new ArrayList(TagPropertyConstraintHandler.this.constrained_tags.values());
                }
                for (TagConstraint con : cons) {
                    con.apply(dm);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void apply(final List<DownloadManager> dms, final boolean initial_assignment) {
        Map<Tag, TagConstraint> map = this.constrained_tags;
        synchronized (map) {
            if (this.constrained_tags.size() == 0 || !this.initialised) {
                return;
            }
        }
        this.dispatcher.dispatch(new AERunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void runSupport() {
                ArrayList cons;
                Map map = TagPropertyConstraintHandler.this.constrained_tags;
                synchronized (map) {
                    cons = new ArrayList(TagPropertyConstraintHandler.this.constrained_tags.values());
                }
                for (Object con2 : cons) {
                    ((TagConstraint)con2).apply(dms);
                }
                if (initial_assignment) {
                    Object con2;
                    con2 = TagPropertyConstraintHandler.this.constrained_tags;
                    synchronized (con2) {
                        TagPropertyConstraintHandler.this.initial_assignment_complete = true;
                    }
                    for (Object con2 : cons) {
                        ((TagConstraint)con2).apply(dms);
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void apply(final TagConstraint constraint) {
        Map<Tag, TagConstraint> map = this.constrained_tags;
        synchronized (map) {
            if (!this.initialised) {
                return;
            }
        }
        this.dispatcher.dispatch(new AERunnable(){

            @Override
            public void runSupport() {
                List<DownloadManager> dms = TagPropertyConstraintHandler.this.azureus_core.getGlobalManager().getDownloadManagers();
                constraint.apply(dms);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void apply() {
        Map<Tag, TagConstraint> map = this.constrained_tags;
        synchronized (map) {
            if (this.constrained_tags.size() == 0 || !this.initialised) {
                return;
            }
        }
        this.dispatcher.dispatch(new AERunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void runSupport() {
                ArrayList cons;
                List<DownloadManager> dms = TagPropertyConstraintHandler.this.azureus_core.getGlobalManager().getDownloadManagers();
                Map map = TagPropertyConstraintHandler.this.constrained_tags;
                synchronized (map) {
                    cons = new ArrayList(TagPropertyConstraintHandler.this.constrained_tags.values());
                }
                for (TagConstraint con : cons) {
                    con.apply(dms);
                }
            }
        });
    }

    private TagConstraint.ConstraintExpr compileConstraint(String expr) {
        return new TagConstraint(this, null, expr).expr;
    }

    public static void main(String[] args) {
        TagPropertyConstraintHandler handler = new TagPropertyConstraintHandler();
        System.out.println(handler.compileConstraint("isGE( shareratio, 1.5)").getString());
    }

    private static class TagConstraint {
        private TagPropertyConstraintHandler handler;
        private Tag tag;
        private String constraint;
        private ConstraintExpr expr;
        private static final int FT_HAS_TAG = 1;
        private static final int FT_IS_PRIVATE = 2;
        private static final int FT_GE = 3;
        private static final int FT_GT = 4;
        private static final int FT_LE = 5;
        private static final int FT_LT = 6;
        private static final int FT_EQ = 7;
        private static final int FT_NEQ = 8;
        private static final int FT_CONTAINS = 9;
        private static final int FT_MATCHES = 10;
        private static final int FT_HAS_NET = 11;
        private static final int FT_IS_COMPLETE = 12;
        private static final int FT_CAN_ARCHIVE = 13;
        private static final int FT_IS_FORCE_START = 14;
        private static final int FT_JAVASCRIPT = 15;
        private static final int FT_IS_CHECKING = 16;
        private static Map<String, Integer> keyword_map = new HashMap<String, Integer>();
        private static final int KW_SHARE_RATIO = 0;
        private static final int KW_AGE = 1;
        private static final int KW_PERCENT = 2;
        private static final int KW_DOWNLOADING_FOR = 3;
        private static final int KW_SEEDING_FOR = 4;
        private static final int KW_SWARM_MERGE = 5;

        static {
            keyword_map.put("shareratio", 0);
            keyword_map.put("share_ratio", 0);
            keyword_map.put("age", 1);
            keyword_map.put("percent", 2);
            keyword_map.put("downloadingfor", 3);
            keyword_map.put("downloading_for", 3);
            keyword_map.put("seedingfor", 4);
            keyword_map.put("seeding_for", 4);
            keyword_map.put("swarmmergebytes", 5);
            keyword_map.put("swarm_merge_bytes", 5);
        }

        private TagConstraint(TagPropertyConstraintHandler _handler, Tag _tag, String _constraint) {
            this.handler = _handler;
            this.tag = _tag;
            this.constraint = _constraint;
            try {
                this.expr = this.compileStart(this.constraint, new HashMap<String, ConstraintExpr>());
            }
            catch (Throwable e) {
                Debug.out("Invalid constraint: " + this.constraint + " - " + Debug.getNestedExceptionMessage(e));
            }
        }

        private ConstraintExpr compileStart(String str, Map<String, ConstraintExpr> context2) {
            if ((str = str.trim()).equalsIgnoreCase("true")) {
                return new ConstraintExprTrue();
            }
            char[] chars = str.toCharArray();
            boolean in_quote = false;
            int level = 0;
            int bracket_start = 0;
            StringBuffer result = new StringBuffer(str.length());
            int i = 0;
            while (i < chars.length) {
                char c = chars[i];
                if (c == '\"' && (i == 0 || chars[i - 1] != '\\')) {
                    boolean bl = in_quote = !in_quote;
                }
                if (!in_quote) {
                    if (c == '(') {
                        if (++level == 1) {
                            bracket_start = i + 1;
                        }
                    } else if (c == ')') {
                        if (--level == 0) {
                            String bracket_text = new String(chars, bracket_start, i - bracket_start).trim();
                            if (result.length() > 0 && Character.isLetterOrDigit(result.charAt(result.length() - 1))) {
                                String key = "{" + context2.size() + "}";
                                context2.put(key, new ConstraintExprParams(bracket_text));
                                result.append("(").append(key).append(")");
                            } else {
                                ConstraintExpr sub_expr = this.compileStart(bracket_text, context2);
                                String key = "{" + context2.size() + "}";
                                context2.put(key, sub_expr);
                                result.append(key);
                            }
                        }
                    } else if (level == 0 && !Character.isWhitespace(c)) {
                        result.append(c);
                    }
                } else if (level == 0) {
                    result.append(c);
                }
                ++i;
            }
            if (level != 0) {
                throw new RuntimeException("Unmatched '(' in \"" + str + "\"");
            }
            if (in_quote) {
                throw new RuntimeException("Unmatched '\"' in \"" + str + "\"");
            }
            return this.compileBasic(result.toString(), context2);
        }

        private ConstraintExpr compileBasic(String str, Map<String, ConstraintExpr> context2) {
            if (str.startsWith("{")) {
                return context2.get(str);
            }
            if (str.contains("||")) {
                String[] bits = str.split("\\|\\|");
                return new ConstraintExprOr(this.compile(bits, context2));
            }
            if (str.contains("&&")) {
                String[] bits = str.split("&&");
                return new ConstraintExprAnd(this.compile(bits, context2));
            }
            if (str.contains("^")) {
                String[] bits = str.split("\\^");
                return new ConstraintExprXor(this.compile(bits, context2));
            }
            if (str.startsWith("!")) {
                return new ConstraintExprNot(this.compileBasic(str.substring(1).trim(), context2));
            }
            int pos = str.indexOf(40);
            if (pos > 0 && str.endsWith(")")) {
                String func = str.substring(0, pos);
                String key = str.substring(pos + 1, str.length() - 1).trim();
                ConstraintExprParams params = (ConstraintExprParams)context2.get(key);
                return new ConstraintExprFunction(func, params);
            }
            throw new RuntimeException("Unsupported construct: " + str);
        }

        private ConstraintExpr[] compile(String[] bits, Map<String, ConstraintExpr> context2) {
            ConstraintExpr[] res = new ConstraintExpr[bits.length];
            int i = 0;
            while (i < bits.length) {
                res[i] = this.compileBasic(bits[i].trim(), context2);
                ++i;
            }
            return res;
        }

        private Tag getTag() {
            return this.tag;
        }

        private String getConstraint() {
            return this.constraint;
        }

        private void apply(DownloadManager dm) {
            if (dm.isDestroyed() || !dm.isPersistent()) {
                return;
            }
            if (this.expr == null) {
                return;
            }
            Set<Taggable> existing = this.tag.getTagged();
            if (this.testConstraint(dm)) {
                if (!existing.contains(dm) && this.canAddTaggable(dm)) {
                    this.tag.addTaggable(dm);
                }
            } else if (existing.contains(dm)) {
                this.tag.removeTaggable(dm);
            }
        }

        private void apply(List<DownloadManager> dms) {
            if (this.expr == null) {
                return;
            }
            Set<Taggable> existing = this.tag.getTagged();
            for (DownloadManager dm : dms) {
                if (dm.isDestroyed() || !dm.isPersistent()) continue;
                if (this.testConstraint(dm)) {
                    if (existing.contains(dm) || !this.canAddTaggable(dm)) continue;
                    this.tag.addTaggable(dm);
                    continue;
                }
                if (!existing.contains(dm)) continue;
                this.tag.removeTaggable(dm);
            }
        }

        private boolean canAddTaggable(DownloadManager dm) {
            Long time;
            long now = SystemTime.getMonotonousTime();
            HashMap<DownloadManager, Long> recent_dms = (HashMap<DownloadManager, Long>)this.handler.apply_history.get(this.tag);
            if (recent_dms != null && (time = (Long)recent_dms.get(dm)) != null && now - time < 1000L) {
                System.out.println("Not applying constraint as too recently actioned: " + dm.getDisplayName() + "/" + this.tag.getTagName(true));
                return false;
            }
            if (recent_dms == null) {
                recent_dms = new HashMap<DownloadManager, Long>();
                this.handler.apply_history.put(this.tag, recent_dms);
            }
            recent_dms.put(dm, now);
            return true;
        }

        private boolean testConstraint(DownloadManager dm) {
            List<Tag> dm_tags = this.handler.tag_manager.getTagsForTaggable(dm);
            return this.expr.eval(dm, dm_tags);
        }

        private static interface ConstraintExpr {
            public boolean eval(DownloadManager var1, List<Tag> var2);

            public String getString();
        }

        private class ConstraintExprAnd
        implements ConstraintExpr {
            private ConstraintExpr[] exprs;

            private ConstraintExprAnd(ConstraintExpr[] _exprs) {
                this.exprs = _exprs;
            }

            @Override
            public boolean eval(DownloadManager dm, List<Tag> tags) {
                ConstraintExpr[] constraintExprArray = this.exprs;
                int n = this.exprs.length;
                int n2 = 0;
                while (n2 < n) {
                    ConstraintExpr expr = constraintExprArray[n2];
                    if (!expr.eval(dm, tags)) {
                        return false;
                    }
                    ++n2;
                }
                return true;
            }

            @Override
            public String getString() {
                String res = "";
                int i = 0;
                while (i < this.exprs.length) {
                    res = String.valueOf(res) + (i == 0 ? "" : "&&") + this.exprs[i].getString();
                    ++i;
                }
                return "(" + res + ")";
            }
        }

        private class ConstraintExprFunction
        implements ConstraintExpr {
            private final String func_name;
            private final ConstraintExprParams params_expr;
            private final Object[] params;
            private final int fn_type;

            private ConstraintExprFunction(String _func_name, ConstraintExprParams _params) {
                this.func_name = _func_name;
                this.params_expr = _params;
                this.params = _params.getValues();
                boolean params_ok = false;
                if (this.func_name.equals("hasTag")) {
                    this.fn_type = 1;
                    params_ok = this.params.length == 1 && this.getStringLiteral(this.params, 0);
                } else if (this.func_name.equals("hasNet")) {
                    this.fn_type = 11;
                    boolean bl = params_ok = this.params.length == 1 && this.getStringLiteral(this.params, 0);
                    if (params_ok) {
                        this.params[0] = AENetworkClassifier.internalise((String)this.params[0]);
                        params_ok = this.params[0] != null;
                    }
                } else if (this.func_name.equals("isPrivate")) {
                    this.fn_type = 2;
                    params_ok = this.params.length == 0;
                } else if (this.func_name.equals("isForceStart")) {
                    this.fn_type = 14;
                    params_ok = this.params.length == 0;
                } else if (this.func_name.equals("isChecking")) {
                    this.fn_type = 16;
                    params_ok = this.params.length == 0;
                } else if (this.func_name.equals("isComplete")) {
                    this.fn_type = 12;
                    params_ok = this.params.length == 0;
                } else if (this.func_name.equals("canArchive")) {
                    this.fn_type = 13;
                    params_ok = this.params.length == 0;
                } else if (this.func_name.equals("isGE")) {
                    this.fn_type = 3;
                    params_ok = this.params.length == 2;
                } else if (this.func_name.equals("isGT")) {
                    this.fn_type = 4;
                    params_ok = this.params.length == 2;
                } else if (this.func_name.equals("isLE")) {
                    this.fn_type = 5;
                    params_ok = this.params.length == 2;
                } else if (this.func_name.equals("isLT")) {
                    this.fn_type = 6;
                    params_ok = this.params.length == 2;
                } else if (this.func_name.equals("isEQ")) {
                    this.fn_type = 7;
                    params_ok = this.params.length == 2;
                } else if (this.func_name.equals("isNEQ")) {
                    this.fn_type = 8;
                    params_ok = this.params.length == 2;
                } else if (this.func_name.equals("contains")) {
                    this.fn_type = 9;
                    params_ok = this.params.length == 2;
                } else if (this.func_name.equals("matches")) {
                    this.fn_type = 10;
                    params_ok = this.params.length == 2 && this.getStringLiteral(this.params, 1);
                } else if (this.func_name.equals("javascript")) {
                    this.fn_type = 15;
                    params_ok = this.params.length == 1 && this.getStringLiteral(this.params, 0);
                } else {
                    throw new RuntimeException("Unsupported function '" + this.func_name + "'");
                }
                if (!params_ok) {
                    throw new RuntimeException("Invalid parameters for function '" + this.func_name + "': " + this.params_expr.getString());
                }
            }

            @Override
            public boolean eval(DownloadManager dm, List<Tag> tags) {
                switch (this.fn_type) {
                    case 1: {
                        String tag_name = (String)this.params[0];
                        for (Tag t : tags) {
                            if (!t.getTagName(true).equals(tag_name)) continue;
                            return true;
                        }
                        return false;
                    }
                    case 11: {
                        String[] nets;
                        String net_name = (String)this.params[0];
                        if (net_name != null && (nets = dm.getDownloadState().getNetworks()) != null) {
                            String[] stringArray = nets;
                            int n = nets.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String net = stringArray[n2];
                                if (net == net_name) {
                                    return true;
                                }
                                ++n2;
                            }
                        }
                        return false;
                    }
                    case 2: {
                        TOTorrent t = dm.getTorrent();
                        return t != null && t.getPrivate();
                    }
                    case 14: {
                        return dm.isForceStart();
                    }
                    case 16: {
                        DiskManager disk_manager;
                        int state = dm.getState();
                        if (state == 30) {
                            return true;
                        }
                        if (state == 60 && (disk_manager = dm.getDiskManager()) != null) {
                            return disk_manager.getCompleteRecheckStatus() != -1;
                        }
                        return false;
                    }
                    case 12: {
                        return dm.isDownloadComplete(false);
                    }
                    case 13: {
                        Download dl = PluginCoreUtils.wrap(dm);
                        return dl != null && dl.canStubbify();
                    }
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        Number n1 = this.getNumeric(dm, this.params, 0);
                        Number n2 = this.getNumeric(dm, this.params, 1);
                        switch (this.fn_type) {
                            case 3: {
                                return n1.doubleValue() >= n2.doubleValue();
                            }
                            case 4: {
                                return n1.doubleValue() > n2.doubleValue();
                            }
                            case 5: {
                                return n1.doubleValue() <= n2.doubleValue();
                            }
                            case 6: {
                                return n1.doubleValue() < n2.doubleValue();
                            }
                            case 7: {
                                return n1.doubleValue() == n2.doubleValue();
                            }
                            case 8: {
                                return n1.doubleValue() != n2.doubleValue();
                            }
                        }
                        return false;
                    }
                    case 9: {
                        String s1 = this.getString(dm, this.params, 0);
                        String s2 = this.getString(dm, this.params, 1);
                        return s1.contains(s2);
                    }
                    case 10: {
                        String s1 = this.getString(dm, this.params, 0);
                        if (this.params[1] == null) {
                            return false;
                        }
                        if (this.params[1] instanceof Pattern) {
                            return ((Pattern)this.params[1]).matcher(s1).find();
                        }
                        try {
                            Pattern p = Pattern.compile((String)this.params[1], 2);
                            this.params[1] = p;
                            return p.matcher(s1).find();
                        }
                        catch (Throwable e) {
                            Debug.out("Invalid constraint pattern: " + this.params[1]);
                            this.params[1] = null;
                            return false;
                        }
                    }
                    case 15: {
                        Object result = TagConstraint.this.handler.tag_manager.evalScript(TagConstraint.this.tag, "javascript( " + (String)this.params[0] + ")", dm, "inTag");
                        if (result instanceof Boolean) {
                            return (Boolean)result;
                        }
                        return false;
                    }
                }
                return false;
            }

            private boolean getStringLiteral(Object[] args, int index) {
                String arg;
                Object _arg = args[index];
                if (_arg instanceof String && (arg = (String)_arg).startsWith("\"") && arg.endsWith("\"")) {
                    args[index] = arg.substring(1, arg.length() - 1);
                    return true;
                }
                return false;
            }

            private String getString(DownloadManager dm, Object[] args, int index) {
                String str = (String)args[index];
                if (str.startsWith("\"") && str.endsWith("\"")) {
                    return str.substring(1, str.length() - 1);
                }
                if (str.equals("name")) {
                    return dm.getDisplayName();
                }
                Debug.out("Invalid constraint string: " + str);
                String result = "\"\"";
                args[index] = result;
                return result;
            }

            private Number getNumeric(DownloadManager dm, Object[] args, int index) {
                Object arg = args[index];
                if (arg instanceof Number) {
                    return (Number)arg;
                }
                String str = (String)arg;
                Number result = 0;
                try {
                    if (Character.isDigit(str.charAt(0))) {
                        result = str.contains(".") ? (Number)Float.valueOf(Float.parseFloat(str)) : (Number)Long.parseLong(str);
                        Number number = result;
                        return number;
                    }
                    Integer kw = (Integer)keyword_map.get(str.toLowerCase(Locale.US));
                    if (kw == null) {
                        Debug.out("Invalid constraint keyword: " + str);
                        Number number = result;
                        return number;
                    }
                    switch (kw) {
                        case 0: {
                            result = null;
                            int sr = dm.getStats().getShareRatio();
                            if (sr == -1) {
                                Integer n = Integer.MAX_VALUE;
                                return n;
                            }
                            Float f = new Float((float)sr / 1000.0f);
                            return f;
                        }
                        case 2: {
                            result = null;
                            int percent = dm.getStats().getPercentDoneExcludingDND();
                            Float f = new Float((float)percent / 10.0f);
                            return f;
                        }
                        case 1: {
                            result = null;
                            long added = dm.getDownloadState().getLongParameter("stats.download.added.time");
                            if (added <= 0L) {
                                Integer n = 0;
                                return n;
                            }
                            Long l = (SystemTime.getCurrentTime() - added) / 1000L;
                            return l;
                        }
                        case 3: {
                            result = null;
                            Long l = dm.getStats().getSecondsDownloading();
                            return l;
                        }
                        case 4: {
                            result = null;
                            Long l = dm.getStats().getSecondsOnlySeeding();
                            return l;
                        }
                        case 5: {
                            result = null;
                            Long l = dm.getDownloadState().getLongAttribute("mergedata");
                            return l;
                        }
                    }
                    Debug.out("Invalid constraint keyword: " + str);
                    Number number = result;
                    return number;
                }
                catch (Throwable e) {
                    Debug.out("Invalid constraint numeric: " + str);
                    Integer n = result;
                    return n;
                }
                finally {
                    if (result != null) {
                        args[index] = result;
                    }
                }
            }

            @Override
            public String getString() {
                return String.valueOf(this.func_name) + "(" + this.params_expr.getString() + ")";
            }
        }

        private class ConstraintExprNot
        implements ConstraintExpr {
            private ConstraintExpr expr;

            private ConstraintExprNot(ConstraintExpr e) {
                this.expr = e;
            }

            @Override
            public boolean eval(DownloadManager dm, List<Tag> tags) {
                return !this.expr.eval(dm, tags);
            }

            @Override
            public String getString() {
                return "!(" + this.expr.getString() + ")";
            }
        }

        private class ConstraintExprOr
        implements ConstraintExpr {
            private ConstraintExpr[] exprs;

            private ConstraintExprOr(ConstraintExpr[] _exprs) {
                this.exprs = _exprs;
            }

            @Override
            public boolean eval(DownloadManager dm, List<Tag> tags) {
                ConstraintExpr[] constraintExprArray = this.exprs;
                int n = this.exprs.length;
                int n2 = 0;
                while (n2 < n) {
                    ConstraintExpr expr = constraintExprArray[n2];
                    if (expr.eval(dm, tags)) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }

            @Override
            public String getString() {
                String res = "";
                int i = 0;
                while (i < this.exprs.length) {
                    res = String.valueOf(res) + (i == 0 ? "" : "||") + this.exprs[i].getString();
                    ++i;
                }
                return "(" + res + ")";
            }
        }

        private class ConstraintExprParams
        implements ConstraintExpr {
            private String value;

            private ConstraintExprParams(String _value) {
                this.value = _value.trim();
            }

            @Override
            public boolean eval(DownloadManager dm, List<Tag> tags) {
                return false;
            }

            public Object[] getValues() {
                if (this.value.length() == 0) {
                    return new String[0];
                }
                if (!this.value.contains(",")) {
                    return new Object[]{this.value};
                }
                char[] chars = this.value.toCharArray();
                boolean in_quote = false;
                ArrayList<String> params = new ArrayList<String>(16);
                StringBuffer current_param = new StringBuffer(this.value.length());
                int i = 0;
                while (i < chars.length) {
                    char c = chars[i];
                    if (c == '\"' && (i == 0 || chars[i - 1] != '\\')) {
                        boolean bl = in_quote = !in_quote;
                    }
                    if (c == ',' && !in_quote) {
                        params.add(current_param.toString());
                        current_param.setLength(0);
                    } else if (in_quote || !Character.isWhitespace(c)) {
                        current_param.append(c);
                    }
                    ++i;
                }
                params.add(current_param.toString());
                return params.toArray(new Object[params.size()]);
            }

            @Override
            public String getString() {
                return this.value;
            }
        }

        private class ConstraintExprTrue
        implements ConstraintExpr {
            private ConstraintExprTrue() {
            }

            @Override
            public boolean eval(DownloadManager dm, List<Tag> tags) {
                return true;
            }

            @Override
            public String getString() {
                return "true";
            }
        }

        private class ConstraintExprXor
        implements ConstraintExpr {
            private ConstraintExpr[] exprs;

            private ConstraintExprXor(ConstraintExpr[] _exprs) {
                this.exprs = _exprs;
                if (this.exprs.length < 2) {
                    throw new RuntimeException("Two or more arguments required for ^");
                }
            }

            @Override
            public boolean eval(DownloadManager dm, List<Tag> tags) {
                boolean res = this.exprs[0].eval(dm, tags);
                int i = 1;
                while (i < this.exprs.length) {
                    res ^= this.exprs[i].eval(dm, tags);
                    ++i;
                }
                return res;
            }

            @Override
            public String getString() {
                String res = "";
                int i = 0;
                while (i < this.exprs.length) {
                    res = String.valueOf(res) + (i == 0 ? "" : "^") + this.exprs[i].getString();
                    ++i;
                }
                return "(" + res + ")";
            }
        }
    }
}

