/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.speedmanager.impl.v2;

import com.aelitis.azureus.core.speedmanager.SpeedManagerPingSource;
import com.aelitis.azureus.core.speedmanager.impl.v2.PingSourceStats;
import com.aelitis.azureus.core.speedmanager.impl.v2.SpeedManagerLogger;
import com.aelitis.azureus.core.util.average.Average;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.util.SystemTime;

public class PingSourceManager {
    private final Map pingAverages = new HashMap();
    private long lastPingRemoval = 0L;
    private static final long TIME_BETWEEN_BAD_PING_REMOVALS = 120000L;
    private static final long TIME_BETWEEN_SLOW_PING_REMOVALS = 300000L;
    private static final long TIME_BETWEEN_FORCED_CYCLE_REMOVALS = 1800000L;

    public void checkPingSources(SpeedManagerPingSource[] sources) {
        if (sources == null) {
            return;
        }
        if (sources.length < 3) {
            return;
        }
        if (this.checkForBadPing(sources)) {
            return;
        }
        if (this.checkForSlowSource(sources)) {
            return;
        }
        this.forcePingSourceChange(sources);
    }

    private boolean forcePingSourceChange(SpeedManagerPingSource[] sources) {
        long currTime = SystemTime.getCurrentTime();
        if (currTime < this.lastPingRemoval + 1800000L) {
            return false;
        }
        if (sources.length < 3) {
            return false;
        }
        SpeedManagerPingSource slowestSource = null;
        double slowestPing = 0.0;
        double fastestPing = 10000.0;
        int len = sources.length;
        int i = 0;
        while (i < len) {
            PingSourceStats pss = (PingSourceStats)this.pingAverages.get(sources[i]);
            Average ave = pss.getHistory();
            double pingTime = ave.getAverage();
            if (pingTime > slowestPing) {
                slowestPing = pingTime;
                slowestSource = sources[i];
            }
            if (pingTime < fastestPing) {
                fastestPing = pingTime;
            }
            ++i;
        }
        this.resetTimer();
        if (slowestPing > 2.0 * fastestPing && slowestSource != null) {
            slowestSource.destroy();
            return true;
        }
        return false;
    }

    private boolean checkForSlowSource(SpeedManagerPingSource[] sources) {
        long currTime = SystemTime.getCurrentTime();
        if (currTime < this.lastPingRemoval + 300000L) {
            return false;
        }
        SpeedManagerPingSource slowestSource = null;
        if (sources.length < 3) {
            return false;
        }
        double fastA = 10000.0;
        double fastB = 10000.0;
        double slowest = 0.0;
        int len = sources.length;
        int i = 0;
        while (i < len) {
            PingSourceStats pss = (PingSourceStats)this.pingAverages.get(sources[i]);
            Average ave = pss.getHistory();
            double pingTime = ave.getAverage();
            if (pingTime < fastA) {
                fastB = fastA;
                fastA = pingTime;
            } else if (pingTime < fastB) {
                fastB = pingTime;
            }
            if (pingTime > slowest) {
                slowest = pingTime;
                slowestSource = sources[i];
                this.resetTimer();
            }
            ++i;
        }
        double sumFastest = fastA + fastB;
        boolean removedSource = false;
        if (sumFastest * 2.0 < slowest && slowestSource != null) {
            slowestSource.destroy();
            SpeedManagerLogger.log("dropping ping source: " + slowestSource.getAddress() + " for being 2x slower then two fastest.");
            removedSource = true;
            this.resetTimer();
        }
        return removedSource;
    }

    private boolean checkForBadPing(SpeedManagerPingSource[] sources) {
        long currTime = SystemTime.getCurrentTime();
        if (currTime < this.lastPingRemoval + 120000L) {
            return false;
        }
        double highestLongTermPing = 0.0;
        SpeedManagerPingSource highestSource = null;
        double lowestLongTermPing = 10000.0;
        int len = sources.length;
        int i = 0;
        while (i < len) {
            PingSourceStats pss = (PingSourceStats)this.pingAverages.get(sources[i]);
            if (pss != null) {
                Average a = pss.getLongTermAve();
                double avePingTime = a.getAverage();
                if (avePingTime > highestLongTermPing) {
                    highestLongTermPing = avePingTime;
                    highestSource = sources[i];
                }
                if (avePingTime < lowestLongTermPing) {
                    lowestLongTermPing = avePingTime;
                }
            }
            ++i;
        }
        boolean removedSource = false;
        if (lowestLongTermPing * 8.0 < highestLongTermPing && highestSource != null) {
            SpeedManagerLogger.log("dropping ping source: " + highestSource.getAddress() + " for being 8x greater then min source.");
            highestSource.destroy();
            removedSource = true;
            this.resetTimer();
        }
        return removedSource;
    }

    public void pingSourceFound(SpeedManagerPingSource source, boolean is_replacement) {
        PingSourceStats pss = new PingSourceStats(source);
        this.pingAverages.put(source, pss);
    }

    public void pingSourceFailed(SpeedManagerPingSource source) {
        if (this.pingAverages.remove(source) == null) {
            SpeedManagerLogger.log("didn't find source: " + source.getAddress().getHostName());
        }
    }

    public void addPingTime(SpeedManagerPingSource source) {
        int pingTime;
        if (source == null) {
            return;
        }
        PingSourceStats pss = (PingSourceStats)this.pingAverages.get(source);
        if (pss == null) {
            this.pingSourceFound(source, false);
            pss = (PingSourceStats)this.pingAverages.get(source);
            SpeedManagerLogger.trace("added new source from addPingTime.");
        }
        if ((pingTime = source.getPingTime()) > 0) {
            pss.addPingTime(source.getPingTime());
        }
    }

    private void resetTimer() {
        this.lastPingRemoval = SystemTime.getCurrentTime();
    }
}

