/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl.tcp;

import com.aelitis.azureus.core.networkmanager.VirtualChannelSelector;
import com.aelitis.azureus.core.networkmanager.impl.tcp.TCPNetworkManager;
import com.aelitis.azureus.core.networkmanager.impl.tcp.TCPTransportImpl;
import com.aelitis.azureus.core.proxy.AEProxyFactory;
import com.aelitis.azureus.core.proxy.AEProxySelector;
import com.aelitis.azureus.core.proxy.AEProxySelectorFactory;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import org.gudy.azureus2.core3.config.COConfigurationListener;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.AddressUtils;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.HostNameToIPResolver;
import org.gudy.azureus2.core3.util.SystemTime;

public class ProxyLoginHandler {
    private static final int READ_DONE = 0;
    private static final int READ_NOT_DONE = 1;
    private static final int READ_NO_PROGRESS = 2;
    public static InetSocketAddress DEFAULT_SOCKS_SERVER_ADDRESS;
    private static String default_socks_version;
    private static String default_socks_user;
    private static String default_socks_password;
    private static final AEProxySelector proxy_selector;
    private final TCPTransportImpl proxy_connection;
    private final InetSocketAddress remote_address;
    private final ProxyListener proxy_listener;
    private final String mapped_ip;
    private int socks5_handshake_phase = 0;
    private int socks5_address_length;
    private long read_start_time = 0L;
    private final String socks_version;
    private final String socks_user;
    private final String socks_password;

    static {
        COConfigurationManager.addListener(new COConfigurationListener(){

            @Override
            public void configurationSaved() {
                ProxyLoginHandler.readConfig();
            }
        });
        ProxyLoginHandler.readConfig();
        proxy_selector = AEProxySelectorFactory.getSelector();
    }

    static void readConfig() {
        boolean socks_same = COConfigurationManager.getBooleanParameter("Proxy.Data.Same");
        String socks_host = COConfigurationManager.getStringParameter(socks_same ? "Proxy.Host" : "Proxy.Data.Host");
        int socks_port = 0;
        try {
            String socks_port_str = COConfigurationManager.getStringParameter(socks_same ? "Proxy.Port" : "Proxy.Data.Port");
            socks_port_str = socks_port_str.trim();
            if (socks_port_str.length() > 0) {
                socks_port = Integer.parseInt(COConfigurationManager.getStringParameter(socks_same ? "Proxy.Port" : "Proxy.Data.Port"));
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
        DEFAULT_SOCKS_SERVER_ADDRESS = new InetSocketAddress(socks_host, socks_port);
        default_socks_version = COConfigurationManager.getStringParameter("Proxy.Data.SOCKS.version");
        default_socks_user = COConfigurationManager.getStringParameter(socks_same ? "Proxy.Username" : "Proxy.Data.Username");
        if (default_socks_user.trim().equalsIgnoreCase("<none>")) {
            default_socks_user = "";
        }
        default_socks_password = COConfigurationManager.getStringParameter(socks_same ? "Proxy.Password" : "Proxy.Data.Password");
    }

    public ProxyLoginHandler(TCPTransportImpl proxy_connection, InetSocketAddress remote_address, ProxyListener listener) {
        this(proxy_connection, remote_address, listener, default_socks_version, default_socks_user, default_socks_password);
    }

    public ProxyLoginHandler(TCPTransportImpl _proxy_connection, InetSocketAddress _remote_address, ProxyListener _listener, String _socks_version, String _socks_user, String _socks_password) {
        this.proxy_connection = _proxy_connection;
        this.remote_address = _remote_address;
        this.proxy_listener = _listener;
        this.socks_version = _socks_version;
        this.socks_user = _socks_user;
        this.socks_password = _socks_password;
        this.mapped_ip = this.remote_address.isUnresolved() || this.remote_address.getAddress() == null ? AEProxyFactory.getAddressMapper().internalise(this.remote_address.getHostName()) : AddressUtils.getHostNameNoResolve(this.remote_address);
        if (this.socks_version.equals("V4")) {
            try {
                this.doSocks4Login(this.createSocks4Message());
            }
            catch (Throwable t) {
                this.proxy_listener.connectFailure(t);
            }
        } else if (this.socks_version.equals("V4a")) {
            try {
                this.doSocks4Login(this.createSocks4aMessage());
            }
            catch (Throwable t) {
                this.proxy_listener.connectFailure(t);
            }
        } else {
            this.doSocks5Login();
        }
    }

    public static InetSocketAddress getProxyAddress(InetSocketAddress target) {
        SocketAddress sa;
        Proxy p = proxy_selector.getSOCKSProxy(DEFAULT_SOCKS_SERVER_ADDRESS, target);
        if (p.type() == Proxy.Type.SOCKS && (sa = p.address()) instanceof InetSocketAddress) {
            return (InetSocketAddress)sa;
        }
        return DEFAULT_SOCKS_SERVER_ADDRESS;
    }

    private void doSocks4Login(final ByteBuffer[] data) {
        try {
            this.sendMessage(data[0]);
            TCPNetworkManager.getSingleton().getReadSelector().register(this.proxy_connection.getSocketChannel(), new VirtualChannelSelector.VirtualSelectorListener(){

                @Override
                public boolean selectSuccess(VirtualChannelSelector selector, SocketChannel sc, Object attachment) {
                    try {
                        int result = ProxyLoginHandler.this.readMessage(data[1]);
                        if (result == 0) {
                            TCPNetworkManager.getSingleton().getReadSelector().cancel(ProxyLoginHandler.this.proxy_connection.getSocketChannel());
                            ProxyLoginHandler.this.parseSocks4Reply(data[1]);
                            ProxyLoginHandler.this.proxy_listener.connectSuccess();
                        } else {
                            TCPNetworkManager.getSingleton().getReadSelector().resumeSelects(ProxyLoginHandler.this.proxy_connection.getSocketChannel());
                        }
                        return result != 2;
                    }
                    catch (Throwable t) {
                        TCPNetworkManager.getSingleton().getReadSelector().cancel(ProxyLoginHandler.this.proxy_connection.getSocketChannel());
                        ProxyLoginHandler.this.proxy_listener.connectFailure(t);
                        return false;
                    }
                }

                @Override
                public void selectFailure(VirtualChannelSelector selector, SocketChannel sc, Object attachment, Throwable msg) {
                    TCPNetworkManager.getSingleton().getReadSelector().cancel(ProxyLoginHandler.this.proxy_connection.getSocketChannel());
                    ProxyLoginHandler.this.proxy_listener.connectFailure(msg);
                }
            }, null);
        }
        catch (Throwable t) {
            SocketChannel chan = this.proxy_connection.getSocketChannel();
            if (chan != null) {
                TCPNetworkManager.getSingleton().getReadSelector().cancel(chan);
            }
            this.proxy_listener.connectFailure(t);
        }
    }

    private void doSocks5Login() {
        try {
            final ArrayList<ByteBuffer> data = new ArrayList<ByteBuffer>(2);
            ByteBuffer[] header = this.createSocks5Message();
            data.add(header[0]);
            data.add(header[1]);
            this.sendMessage((ByteBuffer)data.get(0));
            TCPNetworkManager.getSingleton().getReadSelector().register(this.proxy_connection.getSocketChannel(), new VirtualChannelSelector.VirtualSelectorListener(){

                @Override
                public boolean selectSuccess(VirtualChannelSelector selector, SocketChannel sc, Object attachment) {
                    try {
                        int result = ProxyLoginHandler.this.readMessage((ByteBuffer)data.get(1));
                        if (result == 0) {
                            boolean done = ProxyLoginHandler.this.parseSocks5Reply((ByteBuffer)data.get(1));
                            if (done) {
                                TCPNetworkManager.getSingleton().getReadSelector().cancel(ProxyLoginHandler.this.proxy_connection.getSocketChannel());
                                ProxyLoginHandler.this.proxy_listener.connectSuccess();
                            } else {
                                ByteBuffer[] raw = ProxyLoginHandler.this.createSocks5Message();
                                data.set(0, raw[0]);
                                data.set(1, raw[1]);
                                if (raw[0] != null) {
                                    ProxyLoginHandler.this.sendMessage(raw[0]);
                                }
                                TCPNetworkManager.getSingleton().getReadSelector().resumeSelects(ProxyLoginHandler.this.proxy_connection.getSocketChannel());
                            }
                        } else {
                            TCPNetworkManager.getSingleton().getReadSelector().resumeSelects(ProxyLoginHandler.this.proxy_connection.getSocketChannel());
                        }
                        return result != 2;
                    }
                    catch (Throwable t) {
                        TCPNetworkManager.getSingleton().getReadSelector().cancel(ProxyLoginHandler.this.proxy_connection.getSocketChannel());
                        ProxyLoginHandler.this.proxy_listener.connectFailure(t);
                        return false;
                    }
                }

                @Override
                public void selectFailure(VirtualChannelSelector selector, SocketChannel sc, Object attachment, Throwable msg) {
                    TCPNetworkManager.getSingleton().getReadSelector().cancel(ProxyLoginHandler.this.proxy_connection.getSocketChannel());
                    ProxyLoginHandler.this.proxy_listener.connectFailure(msg);
                }
            }, null);
        }
        catch (Throwable t) {
            SocketChannel chan = this.proxy_connection.getSocketChannel();
            if (chan != null) {
                TCPNetworkManager.getSingleton().getReadSelector().cancel(chan);
            }
            this.proxy_listener.connectFailure(t);
        }
    }

    private void parseSocks4Reply(ByteBuffer reply) throws IOException {
        byte ver = reply.get();
        byte resp = reply.get();
        if (ver != 0 || resp != 90) {
            throw new IOException("SOCKS 4(a): connection declined [" + ver + "/" + resp + "]");
        }
    }

    private void sendMessage(ByteBuffer msg) throws IOException {
        long start_time = SystemTime.getCurrentTime();
        while (msg.hasRemaining()) {
            if (this.proxy_connection.write(new ByteBuffer[]{msg}, 0, 1) >= 1L) continue;
            if (SystemTime.getCurrentTime() - start_time > 30000L) {
                String error = "proxy handshake message send timed out after 30sec";
                throw new IOException(error);
            }
            try {
                Thread.sleep(10L);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    private int readMessage(ByteBuffer msg) throws IOException {
        if (this.read_start_time == 0L) {
            this.read_start_time = SystemTime.getCurrentTime();
        }
        long bytes_read = this.proxy_connection.read(new ByteBuffer[]{msg}, 0, 1);
        if (!msg.hasRemaining()) {
            msg.position(0);
            this.read_start_time = 0L;
            return 0;
        }
        if (SystemTime.getCurrentTime() - this.read_start_time > 30000L) {
            String error = "proxy message read timed out after 30sec";
            throw new IOException(error);
        }
        return bytes_read == 0L ? 2 : 1;
    }

    private ByteBuffer[] createSocks4Message() throws Exception {
        ByteBuffer handshake = ByteBuffer.allocate(256 + this.mapped_ip.length());
        handshake.put((byte)4);
        handshake.put((byte)1);
        handshake.putShort((short)this.remote_address.getPort());
        InetAddress ia = this.remote_address.getAddress();
        String host_str = ia == null ? this.remote_address.getHostName() : ia.getHostAddress();
        InetAddress address = HostNameToIPResolver.syncResolve(host_str);
        if (address == null) {
            throw new Exception("Unresolved host: " + this.remote_address);
        }
        byte[] ip_bytes = address.getAddress();
        if (ip_bytes.length != 4) {
            throw new Exception("Unsupported IPv6 address: " + this.remote_address);
        }
        handshake.put(ip_bytes[0]);
        handshake.put(ip_bytes[1]);
        handshake.put(ip_bytes[2]);
        handshake.put(ip_bytes[3]);
        if (this.socks_user.length() > 0) {
            handshake.put(this.socks_user.getBytes());
        }
        handshake.put((byte)0);
        handshake.flip();
        return new ByteBuffer[]{handshake, ByteBuffer.allocate(8)};
    }

    private ByteBuffer[] createSocks4aMessage() {
        ByteBuffer handshake = ByteBuffer.allocate(256 + this.mapped_ip.length());
        handshake.put((byte)4);
        handshake.put((byte)1);
        handshake.putShort((short)this.remote_address.getPort());
        handshake.put((byte)0);
        handshake.put((byte)0);
        handshake.put((byte)0);
        handshake.put((byte)1);
        if (this.socks_user.length() > 0) {
            handshake.put(this.socks_user.getBytes());
        }
        handshake.put((byte)0);
        handshake.put(this.mapped_ip.getBytes());
        handshake.put((byte)0);
        handshake.flip();
        return new ByteBuffer[]{handshake, ByteBuffer.allocate(8)};
    }

    private ByteBuffer[] createSocks5Message() {
        ByteBuffer handshake = ByteBuffer.allocate(256 + this.mapped_ip.length());
        if (this.socks5_handshake_phase == 0) {
            handshake.put((byte)5);
            handshake.put((byte)2);
            handshake.put((byte)0);
            handshake.put((byte)2);
            handshake.flip();
            this.socks5_handshake_phase = 1;
            return new ByteBuffer[]{handshake, ByteBuffer.allocate(2)};
        }
        if (this.socks5_handshake_phase == 1) {
            handshake.put((byte)1);
            handshake.put((byte)this.socks_user.length());
            handshake.put(this.socks_user.getBytes());
            handshake.put((byte)this.socks_password.length());
            handshake.put(this.socks_password.getBytes());
            handshake.flip();
            this.socks5_handshake_phase = 2;
            return new ByteBuffer[]{handshake, ByteBuffer.allocate(2)};
        }
        if (this.socks5_handshake_phase == 2) {
            handshake.put((byte)5);
            handshake.put((byte)1);
            handshake.put((byte)0);
            try {
                byte[] ip_bytes = HostNameToIPResolver.syncResolve(this.mapped_ip).getAddress();
                handshake.put((byte)1);
                handshake.put(ip_bytes[0]);
                handshake.put(ip_bytes[1]);
                handshake.put(ip_bytes[2]);
                handshake.put(ip_bytes[3]);
            }
            catch (Throwable e) {
                handshake.put((byte)3);
                handshake.put((byte)this.mapped_ip.length());
                handshake.put(this.mapped_ip.getBytes());
            }
            handshake.putShort((short)this.remote_address.getPort());
            handshake.flip();
            this.socks5_handshake_phase = 3;
            return new ByteBuffer[]{handshake, ByteBuffer.allocate(5)};
        }
        this.socks5_handshake_phase = 4;
        ByteBuffer[] byteBufferArray = new ByteBuffer[2];
        byteBufferArray[1] = ByteBuffer.allocate(this.socks5_address_length);
        return byteBufferArray;
    }

    private boolean parseSocks5Reply(ByteBuffer reply) throws IOException {
        if (this.socks5_handshake_phase == 1) {
            reply.get();
            byte method = reply.get();
            if (method != 0 && method != 2) {
                throw new IOException("SOCKS 5: no valid method [" + method + "]");
            }
            if (method == 0) {
                this.socks5_handshake_phase = 2;
            }
            return false;
        }
        if (this.socks5_handshake_phase == 2) {
            reply.get();
            byte status = reply.get();
            if (status != 0) {
                throw new IOException("SOCKS 5: authentication fails [status=" + status + "]");
            }
            return false;
        }
        if (this.socks5_handshake_phase == 3) {
            reply.get();
            byte rep = reply.get();
            if (rep != 0) {
                String[] error_msgs = new String[]{"", "General SOCKS server failure", "connection not allowed by ruleset", "Network unreachable", "Host unreachable", "Connection refused (authentication failure?)", "TTL expired (can mean authentication failure)", "Command not supported", "Address type not supported"};
                String error_msg = rep < error_msgs.length ? error_msgs[rep] : "Unknown error";
                throw new IOException("SOCKS request failure [" + error_msg + "/" + rep + "]");
            }
            reply.get();
            byte atype = reply.get();
            byte first_address_byte = reply.get();
            this.socks5_address_length = atype == 1 ? 3 : (atype == 3 ? (int)first_address_byte : 15);
            this.socks5_address_length += 2;
            return false;
        }
        return true;
    }

    public static interface ProxyListener {
        public void connectSuccess();

        public void connectFailure(Throwable var1);
    }
}

