/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl;

import com.aelitis.azureus.core.networkmanager.EventWaiter;
import com.aelitis.azureus.core.networkmanager.NetworkConnectionBase;
import com.aelitis.azureus.core.networkmanager.RateHandler;
import com.aelitis.azureus.core.networkmanager.impl.RateControlledEntity;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;

public class MultiPeerDownloader2
implements RateControlledEntity {
    private static final int MOVE_TO_IDLE_TIME = 500;
    private static final Object ADD_ACTION = new Object();
    private static final Object REMOVE_ACTION = new Object();
    private volatile ArrayList connections_cow = new ArrayList();
    private final AEMonitor connections_mon = new AEMonitor("MultiPeerDownloader");
    private final RateHandler main_handler;
    private List pending_actions;
    private connectionList active_connections = new connectionList();
    private connectionList idle_connections = new connectionList();
    private long last_idle_check;
    private volatile EventWaiter waiter;

    public MultiPeerDownloader2(RateHandler _main_handler) {
        this.main_handler = _main_handler;
    }

    @Override
    public RateHandler getRateHandler() {
        return this.main_handler;
    }

    public void addPeerConnection(NetworkConnectionBase connection) {
        EventWaiter waiter_to_kick = null;
        try {
            this.connections_mon.enter();
            int cow_size = this.connections_cow.size();
            if (cow_size == 0 && (waiter_to_kick = this.waiter) != null) {
                this.waiter = null;
            }
            ArrayList<NetworkConnectionBase> conn_new = new ArrayList<NetworkConnectionBase>(cow_size + 1);
            conn_new.addAll(this.connections_cow);
            conn_new.add(connection);
            this.connections_cow = conn_new;
            if (this.pending_actions == null) {
                this.pending_actions = new ArrayList();
            }
            this.pending_actions.add(new Object[]{ADD_ACTION, connection});
        }
        finally {
            this.connections_mon.exit();
        }
        if (waiter_to_kick != null) {
            waiter_to_kick.eventOccurred();
        }
    }

    public boolean removePeerConnection(NetworkConnectionBase connection) {
        try {
            this.connections_mon.enter();
            ArrayList conn_new = new ArrayList(this.connections_cow);
            boolean removed = conn_new.remove(connection);
            if (!removed) {
                return false;
            }
            this.connections_cow = conn_new;
            if (this.pending_actions == null) {
                this.pending_actions = new ArrayList();
            }
            this.pending_actions.add(new Object[]{REMOVE_ACTION, connection});
            return true;
        }
        finally {
            this.connections_mon.exit();
        }
    }

    @Override
    public boolean canProcess(EventWaiter waiter) {
        return this.main_handler.getCurrentNumBytesAllowed() >= 1;
    }

    @Override
    public long getBytesReadyToWrite() {
        return 0L;
    }

    @Override
    public int getConnectionCount(EventWaiter _waiter) {
        int result = this.connections_cow.size();
        if (result == 0) {
            this.waiter = _waiter;
        }
        return result;
    }

    @Override
    public int getReadyConnectionCount(EventWaiter waiter) {
        int res = 0;
        for (NetworkConnectionBase connection : this.connections_cow) {
            if (connection.getTransportBase().isReadyForRead(waiter) != 0L) continue;
            ++res;
        }
        return res;
    }

    @Override
    public int doProcessing(EventWaiter waiter, int max_bytes) {
        long now;
        int num_bytes_allowed = this.main_handler.getCurrentNumBytesAllowed();
        if (num_bytes_allowed < 1) {
            return 0;
        }
        if (max_bytes > 0 && max_bytes < num_bytes_allowed) {
            num_bytes_allowed = max_bytes;
        }
        if (this.pending_actions != null) {
            try {
                this.connections_mon.enter();
                int i = 0;
                while (i < this.pending_actions.size()) {
                    Object[] entry = (Object[])this.pending_actions.get(i);
                    NetworkConnectionBase connection = (NetworkConnectionBase)entry[1];
                    if (entry[0] == ADD_ACTION) {
                        this.active_connections.add(connection);
                    } else {
                        this.active_connections.remove(connection);
                        this.idle_connections.remove(connection);
                    }
                    ++i;
                }
                this.pending_actions = null;
            }
            finally {
                this.connections_mon.exit();
            }
        }
        if ((now = SystemTime.getSteppedMonotonousTime()) - this.last_idle_check > 500L) {
            this.last_idle_check = now;
            connectionEntry entry = this.idle_connections.head();
            while (entry != null) {
                NetworkConnectionBase connection = entry.connection;
                connectionEntry next = entry.next;
                if (connection.getTransportBase().isReadyForRead(waiter) == 0L) {
                    this.idle_connections.remove(entry);
                    this.active_connections.addToStart(entry);
                }
                entry = next;
            }
        }
        int num_bytes_remaining = num_bytes_allowed;
        connectionEntry entry = this.active_connections.head();
        int num_entries = this.active_connections.size();
        int i = 0;
        while (i < num_entries && entry != null && num_bytes_remaining > 0) {
            NetworkConnectionBase connection = entry.connection;
            connectionEntry next = entry.next;
            long ready = connection.getTransportBase().isReadyForRead(waiter);
            if (ready == 0L) {
                int mss = connection.getMssSize();
                int allowed = num_bytes_remaining > mss ? mss : num_bytes_remaining;
                int bytes_read = 0;
                try {
                    bytes_read = connection.getIncomingMessageQueue().receiveFromTransport(allowed);
                }
                catch (Throwable e) {
                    if (!(e instanceof IOException) && !Debug.getNestedExceptionMessage(e).contains("Incorrect mix")) {
                        Debug.printStackTrace(e);
                    }
                    connection.notifyOfException(e);
                }
                num_bytes_remaining -= bytes_read;
                this.active_connections.moveToEnd(entry);
            } else if (ready > 500L) {
                this.active_connections.remove(entry);
                this.idle_connections.addToEnd(entry);
            }
            entry = next;
            ++i;
        }
        int total_bytes_read = num_bytes_allowed - num_bytes_remaining;
        if (total_bytes_read > 0) {
            this.main_handler.bytesProcessed(total_bytes_read);
            return total_bytes_read;
        }
        return 0;
    }

    @Override
    public int getPriority() {
        return 1;
    }

    @Override
    public boolean getPriorityBoost() {
        return false;
    }

    @Override
    public String getString() {
        StringBuffer str = new StringBuffer();
        str.append("MPD (" + this.connections_cow.size() + "/" + this.active_connections.size() + "/" + this.idle_connections.size() + ": ");
        int num = 0;
        for (NetworkConnectionBase connection : this.connections_cow) {
            if (num++ > 0) {
                str.append(",");
            }
            str.append(connection.getString());
        }
        return str.toString();
    }

    protected static class connectionEntry {
        private connectionEntry next;
        private connectionEntry prev;
        private NetworkConnectionBase connection;

        protected connectionEntry(NetworkConnectionBase _connection) {
            this.connection = _connection;
        }
    }

    protected static class connectionList {
        private int size;
        private connectionEntry head;
        private connectionEntry tail;

        protected connectionList() {
        }

        protected connectionEntry add(NetworkConnectionBase connection) {
            connectionEntry entry = new connectionEntry(connection);
            if (this.head == null) {
                this.head = this.tail = entry;
            } else {
                this.tail.next = entry;
                entry.prev = this.tail;
                this.tail = entry;
            }
            ++this.size;
            return entry;
        }

        protected void addToEnd(connectionEntry entry) {
            entry.next = null;
            entry.prev = this.tail;
            if (this.tail == null) {
                this.head = this.tail = entry;
            } else {
                this.tail.next = entry;
                this.tail = entry;
            }
            ++this.size;
        }

        protected void addToStart(connectionEntry entry) {
            entry.next = this.head;
            entry.prev = null;
            if (this.head == null) {
                this.head = this.tail = entry;
            } else {
                this.head.prev = entry;
                this.head = entry;
            }
            ++this.size;
        }

        protected void moveToEnd(connectionEntry entry) {
            if (entry != this.tail) {
                connectionEntry prev = entry.prev;
                connectionEntry next = entry.next;
                if (prev == null) {
                    this.head = next;
                } else {
                    prev.next = next;
                }
                next.prev = prev;
                entry.prev = this.tail;
                entry.next = null;
                this.tail.next = entry;
                this.tail = entry;
            }
        }

        protected connectionEntry remove(NetworkConnectionBase connection) {
            connectionEntry entry = this.head;
            while (entry != null) {
                if (entry.connection == connection) {
                    this.remove(entry);
                    return entry;
                }
                entry = entry.next;
            }
            return null;
        }

        protected void remove(connectionEntry entry) {
            connectionEntry prev = entry.prev;
            connectionEntry next = entry.next;
            if (prev == null) {
                this.head = next;
            } else {
                prev.next = next;
            }
            if (next == null) {
                this.tail = prev;
            } else {
                next.prev = prev;
            }
            --this.size;
        }

        protected int size() {
            return this.size;
        }

        protected connectionEntry head() {
            return this.head;
        }
    }
}

