/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.diskmanager.cache.impl;

import com.aelitis.azureus.core.diskmanager.cache.CacheFile;
import com.aelitis.azureus.core.diskmanager.cache.CacheFileManagerException;
import com.aelitis.azureus.core.diskmanager.cache.impl.CacheFileManagerImpl;
import com.aelitis.azureus.core.diskmanager.file.FMFile;
import com.aelitis.azureus.core.diskmanager.file.FMFileManagerException;
import java.io.File;
import org.gudy.azureus2.core3.torrent.TOTorrentFile;
import org.gudy.azureus2.core3.util.DirectByteBuffer;

public class CacheFileWithoutCacheMT
implements CacheFile {
    private static final int MAX_CLONES = 20;
    private static int num_clones;
    private static int max_clone_depth;
    private CacheFileManagerImpl manager;
    private FMFile base_file;
    private FMFile[] files;
    private int[] files_use_count;
    private TOTorrentFile torrent_file;
    private boolean moving;
    private long bytes_written;
    private long bytes_read;

    protected CacheFileWithoutCacheMT(CacheFileManagerImpl _manager, FMFile _file, TOTorrentFile _torrent_file) {
        this.manager = _manager;
        this.base_file = _file;
        this.torrent_file = _torrent_file;
        this.files = new FMFile[]{this.base_file};
        this.files_use_count = new int[1];
    }

    @Override
    public TOTorrentFile getTorrentFile() {
        return this.torrent_file;
    }

    @Override
    public boolean exists() {
        return this.base_file.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void moveFile(File new_file) throws CacheFileManagerException {
        try {
            try {
                var2_2 = this;
                // MONITORENTER : var2_2
                this.moving = true;
                // MONITOREXIT : var2_2
            }
            catch (FMFileManagerException e) {
                this.manager.rethrow(this, e);
                var8_9 = this;
                // MONITORENTER : var8_9
                this.moving = false;
                // MONITOREXIT : var8_9
                return;
            }
        }
        catch (Throwable var7_12) {
            var8_10 = this;
            // MONITORENTER : var8_10
            this.moving = false;
            // MONITOREXIT : var8_10
            throw var7_12;
        }
        while (true) {
            block30: {
                var2_2 = this;
                // MONITORENTER : var2_2
                surviving = false;
                i = 1;
                while (i < this.files_use_count.length) {
                    if (this.files_use_count[i] > 0) {
                        surviving = true;
                        break;
                    }
                    ++i;
                }
                if (surviving) break block30;
                i = 1;
                if (true) ** GOTO lbl74
            }
            // MONITOREXIT : var2_2
            try {
                System.out.println("CacheFileWithoutCacheMT: waiting for clones to die");
                Thread.sleep(250L);
            }
            catch (Throwable var2_3) {}
        }
        do {
            if ((file = this.files[i]).isClone()) {
                var6_8 = CacheFileWithoutCacheMT.class;
                // MONITORENTER : com.aelitis.azureus.core.diskmanager.cache.impl.CacheFileWithoutCacheMT.class
                --CacheFileWithoutCacheMT.num_clones;
                // MONITOREXIT : var6_8
            }
            file.close();
            ++i;
lbl74:
            // 2 sources

        } while (i < this.files_use_count.length);
        this.files = new FMFile[]{this.base_file};
        this.files_use_count = new int[]{this.files_use_count[0]};
        this.base_file.moveFile(new_file);
        // MONITOREXIT : var2_2
        var8_11 = this;
        // MONITORENTER : var8_11
        this.moving = false;
        // MONITOREXIT : var8_11
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void renameFile(String new_file) throws CacheFileManagerException {
        try {
            try {
                var2_2 = this;
                // MONITORENTER : var2_2
                this.moving = true;
                // MONITOREXIT : var2_2
            }
            catch (FMFileManagerException e) {
                this.manager.rethrow(this, e);
                var8_9 = this;
                // MONITORENTER : var8_9
                this.moving = false;
                // MONITOREXIT : var8_9
                return;
            }
        }
        catch (Throwable var7_12) {
            var8_10 = this;
            // MONITORENTER : var8_10
            this.moving = false;
            // MONITOREXIT : var8_10
            throw var7_12;
        }
        while (true) {
            block30: {
                var2_2 = this;
                // MONITORENTER : var2_2
                surviving = false;
                i = 1;
                while (i < this.files_use_count.length) {
                    if (this.files_use_count[i] > 0) {
                        surviving = true;
                        break;
                    }
                    ++i;
                }
                if (surviving) break block30;
                i = 1;
                if (true) ** GOTO lbl74
            }
            // MONITOREXIT : var2_2
            try {
                System.out.println("CacheFileWithoutCacheMT: waiting for clones to die");
                Thread.sleep(250L);
            }
            catch (Throwable var2_3) {}
        }
        do {
            if ((file = this.files[i]).isClone()) {
                var6_8 = CacheFileWithoutCacheMT.class;
                // MONITORENTER : com.aelitis.azureus.core.diskmanager.cache.impl.CacheFileWithoutCacheMT.class
                --CacheFileWithoutCacheMT.num_clones;
                // MONITOREXIT : var6_8
            }
            file.close();
            ++i;
lbl74:
            // 2 sources

        } while (i < this.files_use_count.length);
        this.files = new FMFile[]{this.base_file};
        this.files_use_count = new int[]{this.files_use_count[0]};
        this.base_file.renameFile(new_file);
        // MONITOREXIT : var2_2
        var8_11 = this;
        // MONITORENTER : var8_11
        this.moving = false;
        // MONITOREXIT : var8_11
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAccessMode(int mode) throws CacheFileManagerException {
        try {
            CacheFileWithoutCacheMT cacheFileWithoutCacheMT = this;
            synchronized (cacheFileWithoutCacheMT) {
                int i = 0;
                while (i < this.files.length) {
                    this.files[i].setAccessMode(mode == 1 ? 1 : 2);
                    ++i;
                }
            }
        }
        catch (FMFileManagerException e) {
            this.manager.rethrow(this, e);
        }
    }

    @Override
    public int getAccessMode() {
        return this.base_file.getAccessMode() == 1 ? 1 : 2;
    }

    @Override
    public void setStorageType(int type) throws CacheFileManagerException {
        throw new CacheFileManagerException(this, "Not Implemented");
    }

    @Override
    public int getStorageType() {
        return CacheFileManagerImpl.convertFileToCacheType(this.base_file.getStorageType());
    }

    @Override
    public long getLength() throws CacheFileManagerException {
        try {
            return this.base_file.exists() ? this.base_file.getLength() : 0L;
        }
        catch (FMFileManagerException e) {
            this.manager.rethrow(this, e);
            return 0L;
        }
    }

    @Override
    public long compareLength(long compare_to) throws CacheFileManagerException {
        return this.getLength() - compare_to;
    }

    @Override
    public void setLength(long length) throws CacheFileManagerException {
        try {
            this.base_file.setLength(length);
        }
        catch (FMFileManagerException e) {
            this.manager.rethrow(this, e);
        }
    }

    @Override
    public void setPieceComplete(int piece_number, DirectByteBuffer piece_data) throws CacheFileManagerException {
        try {
            this.base_file.setPieceComplete(piece_number, piece_data);
        }
        catch (FMFileManagerException e) {
            this.manager.rethrow(this, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FMFile getFile() throws CacheFileManagerException {
        CacheFileWithoutCacheMT cacheFileWithoutCacheMT = this;
        synchronized (cacheFileWithoutCacheMT) {
            if (this.moving) {
                this.files_use_count[0] = this.files_use_count[0] + 1;
                return this.files[0];
            }
            int min_index = -1;
            int min = Integer.MAX_VALUE;
            int i = 0;
            while (i < this.files_use_count.length) {
                int count = this.files_use_count[i];
                if (count < min) {
                    min = count;
                    min_index = i;
                }
                ++i;
            }
            if (min == 0 || this.files_use_count.length == 20) {
                int n = min_index;
                this.files_use_count[n] = this.files_use_count[n] + 1;
                return this.files[min_index];
            }
            try {
                FMFile clone = this.base_file.createClone();
                int old_num = this.files.length;
                int new_num = old_num + 1;
                Class<CacheFileWithoutCacheMT> clazz = CacheFileWithoutCacheMT.class;
                synchronized (CacheFileWithoutCacheMT.class) {
                    int cfr_ignored_0 = ++num_clones % 100;
                    if (new_num == 20 || new_num > max_clone_depth) {
                        max_clone_depth = new_num;
                    }
                    // ** MonitorExit[var7_9] (shouldn't be in output)
                    FMFile[] new_files = new FMFile[new_num];
                    int[] new_files_use_count = new int[new_num];
                    System.arraycopy(this.files, 0, new_files, 0, old_num);
                    System.arraycopy(this.files_use_count, 0, new_files_use_count, 0, old_num);
                    new_files[old_num] = clone;
                    new_files_use_count[old_num] = 1;
                    this.files = new_files;
                    this.files_use_count = new_files_use_count;
                    return clone;
                }
            }
            catch (FMFileManagerException e) {
                this.manager.rethrow(this, e);
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseFile(FMFile file) {
        CacheFileWithoutCacheMT cacheFileWithoutCacheMT = this;
        synchronized (cacheFileWithoutCacheMT) {
            int i = 0;
            while (i < this.files_use_count.length) {
                if (this.files[i] == file) {
                    int count = this.files_use_count[i];
                    if (count > 0) {
                        // empty if block
                    }
                    this.files_use_count[i] = --count;
                    break;
                }
                ++i;
            }
        }
    }

    @Override
    public void read(DirectByteBuffer[] buffers, long position, short policy) throws CacheFileManagerException {
        int read_length = 0;
        int i = 0;
        while (i < buffers.length) {
            read_length += buffers[i].remaining((byte)3);
            ++i;
        }
        FMFile file = null;
        try {
            try {
                file = this.getFile();
                file.read(buffers, position);
                this.manager.fileBytesRead(read_length);
                this.bytes_read += (long)read_length;
            }
            catch (FMFileManagerException e) {
                this.manager.rethrow(this, e);
                this.releaseFile(file);
            }
        }
        finally {
            this.releaseFile(file);
        }
    }

    @Override
    public void read(DirectByteBuffer buffer, long position, short policy) throws CacheFileManagerException {
        int read_length = buffer.remaining((byte)3);
        FMFile file = null;
        try {
            try {
                file = this.getFile();
                file.read(buffer, position);
                this.manager.fileBytesRead(read_length);
                this.bytes_read += (long)read_length;
            }
            catch (FMFileManagerException e) {
                this.manager.rethrow(this, e);
                this.releaseFile(file);
            }
        }
        finally {
            this.releaseFile(file);
        }
    }

    @Override
    public void write(DirectByteBuffer buffer, long position) throws CacheFileManagerException {
        int write_length = buffer.remaining((byte)3);
        try {
            this.base_file.write(buffer, position);
            this.manager.fileBytesWritten(write_length);
            this.bytes_written += (long)write_length;
        }
        catch (FMFileManagerException e) {
            this.manager.rethrow(this, e);
        }
    }

    @Override
    public void write(DirectByteBuffer[] buffers, long position) throws CacheFileManagerException {
        int write_length = 0;
        int i = 0;
        while (i < buffers.length) {
            write_length += buffers[i].remaining((byte)3);
            ++i;
        }
        try {
            this.base_file.write(buffers, position);
            this.manager.fileBytesWritten(write_length);
            this.bytes_written += (long)write_length;
        }
        catch (FMFileManagerException e) {
            this.manager.rethrow(this, e);
        }
    }

    @Override
    public void writeAndHandoverBuffer(DirectByteBuffer buffer, long position) throws CacheFileManagerException {
        int write_length = buffer.remaining((byte)3);
        boolean write_ok = false;
        try {
            try {
                this.base_file.write(buffer, position);
                this.manager.fileBytesWritten(write_length);
                this.bytes_written += (long)write_length;
                write_ok = true;
            }
            catch (FMFileManagerException e) {
                this.manager.rethrow(this, e);
                if (write_ok) {
                    buffer.returnToPool();
                }
            }
        }
        finally {
            if (write_ok) {
                buffer.returnToPool();
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void writeAndHandoverBuffers(DirectByteBuffer[] buffers, long position) throws CacheFileManagerException {
        block10: {
            block9: {
                block11: {
                    write_length = 0;
                    i = 0;
                    while (i < buffers.length) {
                        write_length += buffers[i].remaining((byte)3);
                        ++i;
                    }
                    write_ok = false;
                    try {
                        try {
                            this.base_file.write(buffers, position);
                            this.manager.fileBytesWritten(write_length);
                            this.bytes_written += (long)write_length;
                            write_ok = true;
                            break block9;
                        }
                        catch (FMFileManagerException e) {
                            this.manager.rethrow(this, e);
                            if (!write_ok) break block10;
                            i = 0;
                            ** while (i < buffers.length)
                        }
                    }
                    catch (Throwable var7_9) {
                        if (!write_ok) break block11;
                        i = 0;
                        ** while (i < buffers.length)
                    }
lbl-1000:
                    // 1 sources

                    {
                        buffers[i].returnToPool();
                        ++i;
                        continue;
lbl23:
                        // 1 sources

                        break block10;
                    }
lbl-1000:
                    // 1 sources

                    {
                        buffers[i].returnToPool();
                        ++i;
                        continue;
                    }
                }
                throw var7_9;
            }
            if (write_ok) {
                i = 0;
                while (i < buffers.length) {
                    buffers[i].returnToPool();
                    ++i;
                }
            }
        }
    }

    @Override
    public void flushCache() throws CacheFileManagerException {
        try {
            this.base_file.flush();
        }
        catch (FMFileManagerException e) {
            this.manager.rethrow(this, e);
        }
    }

    @Override
    public void clearCache() throws CacheFileManagerException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void close() throws CacheFileManagerException {
        try {
            CacheFileWithoutCacheMT cacheFileWithoutCacheMT = this;
            // MONITORENTER : cacheFileWithoutCacheMT
            int i = 0;
            while (true) {
                if (i >= this.files.length) {
                    // MONITOREXIT : cacheFileWithoutCacheMT
                    return;
                }
                FMFile file = this.files[i];
                if (file.isClone()) {
                    Class<CacheFileWithoutCacheMT> clazz = CacheFileWithoutCacheMT.class;
                    // MONITORENTER : com.aelitis.azureus.core.diskmanager.cache.impl.CacheFileWithoutCacheMT.class
                    --num_clones;
                    // MONITOREXIT : clazz
                }
                file.close();
                ++i;
            }
        }
        catch (FMFileManagerException e) {
            this.manager.rethrow(this, e);
        }
    }

    @Override
    public boolean isOpen() {
        return this.base_file.isOpen();
    }

    @Override
    public long getSessionBytesRead() {
        return this.bytes_read;
    }

    @Override
    public long getSessionBytesWritten() {
        return this.bytes_written;
    }

    @Override
    public void delete() throws CacheFileManagerException {
        try {
            this.base_file.delete();
        }
        catch (FMFileManagerException e) {
            this.manager.rethrow(this, e);
        }
    }
}

