/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.dht.transport.udp.impl;

import com.aelitis.azureus.core.dht.transport.DHTTransportContact;
import com.aelitis.azureus.core.dht.transport.DHTTransportException;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTTransportUDPImpl;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketReply;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPUtils;
import com.aelitis.azureus.core.dht.transport.udp.impl.packethandler.DHTUDPPacketNetworkHandler;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import org.gudy.azureus2.core3.util.Debug;

public class DHTUDPPacketReplyError
extends DHTUDPPacketReply {
    public static final int ET_UNKNOWN = 0;
    public static final int ET_ORIGINATOR_ADDRESS_WRONG = 1;
    public static final int ET_KEY_BLOCKED = 2;
    private int error_type = 0;
    private InetSocketAddress originator_address;
    private byte[] key_block_request;
    private byte[] key_block_signature;

    public DHTUDPPacketReplyError(DHTTransportUDPImpl transport, int trans_id, long conn_id, DHTTransportContact local_contact, DHTTransportContact remote_contact) {
        super(transport, 1032, trans_id, conn_id, local_contact, remote_contact);
    }

    protected DHTUDPPacketReplyError(DHTUDPPacketNetworkHandler network_handler, InetSocketAddress originator, DataInputStream is, int trans_id) throws IOException {
        super(network_handler, originator, is, 1032, trans_id);
        this.error_type = is.readInt();
        if (this.error_type == 1) {
            this.originator_address = DHTUDPUtils.deserialiseAddress(is);
        } else if (this.error_type == 2) {
            this.key_block_request = DHTUDPUtils.deserialiseByteArray(is, 255);
            this.key_block_signature = DHTUDPUtils.deserialiseByteArray(is, 65535);
        }
    }

    protected void setErrorType(int error) {
        this.error_type = error;
    }

    protected int getErrorType() {
        return this.error_type;
    }

    protected void setOriginatingAddress(InetSocketAddress a) {
        this.originator_address = a;
    }

    protected InetSocketAddress getOriginatingAddress() {
        return this.originator_address;
    }

    protected void setKeyBlockDetails(byte[] kbr, byte[] sig) {
        this.key_block_request = kbr;
        this.key_block_signature = sig;
    }

    protected byte[] getKeyBlockRequest() {
        return this.key_block_request;
    }

    protected byte[] getKeyBlockSignature() {
        return this.key_block_signature;
    }

    @Override
    public void serialise(DataOutputStream os) throws IOException {
        super.serialise(os);
        os.writeInt(this.error_type);
        if (this.error_type == 1) {
            try {
                DHTUDPUtils.serialiseAddress(os, this.originator_address);
            }
            catch (DHTTransportException e) {
                Debug.printStackTrace(e);
                throw new IOException(e.getMessage());
            }
        } else if (this.error_type == 2) {
            DHTUDPUtils.serialiseByteArray(os, this.key_block_request, 255);
            DHTUDPUtils.serialiseByteArray(os, this.key_block_signature, 65535);
        }
    }
}

