/*
 * Decompiled with CFR 0.152.
 */
package com.licel.jcardsim.crypto;

import javacard.framework.JCSystem;
import javacard.framework.Util;
import javacard.security.Checksum;
import javacard.security.CryptoException;

public class CRC16
extends Checksum {
    static final byte LENGTH = 2;
    private byte[] crc16 = JCSystem.makeTransientByteArray((short)2, (byte)2);

    public byte getAlgorithm() {
        return 1;
    }

    public void init(byte[] bArray, short bOff, short bLen) throws CryptoException {
        if (bLen != 2) {
            CryptoException.throwIt((short)1);
        }
        Util.arrayCopyNonAtomic(bArray, bOff, this.crc16, (short)0, bLen);
    }

    public short doFinal(byte[] inBuff, short inOffset, short inLength, byte[] outBuff, short outOffset) {
        this.update(inBuff, inOffset, inLength);
        short temp = Util.getShort(this.crc16, (short)0);
        temp = ~temp;
        Util.setShort(this.crc16, (short)0, temp);
        Util.arrayCopy(this.crc16, (short)0, outBuff, outOffset, (short)2);
        Util.arrayFillNonAtomic(this.crc16, (short)0, (short)2, (byte)0);
        return 2;
    }

    public void update(byte[] inBuff, short inOffset, short inLength) {
        this.crc16(inBuff, inOffset, inLength);
    }

    void crc16(byte[] inBuf, short inOff, short inLen) {
        short fcs = Util.getShort(this.crc16, (short)0);
        for (short i = inOff; i < (short)(inOff + inLen); i = (short)(i + 1)) {
            short d = (short)(inBuf[i] << 8);
            for (int k = 0; k < 8; k = (int)((short)(k + 1))) {
                fcs = (short)((fcs ^ d) & 0x8000) != 0 ? (short)((short)(fcs << 1) ^ 0x1021) : (short)(fcs << 1);
                d = (short)(d << 1);
            }
        }
        Util.setShort(this.crc16, (short)0, fcs);
    }
}

