#
# Copyright (C) 2014 Dominik Oepen
#
# This file is part of virtualsmartcard.
#
# virtualsmartcard is free software: you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by the Free
# Software Foundation, either version 3 of the License, or (at your option) any
# later version.
#
# virtualsmartcard is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
# FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
# more details.
#
# You should have received a copy of the GNU General Public License along with
# virtualsmartcard.  If not, see <http://www.gnu.org/licenses/>.
#

import unittest
from virtualsmartcard.CryptoUtils import *


class TestCryptoUtils(unittest.TestCase):

    def setUp(self):
        self.teststring = "DEADBEEFistatsyksdvhwohfwoehcowc8hw8rogfq8whv75tsg"\
                          "ohsav8wress"
        self.testpass = "SomeRandomPassphrase"
        # The following string was generated using the proteced string method
        # and is used as a regression test.
        # The data generated by protect_string should actually consist of
        # printable characters only but that would break backwards
        # compatibility with the (buggy) legacy implementation
        self.protectedTestString = "2470356b32242478424f50746f6d712448b8f6285"\
                                   "ac8462fffc6aef921f2ad84855219c5aaafb39c4c"\
                                   "c9e54d1634c60cfc9347c67fa55967c5b0130469c"\
                                   "96a44f0b73c53f5ddfc43cd8c1ef68965ebb23330"\
                                   "39326538373233393735346565383864313536383"\
                                   "0666637336134316532".decode('hex')
        self.salt = "POcwYIHr"
        self.cryptedWord = "$p5k2$$POcwYIHr$SPaWqD3NpmLZc6gXbeybnAoCxo7Oc//K"
        self.cryptedWordThousandIterations = "$p5k2$3e8$POcwYIHr$f/mEOCulo6v7"\
                                             "Nq2ooS3480xTet6zdGbI"

    def test_padding(self):
        padded = append_padding(16, self.teststring)
        unpadded = strip_padding(16, padded)
        self.assertEqual(unpadded, self.teststring)

    def test_protect_string(self):
        protectedString = protect_string(self.teststring, self.testpass)
        unprotectedString = read_protected_string(protectedString,
                                                  self.testpass)
        self.assertEqual(self.teststring, unprotectedString)

    def test_unprotect_string(self):
        unprotectedString = read_protected_string(self.protectedTestString,
                                                  self.testpass)
        self.assertEqual(unprotectedString, self.teststring)

    def test_crypt(self):
        cryptedWord = crypt(self.teststring, self.salt)
        self.assertEqual(cryptedWord, self.cryptedWord)

    def test_crypt_non_default_iterations(self):
        cryptedWord = crypt(self.teststring, self.salt, 1000)
        self.assertEqual(cryptedWord, self.cryptedWordThousandIterations)

if __name__ == "__main__":
    unittest.main()
