/*
 * Decompiled with CFR 0.152.
 */
package javacard.security;

import com.licel.jcardsim.crypto.AsymmetricSignatureImpl;
import com.licel.jcardsim.crypto.SymmetricSignatureImpl;
import javacard.security.CryptoException;
import javacard.security.Key;

public abstract class Signature {
    public static final byte ALG_DES_MAC4_NOPAD = 1;
    public static final byte ALG_DES_MAC8_NOPAD = 2;
    public static final byte ALG_DES_MAC4_ISO9797_M1 = 3;
    public static final byte ALG_DES_MAC8_ISO9797_M1 = 4;
    public static final byte ALG_DES_MAC4_ISO9797_M2 = 5;
    public static final byte ALG_DES_MAC8_ISO9797_M2 = 6;
    public static final byte ALG_DES_MAC4_PKCS5 = 7;
    public static final byte ALG_DES_MAC8_PKCS5 = 8;
    public static final byte ALG_RSA_SHA_ISO9796 = 9;
    public static final byte ALG_RSA_SHA_PKCS1 = 10;
    public static final byte ALG_RSA_MD5_PKCS1 = 11;
    public static final byte ALG_RSA_RIPEMD160_ISO9796 = 12;
    public static final byte ALG_RSA_RIPEMD160_PKCS1 = 13;
    public static final byte ALG_DSA_SHA = 14;
    public static final byte ALG_RSA_SHA_RFC2409 = 15;
    public static final byte ALG_RSA_MD5_RFC2409 = 16;
    public static final byte ALG_ECDSA_SHA = 17;
    public static final byte ALG_AES_MAC_128_NOPAD = 18;
    public static final byte ALG_DES_MAC4_ISO9797_1_M2_ALG3 = 19;
    public static final byte ALG_DES_MAC8_ISO9797_1_M2_ALG3 = 20;
    public static final byte ALG_RSA_SHA_PKCS1_PSS = 21;
    public static final byte ALG_RSA_MD5_PKCS1_PSS = 22;
    public static final byte ALG_RSA_RIPEMD160_PKCS1_PSS = 23;
    public static final byte ALG_HMAC_SHA1 = 24;
    public static final byte ALG_HMAC_SHA_256 = 25;
    public static final byte ALG_HMAC_SHA_384 = 26;
    public static final byte ALG_HMAC_SHA_512 = 27;
    public static final byte ALG_HMAC_MD5 = 28;
    public static final byte ALG_HMAC_RIPEMD160 = 29;
    public static final byte ALG_RSA_SHA_ISO9796_MR = 30;
    public static final byte ALG_RSA_RIPEMD160_ISO9796_MR = 31;
    public static final byte ALG_KOREAN_SEED_MAC_NOPAD = 32;
    public static final byte MODE_SIGN = 1;
    public static final byte MODE_VERIFY = 2;

    protected Signature() {
    }

    public static final Signature getInstance(byte algorithm, boolean externalAccess) throws CryptoException {
        Signature instance = null;
        if (externalAccess) {
            CryptoException.throwIt((short)3);
        }
        switch (algorithm) {
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 17: 
            case 30: {
                instance = new AsymmetricSignatureImpl(algorithm);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 18: 
            case 20: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                instance = new SymmetricSignatureImpl(algorithm);
                break;
            }
            default: {
                CryptoException.throwIt((short)3);
            }
        }
        return instance;
    }

    public abstract void init(Key var1, byte var2) throws CryptoException;

    public abstract void init(Key var1, byte var2, byte[] var3, short var4, short var5) throws CryptoException;

    public abstract short getLength() throws CryptoException;

    public abstract byte getAlgorithm();

    public abstract void update(byte[] var1, short var2, short var3) throws CryptoException;

    public abstract short sign(byte[] var1, short var2, short var3, byte[] var4, short var5) throws CryptoException;

    public abstract boolean verify(byte[] var1, short var2, short var3, byte[] var4, short var5, short var6) throws CryptoException;
}

