/*
 * Decompiled with CFR 0.152.
 */
package javacard.framework;

import com.licel.jcardsim.base.SimulatorSystem;
import javacard.framework.AID;
import javacard.framework.Shareable;
import javacard.framework.SystemException;
import javacard.framework.TransactionException;

public final class JCSystem {
    public static final byte MEMORY_TYPE_PERSISTENT = 0;
    public static final byte MEMORY_TYPE_TRANSIENT_RESET = 1;
    public static final byte MEMORY_TYPE_TRANSIENT_DESELECT = 2;
    public static final byte NOT_A_TRANSIENT_OBJECT = 0;
    public static final byte CLEAR_ON_RESET = 1;
    public static final byte CLEAR_ON_DESELECT = 2;
    private static final short API_VERSION = 514;

    public static byte isTransient(Object theObj) {
        return SimulatorSystem.instance().getTransientMemory().isTransient(theObj);
    }

    public static boolean[] makeTransientBooleanArray(short length, byte event) throws NegativeArraySizeException, SystemException {
        return SimulatorSystem.instance().getTransientMemory().makeBooleanArray(length, event);
    }

    public static byte[] makeTransientByteArray(short length, byte event) throws NegativeArraySizeException, SystemException {
        return SimulatorSystem.instance().getTransientMemory().makeByteArray(length, event);
    }

    public static short[] makeTransientShortArray(short length, byte event) throws NegativeArraySizeException, SystemException {
        return SimulatorSystem.instance().getTransientMemory().makeShortArray(length, event);
    }

    public static Object[] makeTransientObjectArray(short length, byte event) throws NegativeArraySizeException, SystemException {
        return SimulatorSystem.instance().getTransientMemory().makeObjectArray(length, event);
    }

    public static short getVersion() {
        return 514;
    }

    public static AID getAID() {
        return SimulatorSystem.instance().getAID();
    }

    public static AID lookupAID(byte[] buffer, short offset, byte length) {
        return SimulatorSystem.instance().lookupAID(buffer, offset, length);
    }

    public static void beginTransaction() throws TransactionException {
        SimulatorSystem.instance().beginTransaction();
    }

    public static void abortTransaction() throws TransactionException {
        SimulatorSystem.instance().abortTransaction();
    }

    public static void commitTransaction() throws TransactionException {
        SimulatorSystem.instance().commitTransaction();
    }

    public static byte getTransactionDepth() {
        return SimulatorSystem.instance().getTransactionDepth();
    }

    public static short getUnusedCommitCapacity() {
        return SimulatorSystem.instance().getUnusedCommitCapacity();
    }

    public static short getMaxCommitCapacity() {
        return SimulatorSystem.instance().getMaxCommitCapacity();
    }

    public static AID getPreviousContextAID() {
        return SimulatorSystem.instance().getPreviousContextAID();
    }

    public static short getAvailableMemory(byte memoryType) throws SystemException {
        switch (memoryType) {
            case 0: {
                return SimulatorSystem.instance().getAvailablePersistentMemory();
            }
            case 1: {
                return SimulatorSystem.instance().getAvailableTransientResetMemory();
            }
            case 2: {
                return SimulatorSystem.instance().getAvailableTransientDeselectMemory();
            }
        }
        SystemException.throwIt((short)1);
        return 0;
    }

    public static Shareable getAppletShareableInterfaceObject(AID serverAID, byte parameter) {
        return SimulatorSystem.instance().getSharedObject(serverAID, parameter);
    }

    public static boolean isObjectDeletionSupported() {
        return SimulatorSystem.instance().isObjectDeletionSupported();
    }

    public static void requestObjectDeletion() throws SystemException {
        SimulatorSystem.instance().requestObjectDeletion();
    }

    public static byte getAssignedChannel() {
        return SimulatorSystem.instance().getAssignedChannel();
    }

    public static boolean isAppletActive(AID theApplet) {
        return theApplet == SimulatorSystem.instance().getAID();
    }

    private JCSystem() {
    }
}

