/*
 * Decompiled with CFR 0.152.
 */
package com.licel.jcardsim.smartcardio;

import com.licel.jcardsim.base.CardManager;
import com.licel.jcardsim.io.JavaCardInterface;
import com.licel.jcardsim.smartcardio.JCSCardChannel;
import javax.smartcardio.ATR;
import javax.smartcardio.Card;
import javax.smartcardio.CardChannel;
import javax.smartcardio.CardException;
import javax.smartcardio.CommandAPDU;
import javax.smartcardio.ResponseAPDU;

public class JCSCard
extends Card {
    static final String T0_PROTOCOL = "T=0";
    private ATR atr;
    private JavaCardInterface cardInterface;
    private JCSCardChannel basicChannel;

    public JCSCard(JavaCardInterface cardInterface) {
        this.cardInterface = cardInterface;
        this.atr = new ATR(cardInterface.getATR());
        this.basicChannel = new JCSCardChannel(this, 0);
    }

    public ATR getATR() {
        return this.atr;
    }

    public String getProtocol() {
        return T0_PROTOCOL;
    }

    public CardChannel getBasicChannel() {
        return this.basicChannel;
    }

    public CardChannel openLogicalChannel() throws CardException {
        return this.basicChannel;
    }

    public void beginExclusive() throws CardException {
    }

    public void endExclusive() throws CardException {
    }

    public byte[] transmitControlCommand(int i, byte[] bytes) throws CardException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void disconnect(boolean bln) throws CardException {
    }

    ResponseAPDU transmitCommand(CommandAPDU capdu) {
        return new ResponseAPDU(CardManager.dispatchApdu(this.cardInterface, capdu.getBytes()));
    }
}

