/*
 * Decompiled with CFR 0.152.
 */
package com.licel.jcardsim.remote;

import com.licel.jcardsim.io.JavaCardInterface;
import com.licel.jcardsim.remote.JavaCardRemoteInterface;
import com.licel.jcardsim.remote.SerializableAID;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import javacard.framework.AID;
import javacard.framework.SystemException;

public class JavaCardRemoteClient
implements JavaCardInterface {
    JavaCardRemoteInterface remote;

    public JavaCardRemoteClient(String serverHost, int serverIp) throws RemoteException, NotBoundException {
        Registry registry = LocateRegistry.getRegistry(serverHost, serverIp);
        this.remote = (JavaCardRemoteInterface)registry.lookup("jCardSim.rmiServer");
    }

    public AID loadApplet(AID aid, String appletClassName) throws SystemException {
        try {
            return this.remote.loadApplet(new SerializableAID(aid), appletClassName).getAID();
        }
        catch (RemoteException e) {
            this.handleRemoteException(e);
            return null;
        }
    }

    public AID loadApplet(AID aid, String appletClassName, byte[] appletJarContents) throws SystemException {
        try {
            return this.remote.loadApplet(new SerializableAID(aid), appletClassName, appletJarContents).getAID();
        }
        catch (RemoteException e) {
            this.handleRemoteException(e);
            return null;
        }
    }

    public AID createApplet(AID aid, byte[] bArray, short bOffset, byte bLength) throws SystemException {
        try {
            return this.remote.createApplet(new SerializableAID(aid), bArray, bOffset, bLength).getAID();
        }
        catch (RemoteException e) {
            this.handleRemoteException(e);
            return null;
        }
    }

    public AID installApplet(AID aid, String appletClassName, byte[] bArray, short bOffset, byte bLength) throws SystemException {
        return this.createApplet(this.loadApplet(aid, appletClassName), bArray, bOffset, bLength);
    }

    public AID installApplet(AID aid, String appletClassName, byte[] appletJarContents, byte[] bArray, short bOffset, byte bLength) throws SystemException {
        return this.createApplet(this.loadApplet(aid, appletClassName), bArray, bOffset, bLength);
    }

    public boolean selectApplet(AID aid) {
        try {
            return this.remote.selectApplet(new SerializableAID(aid));
        }
        catch (RemoteException e) {
            this.handleRemoteException(e);
            return false;
        }
    }

    public byte[] getATR() {
        try {
            return this.remote.getATR();
        }
        catch (RemoteException e) {
            this.handleRemoteException(e);
            return null;
        }
    }

    public byte[] transmitCommand(byte[] data) {
        try {
            return this.remote.transmitCommand(data);
        }
        catch (RemoteException e) {
            this.handleRemoteException(e);
            return null;
        }
    }

    public void reset() {
        try {
            this.remote.reset();
        }
        catch (RemoteException e) {
            this.handleRemoteException(e);
        }
    }

    private void handleRemoteException(RemoteException e) {
        if (e.getCause() instanceof SystemException) {
            throw (SystemException)e.getCause();
        }
        SystemException.throwIt((short)5);
    }

    public byte[] selectAppletWithResult(AID aid) {
        try {
            return this.remote.selectAppletWithResult(new SerializableAID(aid));
        }
        catch (RemoteException e) {
            this.handleRemoteException(e);
            return null;
        }
    }
}

