/*
 * Decompiled with CFR 0.152.
 */
package com.licel.jcardsim.crypto;

import javacard.framework.JCSystem;
import javacard.framework.Util;
import javacard.security.CryptoException;
import javacard.security.RandomData;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.prng.DigestRandomGenerator;
import org.bouncycastle.crypto.prng.RandomGenerator;

public class RandomDataImpl
extends RandomData {
    RandomGenerator engine = new DigestRandomGenerator(new SHA1Digest());

    public void generateData(byte[] buffer, short offset, short length) throws CryptoException {
        this.engine.nextBytes(buffer, offset, length);
    }

    public void setSeed(byte[] buffer, short offset, short length) {
        byte[] seed = JCSystem.makeTransientByteArray(length, (byte)1);
        Util.arrayCopyNonAtomic(buffer, offset, seed, (short)0, length);
        this.engine.addSeedMaterial(seed);
    }
}

