/*
 * Decompiled with CFR 0.152.
 */
package com.licel.jcardsim.crypto;

import com.licel.jcardsim.crypto.KeyWithParameters;
import javacard.framework.JCSystem;
import javacard.framework.Util;
import javacard.security.CryptoException;
import javacard.security.Key;
import javacardx.crypto.Cipher;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.encodings.PKCS1Encoding;
import org.bouncycastle.crypto.engines.RSAEngine;
import org.bouncycastle.crypto.paddings.BlockCipherPadding;

public class AssymetricCipherImpl
extends Cipher {
    byte algorithm;
    AsymmetricBlockCipher engine;
    BlockCipherPadding paddingEngine;
    boolean isInitialized;
    byte[] buffer;
    short bufferPos;

    public AssymetricCipherImpl(byte algorithm) {
        this.algorithm = algorithm;
        switch (algorithm) {
            case 12: {
                this.engine = new RSAEngine();
                this.paddingEngine = null;
                break;
            }
            case 10: {
                this.engine = new PKCS1Encoding(new RSAEngine());
                this.paddingEngine = null;
                break;
            }
            default: {
                CryptoException.throwIt((short)3);
            }
        }
    }

    public void init(Key theKey, byte theMode) throws CryptoException {
        if (theKey == null) {
            CryptoException.throwIt((short)2);
        }
        if (!theKey.isInitialized()) {
            CryptoException.throwIt((short)2);
        }
        if (!(theKey instanceof KeyWithParameters)) {
            CryptoException.throwIt((short)1);
        }
        KeyWithParameters key = (KeyWithParameters)((Object)theKey);
        this.engine.init(theMode == 2, key.getParameters());
        this.buffer = JCSystem.makeTransientByteArray((short)this.engine.getInputBlockSize(), (byte)2);
        this.bufferPos = 0;
        this.isInitialized = true;
    }

    public void init(Key theKey, byte theMode, byte[] bArray, short bOff, short bLen) throws CryptoException {
        CryptoException.throwIt((short)1);
    }

    public byte getAlgorithm() {
        return this.algorithm;
    }

    public short doFinal(byte[] inBuff, short inOffset, short inLength, byte[] outBuff, short outOffset) throws CryptoException {
        if (!this.isInitialized) {
            CryptoException.throwIt((short)4);
        }
        if (outBuff.length - outOffset < this.engine.getOutputBlockSize()) {
            CryptoException.throwIt((short)5);
        }
        this.update(inBuff, inOffset, inLength, outBuff, outOffset);
        if (this.algorithm != 10) {
            if (this.bufferPos < this.engine.getInputBlockSize() && this.paddingEngine == null) {
                CryptoException.throwIt((short)5);
            } else if (this.bufferPos < this.engine.getInputBlockSize()) {
                this.paddingEngine.addPadding(this.buffer, this.bufferPos);
            }
        }
        try {
            byte[] data = this.engine.processBlock(this.buffer, 0, (short)this.buffer.length);
            Util.arrayCopyNonAtomic(data, (short)0, outBuff, outOffset, (short)data.length);
            return (short)data.length;
        }
        catch (InvalidCipherTextException ex) {
            CryptoException.throwIt((short)5);
            return -1;
        }
    }

    public short update(byte[] inBuff, short inOffset, short inLength, byte[] outBuff, short outOffset) throws CryptoException {
        if (!this.isInitialized) {
            CryptoException.throwIt((short)4);
        }
        if (inLength > this.buffer.length - this.bufferPos) {
            CryptoException.throwIt((short)5);
        }
        this.bufferPos = (short)(this.bufferPos + Util.arrayCopyNonAtomic(inBuff, inOffset, this.buffer, this.bufferPos, inLength));
        return this.bufferPos;
    }
}

