/*
 * Decompiled with CFR 0.152.
 */
package com.licel.jcardsim.base;

import com.licel.jcardsim.base.SimulatorSystem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javacard.framework.AID;
import javacard.framework.APDU;
import javacard.framework.Applet;
import javacard.framework.CardException;
import javacard.framework.CardRuntimeException;
import javacard.framework.JCSystem;
import javacard.framework.SystemException;
import javacard.framework.Util;

public class SimulatorRuntime {
    private HashMap applets = new HashMap();
    private AID currentAID;
    private AID previousAID;
    private AID appletToInstallAID;
    byte[] commandBuffer;
    byte[] responseBuffer = JCSystem.makeTransientByteArray((short)255, (byte)1);
    short responseBufferSize = 0;
    byte[] theSW = JCSystem.makeTransientByteArray((short)2, (byte)1);
    private boolean selecting = false;

    public AID getAID() {
        return this.currentAID;
    }

    public AID lookupAID(byte[] buffer, short offset, byte length) {
        for (AID aid : this.applets.keySet()) {
            if (!aid.equals(buffer, offset, length)) continue;
            return aid;
        }
        return null;
    }

    public AppletHolder lookupApplet(AID lookupAid) {
        for (AID aid : this.applets.keySet()) {
            if (!aid.equals(lookupAid)) continue;
            return (AppletHolder)this.applets.get(aid);
        }
        return null;
    }

    public AID getPreviousContextAID() {
        return this.previousAID;
    }

    public void appletInstalling(AID aid) {
        this.appletToInstallAID = aid;
    }

    protected Applet getApplet(AID aid) {
        if (aid == null) {
            return null;
        }
        AppletHolder a = this.lookupApplet(aid);
        if (a == null) {
            return null;
        }
        return a.getApplet();
    }

    protected Class getAppletClass(AID aid) {
        if (aid == null) {
            return null;
        }
        AppletHolder a = this.lookupApplet(aid);
        if (a == null) {
            return null;
        }
        return a.getAppletClass();
    }

    protected void loadApplet(AID aid, Class appletClass) {
        if (this.lookupApplet(aid) != null) {
            SystemException.throwIt((short)4);
        }
        this.applets.put(aid, new AppletHolder(appletClass));
    }

    protected void registerApplet(AID aid, Applet applet) {
        AppletHolder ah = null;
        if (aid == null && this.appletToInstallAID != null) {
            ah = this.lookupApplet(this.appletToInstallAID);
        } else if (aid != null) {
            ah = this.lookupApplet(aid);
        }
        if (ah == null) {
            SystemException.throwIt((short)4);
        }
        ah.setApplet(applet);
        ah.register();
        ah.install();
        this.appletToInstallAID = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] selectApplet(AID aid) {
        Applet newApplet = this.getApplet(aid);
        if (this.currentAID != null) {
            try {
                Applet applet = this.getApplet(this.currentAID);
                applet.deselect();
            }
            catch (Exception e) {
            }
            finally {
                if (SimulatorSystem.getTransactionDepth() != 0) {
                    SimulatorSystem.abortTransaction();
                }
            }
        }
        if (newApplet == null) {
            return null;
        }
        try {
            newApplet.select();
            this.previousAID = this.currentAID;
            this.currentAID = aid;
            this.selecting = true;
            byte[] selectCmd = new byte[128];
            byte len = aid.getBytes(selectCmd, (short)5);
            selectCmd[1] = -92;
            selectCmd[2] = 4;
            selectCmd[4] = len;
            byte[] byArray = this.transmitCommand(selectCmd);
            return byArray;
        }
        catch (Exception exception) {
        }
        finally {
            if (SimulatorSystem.getTransactionDepth() != 0) {
                SimulatorSystem.abortTransaction();
            }
            this.selecting = false;
        }
        return null;
    }

    public boolean isAppletSelecting(Applet aThis) {
        if (aThis.equals(this.getApplet(this.getAID()))) {
            return this.selecting;
        }
        return false;
    }

    byte[] transmitCommand(byte[] command) throws SystemException {
        Applet applet = this.getApplet(this.getAID());
        byte[] response = null;
        Util.arrayFillNonAtomic(this.theSW, (short)0, (short)2, (byte)0);
        if (applet == null) {
            SystemException.throwIt((short)6);
        }
        try {
            Util.arrayCopyNonAtomic(command, (short)0, APDU.getCurrentAPDUBuffer(), (short)0, (short)command.length);
            applet.process(APDU.getCurrentAPDU());
            Util.setShort(this.theSW, (short)0, (short)-28672);
        }
        catch (Throwable e) {
            Util.setShort(this.theSW, (short)0, (short)28416);
            if (e instanceof CardException) {
                Util.setShort(this.theSW, (short)0, ((CardException)e).getReason());
            } else if (e instanceof CardRuntimeException) {
                Util.setShort(this.theSW, (short)0, ((CardRuntimeException)e).getReason());
            }
            response = this.theSW;
        }
        if (this.theSW[0] == 97 || this.theSW[0] >= -112 && this.theSW[0] <= 159) {
            response = JCSystem.makeTransientByteArray((short)(this.responseBufferSize + 2), (byte)1);
            Util.arrayCopyNonAtomic(this.responseBuffer, (short)0, response, (short)0, this.responseBufferSize);
            Util.arrayCopyNonAtomic(this.theSW, (short)0, response, this.responseBufferSize, (short)2);
        }
        APDU.getCurrentAPDU().reset();
        Util.arrayFillNonAtomic(this.responseBuffer, (short)0, (short)255, (byte)0);
        this.responseBufferSize = 0;
        return response;
    }

    void sendAPDU(byte[] buffer, short bOff, short len) {
        this.responseBufferSize = Util.arrayCopyNonAtomic(buffer, bOff, this.responseBuffer, this.responseBufferSize, len);
    }

    void reset() {
        Iterator aids = this.applets.keySet().iterator();
        ArrayList<AID> aidsToTrash = new ArrayList<AID>();
        while (aids.hasNext()) {
            AID aid = (AID)aids.next();
            AppletHolder ah = this.lookupApplet(aid);
            if (ah.getState() == 2) continue;
            aidsToTrash.add(aid);
        }
        for (int i = 0; i < aidsToTrash.size(); ++i) {
            this.applets.remove(aidsToTrash.get(i));
        }
        Util.arrayFillNonAtomic(this.responseBuffer, (short)0, (short)this.responseBuffer.length, (byte)0);
        this.responseBufferSize = 0;
        this.currentAID = null;
        this.previousAID = null;
        this.appletToInstallAID = null;
    }

    void resetRuntime() {
        Iterator aids = this.applets.keySet().iterator();
        ArrayList<AID> aidsToTrash = new ArrayList<AID>();
        while (aids.hasNext()) {
            AID aid = (AID)aids.next();
            aidsToTrash.add(aid);
        }
        for (int i = 0; i < aidsToTrash.size(); ++i) {
            this.applets.remove(aidsToTrash.get(i));
        }
        Util.arrayFillNonAtomic(this.responseBuffer, (short)0, (short)this.responseBuffer.length, (byte)0);
        this.responseBufferSize = 0;
        this.currentAID = null;
        this.previousAID = null;
        this.appletToInstallAID = null;
    }

    class AppletHolder {
        static final byte DOWNLOADING = 0;
        static final byte LOADED = 1;
        static final byte INSTALLED = 2;
        static final byte REGISTERED = 3;
        private byte state;
        private Applet applet;
        private Class appletClass;

        AppletHolder(Applet applet, byte state) {
            this.applet = applet;
            this.state = state;
        }

        AppletHolder(Class appletClass) {
            this.appletClass = appletClass;
            this.state = 1;
        }

        void install() {
            this.state = (byte)2;
        }

        void register() {
            this.state = (byte)3;
        }

        byte getState() {
            return this.state;
        }

        void setApplet(Applet applet) {
            this.applet = applet;
        }

        Applet getApplet() {
            return this.applet;
        }

        Class getAppletClass() {
            return this.appletClass;
        }
    }
}

