/*
 * Decompiled with CFR 0.152.
 */
package javacard.framework;

import com.licel.jcardsim.base.SimulatorSystem;
import javacard.framework.APDUException;
import javacard.framework.JCSystem;
import javacard.framework.Util;

public final class APDU {
    public static final byte STATE_INITIAL = 0;
    public static final byte STATE_PARTIAL_INCOMING = 1;
    public static final byte STATE_FULL_INCOMING = 2;
    public static final byte STATE_OUTGOING = 3;
    public static final byte STATE_OUTGOING_LENGTH_KNOWN = 4;
    public static final byte STATE_PARTIAL_OUTGOING = 5;
    public static final byte STATE_FULL_OUTGOING = 6;
    public static final byte STATE_ERROR_NO_T0_GETRESPONSE = -1;
    public static final byte STATE_ERROR_T1_IFD_ABORT = -2;
    public static final byte STATE_ERROR_IO = -3;
    public static final byte STATE_ERROR_NO_T0_REISSUE = -4;
    public static final byte PROTOCOL_MEDIA_MASK = -16;
    public static final byte PROTOCOL_TYPE_MASK = 15;
    public static final byte PROTOCOL_T0 = 0;
    public static final byte PROTOCOL_T1 = 1;
    public static final byte PROTOCOL_MEDIA_DEFAULT = 0;
    public static final byte PROTOCOL_MEDIA_CONTACTLESS_TYPE_A = -128;
    public static final byte PROTOCOL_MEDIA_CONTACTLESS_TYPE_B = -112;
    public static final byte PROTOCOL_MEDIA_USB = -96;
    private static final short BUFFER_SIZE = 260;
    private static final short T0_IBS = 1;
    private static final short T0_OBS = 258;
    private static final byte T0_NAD = 0;
    private byte[] ramVars;
    private static final byte LE = 0;
    private static final byte LR = 1;
    private static final byte LC = 2;
    private static final byte PRE_READ_LENGTH = 3;
    private static final byte CURRENT_STATE = 4;
    private static final byte LOGICAL_CHN = 5;
    private static final byte RAM_VARS_LENGTH = 6;
    private boolean[] flags;
    private static final byte OUTGOING_FLAG = 0;
    private static final byte OUTGOING_LEN_SET_FLAG = 1;
    private static final byte NO_CHAINING_FLAG = 2;
    private static final byte INCOMING_FLAG = 3;
    private static final byte NO_GET_RESPONSE_FLAG = 4;
    private static final byte FLAGS_LENGTH = 5;
    private byte[] buffer = JCSystem.makeTransientByteArray((short)260, (byte)1);
    private static APDU thisAPDU;

    APDU() {
        this.ramVars = JCSystem.makeTransientByteArray((short)6, (byte)1);
        this.flags = JCSystem.makeTransientBooleanArray((short)5, (byte)1);
        thisAPDU = this;
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public static short getInBlockSize() {
        return 1;
    }

    public static short getOutBlockSize() {
        return 258;
    }

    public static byte getProtocol() {
        return 0;
    }

    public byte getNAD() {
        return 0;
    }

    public short setOutgoing() throws APDUException {
        if (this.flags[0]) {
            APDUException.throwIt((short)1);
        }
        this.flags[0] = true;
        this.ramVars[4] = 3;
        return this.getLe();
    }

    public short setOutgoingNoChaining() throws APDUException {
        if (this.flags[0]) {
            APDUException.throwIt((short)1);
        }
        this.flags[0] = true;
        this.flags[2] = true;
        this.ramVars[4] = 3;
        return this.getLe();
    }

    public void setOutgoingLength(short len) throws APDUException {
        if (!this.flags[0]) {
            APDUException.throwIt((short)1);
        }
        if (this.flags[1]) {
            APDUException.throwIt((short)1);
        }
        if (len > 255 || len < 0) {
            APDUException.throwIt((short)3);
        }
        this.flags[1] = true;
        this.ramVars[4] = 4;
        this.ramVars[1] = (byte)len;
    }

    public short receiveBytes(short bOff) throws APDUException {
        short pre;
        if (!this.flags[3] || this.flags[0]) {
            APDUException.throwIt((short)1);
        }
        short Lc = (short)(this.ramVars[2] & 0xFF);
        if (bOff < 0 || Lc >= 1 && (short)(bOff + 1) > 260) {
            APDUException.throwIt((short)2);
        }
        if ((pre = (short)(this.ramVars[3] & 0xFF)) != 0) {
            this.ramVars[3] = 0;
            this.ramVars[4] = Lc == 0 ? 2 : 1;
            return pre;
        }
        if (Lc != 0) {
            short len = 0;
            if (this.buffer[4] != 0) {
                len = (short)(this.buffer[4] & 0xFF);
            }
            Lc = (short)(Lc - len);
            this.ramVars[2] = (byte)Lc;
            this.ramVars[4] = Lc == 0 ? 2 : 1;
            return len;
        }
        this.ramVars[4] = 2;
        return 0;
    }

    public short setIncomingAndReceive() throws APDUException {
        if (this.ramVars[3] == 0) {
            byte Lc;
            if (this.flags[3] || this.flags[0]) {
                APDUException.throwIt((short)1);
            }
            this.flags[3] = true;
            this.ramVars[2] = Lc = this.buffer[4];
            this.ramVars[0] = 0;
        }
        return this.receiveBytes((short)5);
    }

    public void sendBytes(short bOff, short len) throws APDUException {
        if (bOff < 0 || len < 0 || (short)(bOff + len) > 255) {
            APDUException.throwIt((short)2);
        }
        if (!this.flags[1] || this.flags[4]) {
            APDUException.throwIt((short)1);
        }
        if (len == 0) {
            return;
        }
        short Lr = this.getLr();
        if (len > Lr) {
            APDUException.throwIt((short)1);
        }
        short Le = this.getLe();
        SimulatorSystem.sendAPDU(this.buffer, bOff, len);
        bOff = (short)(bOff + len);
        Le = Lr = (short)(Lr - len);
        this.ramVars[4] = Lr == 0 ? 6 : 5;
        this.ramVars[0] = (byte)Le;
        this.ramVars[1] = (byte)Lr;
    }

    public void sendBytesLong(byte[] outData, short bOff, short len) throws APDUException, SecurityException {
        short sendLength = (short)this.buffer.length;
        while (len > 0) {
            if (len < sendLength) {
                sendLength = len;
            }
            Util.arrayCopy(outData, bOff, this.buffer, (short)0, sendLength);
            this.sendBytes((short)0, sendLength);
            len = (short)(len - sendLength);
            bOff = (short)(bOff + sendLength);
        }
    }

    public void setOutgoingAndSend(short bOff, short len) throws APDUException {
        this.setOutgoing();
        this.setOutgoingLength(len);
        this.sendBytes(bOff, len);
    }

    public byte getCurrentState() {
        return this.ramVars[4];
    }

    public static APDU getCurrentAPDU() throws SecurityException {
        return thisAPDU;
    }

    public static byte[] getCurrentAPDUBuffer() throws SecurityException {
        return thisAPDU.getBuffer();
    }

    public static byte getCLAChannel() {
        return APDU.thisAPDU.ramVars[5];
    }

    public static void waitExtension() throws APDUException {
        if (APDU.thisAPDU.flags[2]) {
            APDUException.throwIt((short)1);
        }
    }

    public boolean isCommandChainingCLA() {
        return (this.buffer[0] & 0x10) == 16;
    }

    public boolean isSecureMessagingCLA() {
        return (this.buffer[0] & 0x40) == 64 ? (this.buffer[0] & 0x20) == 32 : (this.buffer[0] & 0xC) != 0;
    }

    public boolean isISOInterindustryCLA() {
        return (this.buffer[0] & 0x80) != 128;
    }

    public short getIncomingLength() {
        return this.buffer[4];
    }

    public short getOffsetCdata() {
        return 5;
    }

    private short getLe() {
        if (this.ramVars[0] == 0) {
            return 256;
        }
        return (short)(this.ramVars[0] & 0xFF);
    }

    private short getLr() {
        return (short)(this.ramVars[1] & 0xFF);
    }

    public void reset() {
        Util.arrayFillNonAtomic(this.buffer, (short)0, (short)this.buffer.length, (byte)0);
        Util.arrayFillNonAtomic(this.ramVars, (short)0, (short)this.ramVars.length, (byte)0);
        for (int i = 0; i < this.flags.length; i = (int)((byte)(i + 1))) {
            this.flags[i] = false;
        }
    }
}

