/*
 * Decompiled with CFR 0.152.
 */
package com.licel.jcardsim.crypto;

import com.licel.jcardsim.crypto.SymmetricKeyImpl;
import javacard.framework.JCSystem;
import javacard.framework.Util;
import javacard.security.CryptoException;
import javacard.security.Key;
import javacard.security.Signature;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Mac;
import org.bouncycastle.crypto.digests.MD5Digest;
import org.bouncycastle.crypto.digests.RIPEMD160Digest;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.digests.SHA384Digest;
import org.bouncycastle.crypto.digests.SHA512Digest;
import org.bouncycastle.crypto.engines.DESEngine;
import org.bouncycastle.crypto.macs.CBCBlockCipherMac;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.macs.ISO9797Alg3Mac;
import org.bouncycastle.crypto.paddings.ISO7816d4Padding;
import org.bouncycastle.crypto.paddings.PKCS7Padding;
import org.bouncycastle.crypto.paddings.ZeroBytePadding;
import org.bouncycastle.crypto.params.ParametersWithIV;

public class SymmetricSignatureImpl
extends Signature {
    Mac engine;
    byte algorithm;
    boolean isInitialized;

    public SymmetricSignatureImpl(byte algorithm) {
        this.algorithm = algorithm;
    }

    public void init(Key theKey, byte theMode) throws CryptoException {
        this.init(theKey, theMode, null, (short)0, (short)0);
    }

    public void init(Key theKey, byte theMode, byte[] bArray, short bOff, short bLen) throws CryptoException {
        if (theKey == null) {
            CryptoException.throwIt((short)2);
        }
        if (!theKey.isInitialized()) {
            CryptoException.throwIt((short)2);
        }
        if (!(theKey instanceof SymmetricKeyImpl)) {
            CryptoException.throwIt((short)1);
        }
        CipherParameters cipherParams = null;
        BlockCipher cipher = ((SymmetricKeyImpl)theKey).getCipher();
        if (bArray == null) {
            cipherParams = ((SymmetricKeyImpl)theKey).getParameters();
        } else {
            if (bLen != cipher.getBlockSize()) {
                CryptoException.throwIt((short)1);
            }
            cipherParams = new ParametersWithIV(((SymmetricKeyImpl)theKey).getParameters(), bArray, bOff, bLen);
        }
        switch (this.algorithm) {
            case 1: {
                this.engine = new CBCBlockCipherMac(cipher, 32, null);
                break;
            }
            case 2: {
                this.engine = new CBCBlockCipherMac(cipher, 64, null);
                break;
            }
            case 3: {
                this.engine = new CBCBlockCipherMac(cipher, 32, new ZeroBytePadding());
                break;
            }
            case 4: {
                this.engine = new CBCBlockCipherMac(cipher, 64, new ZeroBytePadding());
                break;
            }
            case 5: {
                this.engine = new CBCBlockCipherMac(cipher, 32, new ISO7816d4Padding());
                break;
            }
            case 6: {
                this.engine = new CBCBlockCipherMac(cipher, 64, new ISO7816d4Padding());
                break;
            }
            case 20: {
                this.engine = new ISO9797Alg3Mac(new DESEngine(), 64, new ISO7816d4Padding());
                break;
            }
            case 7: {
                this.engine = new CBCBlockCipherMac(cipher, 32, new PKCS7Padding());
                break;
            }
            case 8: {
                this.engine = new CBCBlockCipherMac(cipher, 64, new PKCS7Padding());
                break;
            }
            case 18: {
                this.engine = new CBCBlockCipherMac(cipher, 128, null);
                break;
            }
            case 24: {
                this.engine = new HMac(new SHA1Digest());
                break;
            }
            case 25: {
                this.engine = new HMac(new SHA256Digest());
                break;
            }
            case 26: {
                this.engine = new HMac(new SHA384Digest());
                break;
            }
            case 27: {
                this.engine = new HMac(new SHA512Digest());
                break;
            }
            case 28: {
                this.engine = new HMac(new MD5Digest());
                break;
            }
            case 29: {
                this.engine = new HMac(new RIPEMD160Digest());
                break;
            }
            default: {
                CryptoException.throwIt((short)3);
            }
        }
        this.engine.init(cipherParams);
        this.isInitialized = true;
    }

    public short getLength() throws CryptoException {
        if (!this.isInitialized) {
            CryptoException.throwIt((short)4);
        }
        return (short)this.engine.getMacSize();
    }

    public byte getAlgorithm() {
        return this.algorithm;
    }

    public void update(byte[] inBuff, short inOffset, short inLength) throws CryptoException {
        if (!this.isInitialized) {
            CryptoException.throwIt((short)4);
        }
        this.engine.update(inBuff, inOffset, inLength);
    }

    public short sign(byte[] inBuff, short inOffset, short inLength, byte[] sigBuff, short sigOffset) throws CryptoException {
        if (!this.isInitialized) {
            CryptoException.throwIt((short)4);
        }
        if ((this.algorithm == 2 || this.algorithm == 1) && inLength % 8 != 0) {
            CryptoException.throwIt((short)5);
        }
        this.engine.update(inBuff, inOffset, inLength);
        short processedBytes = (short)this.engine.doFinal(sigBuff, sigOffset);
        this.engine.reset();
        return processedBytes;
    }

    public boolean verify(byte[] inBuff, short inOffset, short inLength, byte[] sigBuff, short sigOffset, short sigLength) throws CryptoException {
        if (!this.isInitialized) {
            CryptoException.throwIt((short)4);
        }
        if ((this.algorithm == 2 || this.algorithm == 1) && inLength % 8 != 0) {
            CryptoException.throwIt((short)5);
        }
        this.engine.update(inBuff, inOffset, inLength);
        byte[] sig = JCSystem.makeTransientByteArray(this.getLength(), (byte)1);
        this.engine.doFinal(sig, 0);
        this.engine.reset();
        return Util.arrayCompare(sig, (short)0, sigBuff, sigOffset, (short)sig.length) == 0;
    }
}

