/*
 * Decompiled with CFR 0.152.
 */
package com.licel.jcardsim.crypto;

import com.licel.jcardsim.crypto.ByteContainer;
import com.licel.jcardsim.crypto.DSAKeyImpl;
import javacard.security.CryptoException;
import javacard.security.DSAPrivateKey;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.params.DSAKeyParameters;
import org.bouncycastle.crypto.params.DSAPrivateKeyParameters;

public class DSAPrivateKeyImpl
extends DSAKeyImpl
implements DSAPrivateKey {
    protected ByteContainer x = new ByteContainer();

    public DSAPrivateKeyImpl(short keySize) {
        super((byte)8, keySize);
    }

    public DSAPrivateKeyImpl(DSAPrivateKeyParameters params) {
        super(params);
        this.x.setBigInteger(params.getX());
    }

    public void setX(byte[] buffer, short offset, short length) throws CryptoException {
        this.x.setBytes(buffer, offset, length);
    }

    public short getX(byte[] buffer, short offset) {
        return this.x.getBytes(buffer, offset);
    }

    public boolean isInitialized() {
        return super.isInitialized() && this.x.isInitialized();
    }

    public void clearKey() {
        super.clearKey();
        this.x.clear();
    }

    public CipherParameters getParameters() {
        if (!this.isInitialized()) {
            CryptoException.throwIt((short)2);
        }
        return new DSAPrivateKeyParameters(this.x.getBigInteger(), ((DSAKeyParameters)super.getParameters()).getParameters());
    }
}

