/*
 * Decompiled with CFR 0.152.
 */
package com.licel.jcardsim.samples;

import javacard.framework.APDU;
import javacard.framework.Applet;
import javacard.framework.ISOException;
import javacard.framework.JCSystem;
import javacard.framework.Util;

public class HelloWorldApplet1
extends Applet {
    private static final byte SAY_HELLO_INS = 1;
    private static final byte SAY_ECHO2_INS = 3;
    private static final byte SAY_IPARAMS_INS = 4;
    private static final byte NOP_INS = 2;
    private static byte[] helloMessage = new byte[]{72, 101, 108, 108, 111, 32, 119, 111, 114, 108, 100, 32, 33};
    private byte[] echoBytes = new byte[256];
    private byte[] initParamsBytes;
    private static final short LENGTH_ECHO_BYTES = 256;

    protected HelloWorldApplet1(byte[] bArray, short bOffset, byte bLength) {
        if (bLength > 0) {
            byte iLen = bArray[bOffset];
            bOffset = (short)(bOffset + iLen + 1);
            byte cLen = bArray[bOffset];
            bOffset = (short)(bOffset + 3);
            byte aLen = bArray[bOffset];
            this.initParamsBytes = new byte[aLen];
            Util.arrayCopyNonAtomic((byte[])bArray, (short)((short)(bOffset + 1)), (byte[])this.initParamsBytes, (short)0, (short)aLen);
        }
        this.register();
    }

    public static void install(byte[] bArray, short bOffset, byte bLength) throws ISOException {
        new HelloWorldApplet1(bArray, bOffset, bLength);
    }

    public void process(APDU apdu) {
        if (this.selectingApplet()) {
            return;
        }
        byte[] buffer = apdu.getBuffer();
        switch (buffer[1]) {
            case 1: {
                this.sayHello(apdu);
                return;
            }
            case 3: {
                this.sayEcho2(apdu);
                return;
            }
            case 4: {
                this.sayIParams(apdu);
                return;
            }
            case 2: {
                return;
            }
        }
        ISOException.throwIt((short)27904);
    }

    private void sayHello(APDU apdu) {
        byte[] echo;
        byte[] buffer = apdu.getBuffer();
        short incomeBytes = apdu.setIncomingAndReceive();
        if (buffer[2] == 1) {
            echo = JCSystem.makeTransientByteArray((short)incomeBytes, (byte)1);
            Util.arrayCopyNonAtomic((byte[])buffer, (short)5, (byte[])echo, (short)0, (short)incomeBytes);
        } else {
            echo = JCSystem.makeTransientByteArray((short)((short)helloMessage.length), (byte)1);
            Util.arrayCopyNonAtomic((byte[])helloMessage, (short)0, (byte[])echo, (short)0, (short)((short)helloMessage.length));
        }
        apdu.setOutgoing();
        apdu.setOutgoingLength((short)echo.length);
        apdu.sendBytesLong(echo, (short)0, (short)echo.length);
    }

    private void sayEcho2(APDU apdu) {
        byte[] buffer = apdu.getBuffer();
        short bytesRead = apdu.setIncomingAndReceive();
        short echoOffset = 0;
        while (bytesRead > 0) {
            Util.arrayCopyNonAtomic((byte[])buffer, (short)5, (byte[])this.echoBytes, (short)echoOffset, (short)bytesRead);
            echoOffset = (short)(echoOffset + bytesRead);
            bytesRead = apdu.receiveBytes((short)5);
        }
        apdu.setOutgoing();
        apdu.setOutgoingLength(echoOffset);
        apdu.sendBytesLong(this.echoBytes, (short)0, echoOffset);
    }

    private void sayIParams(APDU apdu) {
        apdu.setOutgoing();
        apdu.setOutgoingLength((short)this.initParamsBytes.length);
        apdu.sendBytesLong(this.initParamsBytes, (short)0, (short)this.initParamsBytes.length);
    }
}

