/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.client2;

import com.dropbox.client2.ProgressListener;
import com.dropbox.client2.RESTUtility;
import com.dropbox.client2.SdkVersion;
import com.dropbox.client2.exception.DropboxException;
import com.dropbox.client2.exception.DropboxIOException;
import com.dropbox.client2.exception.DropboxLocalStorageFullException;
import com.dropbox.client2.exception.DropboxParseException;
import com.dropbox.client2.exception.DropboxPartialFileException;
import com.dropbox.client2.exception.DropboxUnlinkedException;
import com.dropbox.client2.jsonextract.JsonExtractionException;
import com.dropbox.client2.jsonextract.JsonExtractor;
import com.dropbox.client2.jsonextract.JsonList;
import com.dropbox.client2.jsonextract.JsonMap;
import com.dropbox.client2.jsonextract.JsonThing;
import com.dropbox.client2.session.Session;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.SyncFailedException;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.InputStreamEntity;
import org.json.simple.JSONArray;
import org.json.simple.JSONValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DropboxAPI<SESS_T extends Session> {
    public static final int VERSION = 1;
    public static final String SDK_VERSION = SdkVersion.get();
    public static final long MAX_UPLOAD_SIZE = 0xB400000L;
    protected static final int METADATA_DEFAULT_LIMIT = 25000;
    private static final int REVISION_DEFAULT_LIMIT = 1000;
    private static final int SEARCH_DEFAULT_LIMIT = 10000;
    private static final int UPLOAD_SO_TIMEOUT_MS = 180000;
    protected final SESS_T session;

    public DropboxAPI(SESS_T SESS_T) {
        if (SESS_T == null) {
            throw new IllegalArgumentException("Session must not be null.");
        }
        this.session = SESS_T;
    }

    public SESS_T getSession() {
        return this.session;
    }

    public Account accountInfo() throws DropboxException {
        this.assertAuthenticated();
        Map map = (Map)RESTUtility.request(RESTUtility.RequestMethod.GET, this.session.getAPIServer(), "/account/info", 1, new String[]{"locale", this.session.getLocale().toString()}, this.session);
        return new Account(map);
    }

    public DropboxFileInfo getFile(String string, String string2, OutputStream outputStream, ProgressListener progressListener) throws DropboxException {
        DropboxInputStream dropboxInputStream = this.getFileStream(string, string2);
        dropboxInputStream.copyStreamToOutput(outputStream, progressListener);
        return dropboxInputStream.getFileInfo();
    }

    public DropboxInputStream getFileStream(String string, String string2) throws DropboxException {
        this.assertAuthenticated();
        if (!string.startsWith("/")) {
            string = "/" + string;
        }
        String string3 = "/files/" + (Object)((Object)this.session.getAccessType()) + string;
        String[] stringArray = new String[]{"rev", string2, "locale", this.session.getLocale().toString()};
        String string4 = RESTUtility.buildURL(this.session.getContentServer(), 1, string3, stringArray);
        HttpGet httpGet = new HttpGet(string4);
        this.session.sign((HttpRequest)httpGet);
        HttpResponse httpResponse = RESTUtility.execute(this.session, (HttpUriRequest)httpGet);
        return new DropboxInputStream((HttpUriRequest)httpGet, httpResponse);
    }

    public Entry putFile(String string, InputStream inputStream, long l, String string2, ProgressListener progressListener) throws DropboxException {
        UploadRequest uploadRequest = this.putFileRequest(string, inputStream, l, string2, progressListener);
        return uploadRequest.upload();
    }

    public UploadRequest putFileRequest(String string, InputStream inputStream, long l, String string2, ProgressListener progressListener) throws DropboxException {
        return this.putFileRequest(string, inputStream, l, false, string2, progressListener);
    }

    public Entry putFileOverwrite(String string, InputStream inputStream, long l, ProgressListener progressListener) throws DropboxException {
        UploadRequest uploadRequest = this.putFileOverwriteRequest(string, inputStream, l, progressListener);
        return uploadRequest.upload();
    }

    public UploadRequest putFileOverwriteRequest(String string, InputStream inputStream, long l, ProgressListener progressListener) throws DropboxException {
        return this.putFileRequest(string, inputStream, l, true, null, progressListener);
    }

    public DropboxFileInfo getThumbnail(String string, OutputStream outputStream, ThumbSize thumbSize, ThumbFormat thumbFormat, ProgressListener progressListener) throws DropboxException {
        DropboxInputStream dropboxInputStream = this.getThumbnailStream(string, thumbSize, thumbFormat);
        dropboxInputStream.copyStreamToOutput(outputStream, progressListener);
        return dropboxInputStream.getFileInfo();
    }

    public DropboxInputStream getThumbnailStream(String string, ThumbSize thumbSize, ThumbFormat thumbFormat) throws DropboxException {
        this.assertAuthenticated();
        String string2 = "/thumbnails/" + (Object)((Object)this.session.getAccessType()) + string;
        String[] stringArray = new String[]{"size", thumbSize.toAPISize(), "format", thumbFormat.toString(), "locale", this.session.getLocale().toString()};
        RequestAndResponse requestAndResponse = RESTUtility.streamRequest(RESTUtility.RequestMethod.GET, this.session.getContentServer(), string2, 1, stringArray, this.session);
        return new DropboxInputStream(requestAndResponse.request, requestAndResponse.response);
    }

    public Entry metadata(String string, int n, String string2, boolean bl, String string3) throws DropboxException {
        this.assertAuthenticated();
        if (n <= 0) {
            n = 25000;
        }
        String[] stringArray = new String[]{"file_limit", String.valueOf(n), "hash", string2, "list", String.valueOf(bl), "rev", string3, "locale", this.session.getLocale().toString()};
        String string4 = "/metadata/" + (Object)((Object)this.session.getAccessType()) + string;
        Map map = (Map)RESTUtility.request(RESTUtility.RequestMethod.GET, this.session.getAPIServer(), string4, 1, stringArray, this.session);
        return new Entry(map);
    }

    public List<Entry> revisions(String string, int n) throws DropboxException {
        this.assertAuthenticated();
        if (n <= 0) {
            n = 1000;
        }
        String[] stringArray = new String[]{"rev_limit", String.valueOf(n), "locale", this.session.getLocale().toString()};
        String string2 = "/revisions/" + (Object)((Object)this.session.getAccessType()) + string;
        JSONArray jSONArray = (JSONArray)RESTUtility.request(RESTUtility.RequestMethod.GET, this.session.getAPIServer(), string2, 1, stringArray, this.session);
        LinkedList<Entry> linkedList = new LinkedList<Entry>();
        for (Object e : jSONArray) {
            linkedList.add(new Entry((Map)e));
        }
        return linkedList;
    }

    public List<Entry> search(String string, String string2, int n, boolean bl) throws DropboxException {
        this.assertAuthenticated();
        if (n <= 0) {
            n = 10000;
        }
        String string3 = "/search/" + (Object)((Object)this.session.getAccessType()) + string;
        String[] stringArray = new String[]{"query", string2, "file_limit", String.valueOf(n), "include_deleted", String.valueOf(bl), "locale", this.session.getLocale().toString()};
        Object object = RESTUtility.request(RESTUtility.RequestMethod.GET, this.session.getAPIServer(), string3, 1, stringArray, this.session);
        ArrayList<Entry> arrayList = new ArrayList<Entry>();
        if (object instanceof JSONArray) {
            JSONArray jSONArray = (JSONArray)object;
            for (Object e : jSONArray) {
                if (!(e instanceof Map)) continue;
                Entry entry = new Entry((Map)e);
                arrayList.add(entry);
            }
        }
        return arrayList;
    }

    public Entry move(String string, String string2) throws DropboxException {
        this.assertAuthenticated();
        String[] stringArray = new String[]{"root", this.session.getAccessType().toString(), "from_path", string, "to_path", string2, "locale", this.session.getLocale().toString()};
        Map map = (Map)RESTUtility.request(RESTUtility.RequestMethod.POST, this.session.getAPIServer(), "/fileops/move", 1, stringArray, this.session);
        return new Entry(map);
    }

    public Entry copy(String string, String string2) throws DropboxException {
        this.assertAuthenticated();
        String[] stringArray = new String[]{"root", this.session.getAccessType().toString(), "from_path", string, "to_path", string2, "locale", this.session.getLocale().toString()};
        Map map = (Map)RESTUtility.request(RESTUtility.RequestMethod.POST, this.session.getAPIServer(), "/fileops/copy", 1, stringArray, this.session);
        return new Entry(map);
    }

    public Entry createFolder(String string) throws DropboxException {
        this.assertAuthenticated();
        String[] stringArray = new String[]{"root", this.session.getAccessType().toString(), "path", string, "locale", this.session.getLocale().toString()};
        Map map = (Map)RESTUtility.request(RESTUtility.RequestMethod.POST, this.session.getAPIServer(), "/fileops/create_folder", 1, stringArray, this.session);
        return new Entry(map);
    }

    public void delete(String string) throws DropboxException {
        this.assertAuthenticated();
        String[] stringArray = new String[]{"root", this.session.getAccessType().toString(), "path", string, "locale", this.session.getLocale().toString()};
        RESTUtility.request(RESTUtility.RequestMethod.POST, this.session.getAPIServer(), "/fileops/delete", 1, stringArray, this.session);
    }

    public Entry restore(String string, String string2) throws DropboxException {
        this.assertAuthenticated();
        String[] stringArray = new String[]{"rev", string2, "locale", this.session.getLocale().toString()};
        String string3 = "/restore/" + (Object)((Object)this.session.getAccessType()) + string;
        Map map = (Map)RESTUtility.request(RESTUtility.RequestMethod.GET, this.session.getAPIServer(), string3, 1, stringArray, this.session);
        return new Entry(map);
    }

    public DropboxLink media(String string, boolean bl) throws DropboxException {
        this.assertAuthenticated();
        String string2 = "/media/" + (Object)((Object)this.session.getAccessType()) + string;
        Map map = (Map)RESTUtility.request(RESTUtility.RequestMethod.GET, this.session.getAPIServer(), string2, 1, new String[]{"locale", this.session.getLocale().toString()}, this.session);
        return new DropboxLink(map, bl);
    }

    public DropboxLink share(String string) throws DropboxException {
        this.assertAuthenticated();
        String string2 = "/shares/" + (Object)((Object)this.session.getAccessType()) + string;
        Map map = (Map)RESTUtility.request(RESTUtility.RequestMethod.GET, this.session.getAPIServer(), string2, 1, new String[]{"locale", this.session.getLocale().toString()}, this.session);
        String string3 = (String)map.get("url");
        Date date = RESTUtility.parseDate((String)map.get("expires"));
        if (string3 == null || date == null) {
            throw new DropboxParseException("Could not parse share response.");
        }
        return new DropboxLink(map);
    }

    protected static boolean getFromMapAsBoolean(Map<String, Object> map, String string) {
        Object object = map.get(string);
        if (object != null && object instanceof Boolean) {
            return (Boolean)object;
        }
        return false;
    }

    private UploadRequest putFileRequest(String string, InputStream inputStream, long l, boolean bl, String string2, ProgressListener progressListener) throws DropboxException {
        if (string == null || string.equals("")) {
            throw new IllegalArgumentException("path is null or empty.");
        }
        this.assertAuthenticated();
        if (!string.startsWith("/")) {
            string = "/" + string;
        }
        String string3 = "/files_put/" + (Object)((Object)this.session.getAccessType()) + string;
        if (string2 == null) {
            string2 = "";
        }
        String[] stringArray = new String[]{"overwrite", String.valueOf(bl), "parent_rev", string2, "locale", this.session.getLocale().toString()};
        String string4 = RESTUtility.buildURL(this.session.getContentServer(), 1, string3, stringArray);
        HttpPut httpPut = new HttpPut(string4);
        this.session.sign((HttpRequest)httpPut);
        InputStreamEntity inputStreamEntity = new InputStreamEntity(inputStream, l);
        inputStreamEntity.setContentEncoding("application/octet-stream");
        inputStreamEntity.setChunked(false);
        Object object = inputStreamEntity;
        if (progressListener != null) {
            object = new ProgressListener.ProgressHttpEntity((HttpEntity)object, progressListener);
        }
        httpPut.setEntity((HttpEntity)object);
        return new BasicUploadRequest((HttpUriRequest)httpPut, (Session)this.session);
    }

    public DeltaPage<Entry> delta(String string) throws DropboxException {
        String[] stringArray = new String[]{"cursor", string, "locale", this.session.getLocale().toString()};
        Object object = RESTUtility.request(RESTUtility.RequestMethod.POST, this.session.getAPIServer(), "/delta", 1, stringArray, this.session);
        try {
            return DeltaPage.extractFromJson(new JsonThing(object), Entry.JsonExtractor);
        }
        catch (JsonExtractionException jsonExtractionException) {
            throw new DropboxParseException("Error parsing /delta results: " + jsonExtractionException.getMessage());
        }
    }

    public CreatedCopyRef createCopyRef(String string) throws DropboxException {
        this.assertAuthenticated();
        if (!string.startsWith("/")) {
            throw new IllegalArgumentException("'sourcePath' must start with \"/\": " + string);
        }
        String[] stringArray = new String[]{"locale", this.session.getLocale().toString()};
        String string2 = "/copy_ref/" + (Object)((Object)this.session.getAccessType()) + string;
        Object object = RESTUtility.request(RESTUtility.RequestMethod.GET, this.session.getAPIServer(), string2, 1, stringArray, this.session);
        try {
            return CreatedCopyRef.extractFromJson(new JsonThing(object));
        }
        catch (JsonExtractionException jsonExtractionException) {
            throw new DropboxParseException("Error parsing /copy_ref results: " + jsonExtractionException.getMessage());
        }
    }

    public Entry addFromCopyRef(String string, String string2) throws DropboxException {
        this.assertAuthenticated();
        if (!string2.startsWith("/")) {
            throw new IllegalArgumentException("'targetPath' doesn't start with \"/\": " + string2);
        }
        String[] stringArray = new String[]{"locale", this.session.getLocale().toString(), "root", this.session.getAccessType().toString(), "from_copy_ref", string, "to_path", string2};
        String string3 = "/fileops/copy";
        Map map = (Map)RESTUtility.request(RESTUtility.RequestMethod.GET, this.session.getAPIServer(), string3, 1, stringArray, this.session);
        return new Entry(map);
    }

    protected void assertAuthenticated() throws DropboxUnlinkedException {
        if (!this.session.isLinked()) {
            throw new DropboxUnlinkedException();
        }
    }

    protected static long getFromMapAsLong(Map<String, Object> map, String string) {
        Object object = map.get(string);
        long l = 0L;
        if (object != null) {
            if (object instanceof Number) {
                l = ((Number)object).longValue();
            } else if (object instanceof String) {
                l = Long.parseLong((String)object, 16);
            }
        }
        return l;
    }

    public static final class CreatedCopyRef {
        public final String copyRef;
        public final String expiration;

        public CreatedCopyRef(String string, String string2) {
            this.copyRef = string;
            this.expiration = string2;
        }

        public static CreatedCopyRef extractFromJson(JsonThing jsonThing) throws JsonExtractionException {
            JsonMap jsonMap = jsonThing.expectMap();
            String string = jsonMap.get("copy_ref").expectString();
            String string2 = jsonMap.get("expires").expectString();
            return new CreatedCopyRef(string, string2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DeltaEntry<MD> {
        public final String lcPath;
        public final MD metadata;

        public DeltaEntry(String string, MD MD) {
            this.lcPath = string;
            this.metadata = MD;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static final class JsonExtractor<MD>
        extends com.dropbox.client2.jsonextract.JsonExtractor<DeltaEntry<MD>> {
            public final com.dropbox.client2.jsonextract.JsonExtractor<MD> mdExtractor;

            public JsonExtractor(com.dropbox.client2.jsonextract.JsonExtractor<MD> jsonExtractor) {
                this.mdExtractor = jsonExtractor;
            }

            @Override
            public DeltaEntry<MD> extract(JsonThing jsonThing) throws JsonExtractionException {
                return JsonExtractor.extract(jsonThing, this.mdExtractor);
            }

            public static <MD> DeltaEntry<MD> extract(JsonThing jsonThing, com.dropbox.client2.jsonextract.JsonExtractor<MD> jsonExtractor) throws JsonExtractionException {
                JsonList jsonList = jsonThing.expectList();
                String string = jsonList.get(0).expectString();
                MD MD = jsonList.get(1).optionalExtract(jsonExtractor);
                return new DeltaEntry<MD>(string, MD);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DeltaPage<MD> {
        public final boolean reset;
        public final String cursor;
        public final List<DeltaEntry<MD>> entries;
        public final boolean hasMore;

        public DeltaPage(boolean bl, List<DeltaEntry<MD>> list, String string, boolean bl2) {
            this.reset = bl;
            this.entries = list;
            this.cursor = string;
            this.hasMore = bl2;
        }

        public static <MD> DeltaPage<MD> extractFromJson(JsonThing jsonThing, JsonExtractor<MD> jsonExtractor) throws JsonExtractionException {
            JsonMap jsonMap = jsonThing.expectMap();
            boolean bl = jsonMap.get("reset").expectBoolean();
            String string = jsonMap.get("cursor").expectString();
            boolean bl2 = jsonMap.get("has_more").expectBoolean();
            ArrayList<DeltaEntry<MD>> arrayList = jsonMap.get("entries").expectList().extract(new DeltaEntry.JsonExtractor<MD>(jsonExtractor));
            return new DeltaPage<MD>(bl, arrayList, string, bl2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ThumbFormat {
        PNG,
        JPEG;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ThumbSize {
        ICON_32x32("small"),
        ICON_64x64("medium"),
        ICON_128x128("large"),
        ICON_256x256("256x256"),
        BESTFIT_320x240("320x240_bestfit"),
        BESTFIT_480x320("480x320_bestfit"),
        BESTFIT_640x480("640x480_bestfit"),
        BESTFIT_960x640("960x640_bestfit"),
        BESTFIT_1024x768("1024x768_bestfit");

        private String size;

        private ThumbSize(String string2) {
            this.size = string2;
        }

        public String toAPISize() {
            return this.size;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DropboxLink {
        public final String url;
        public final Date expires;

        private DropboxLink(String string, boolean bl) {
            if (!bl && string.startsWith("https://")) {
                string = string.replaceFirst("https://", "http://");
                string = string.replaceFirst(":443/", "/");
            }
            this.url = string;
            this.expires = null;
        }

        private DropboxLink(Map<String, Object> map) {
            this(map, true);
        }

        private DropboxLink(Map<String, Object> map, boolean bl) {
            String string = (String)map.get("url");
            String string2 = (String)map.get("expires");
            this.expires = string2 != null ? RESTUtility.parseDate(string2) : null;
            if (!bl && string.startsWith("https://")) {
                string = string.replaceFirst("https://", "http://");
                string = string.replaceFirst(":443/", "/");
            }
            this.url = string;
        }
    }

    public static final class RequestAndResponse {
        public final HttpUriRequest request;
        public final HttpResponse response;

        protected RequestAndResponse(HttpUriRequest httpUriRequest, HttpResponse httpResponse) {
            this.request = httpUriRequest;
            this.response = httpResponse;
        }
    }

    protected static final class BasicUploadRequest
    implements UploadRequest {
        private final HttpUriRequest request;
        private final Session session;

        public BasicUploadRequest(HttpUriRequest httpUriRequest, Session session) {
            this.request = httpUriRequest;
            this.session = session;
        }

        public void abort() {
            this.request.abort();
        }

        public Entry upload() throws DropboxException {
            HttpResponse httpResponse;
            try {
                httpResponse = RESTUtility.execute(this.session, this.request, 180000);
            }
            catch (DropboxIOException dropboxIOException) {
                if (this.request.isAborted()) {
                    throw new DropboxPartialFileException(-1L);
                }
                throw dropboxIOException;
            }
            Object object = RESTUtility.parseAsJSON(httpResponse);
            Map map = (Map)object;
            return new Entry(map);
        }
    }

    public static interface UploadRequest {
        public void abort();

        public Entry upload() throws DropboxException;
    }

    public static class DropboxInputStream
    extends FilterInputStream {
        private final HttpUriRequest request;
        private final DropboxFileInfo info;

        public DropboxInputStream(HttpUriRequest httpUriRequest, HttpResponse httpResponse) throws DropboxException {
            super(null);
            HttpEntity httpEntity = httpResponse.getEntity();
            if (httpEntity == null) {
                throw new DropboxException("Didn't get entity from HttpResponse");
            }
            try {
                this.in = httpEntity.getContent();
            }
            catch (IOException iOException) {
                throw new DropboxIOException(iOException);
            }
            this.request = httpUriRequest;
            this.info = new DropboxFileInfo(httpResponse);
        }

        public void close() throws IOException {
            this.request.abort();
        }

        public DropboxFileInfo getFileInfo() {
            return this.info;
        }

        public void copyStreamToOutput(OutputStream outputStream, ProgressListener progressListener) throws DropboxIOException, DropboxPartialFileException, DropboxLocalStorageFullException {
            BufferedOutputStream bufferedOutputStream = null;
            long l = 0L;
            long l2 = 0L;
            long l3 = this.info.getFileSize();
            try {
                bufferedOutputStream = new BufferedOutputStream(outputStream);
                byte[] byArray = new byte[4096];
                while (true) {
                    long l4;
                    int n;
                    if ((n = this.read(byArray)) < 0) {
                        if (l3 < 0L || l >= l3) break;
                        throw new DropboxPartialFileException(l);
                    }
                    bufferedOutputStream.write(byArray, 0, n);
                    l += (long)n;
                    if (progressListener == null || (l4 = System.currentTimeMillis()) - l2 <= progressListener.progressInterval()) continue;
                    l2 = l4;
                    progressListener.onProgress(l, l3);
                }
                bufferedOutputStream.flush();
                outputStream.flush();
                try {
                    if (outputStream instanceof FileOutputStream) {
                        ((FileOutputStream)outputStream).getFD().sync();
                    }
                }
                catch (SyncFailedException syncFailedException) {
                    // empty catch block
                }
            }
            catch (IOException iOException) {
                String string = iOException.getMessage();
                if (string != null && string.startsWith("No space")) {
                    throw new DropboxLocalStorageFullException();
                }
                throw new DropboxPartialFileException(l);
            }
            finally {
                if (bufferedOutputStream != null) {
                    try {
                        bufferedOutputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                if (outputStream != null) {
                    try {
                        outputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                try {
                    this.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static final class DropboxFileInfo {
        private String mimeType = null;
        private long fileSize = -1L;
        private String charset = null;
        private Entry metadata = null;

        private DropboxFileInfo(HttpResponse httpResponse) throws DropboxException {
            String string;
            this.metadata = DropboxFileInfo.parseXDropboxMetadata(httpResponse);
            if (this.metadata == null) {
                throw new DropboxParseException("Error parsing metadata.");
            }
            this.fileSize = DropboxFileInfo.parseFileSize(httpResponse, this.metadata);
            if (this.fileSize == -1L) {
                throw new DropboxParseException("Error determining file size.");
            }
            Header header = httpResponse.getFirstHeader("Content-Type");
            if (header != null && (string = header.getValue()) != null) {
                String[] stringArray = string.split(";");
                if (stringArray.length > 0) {
                    this.mimeType = stringArray[0].trim();
                }
                if (stringArray.length > 1 && (stringArray = stringArray[1].split("=")).length > 1) {
                    this.charset = stringArray[1].trim();
                }
            }
        }

        private static Entry parseXDropboxMetadata(HttpResponse httpResponse) {
            if (httpResponse == null) {
                return null;
            }
            Header header = httpResponse.getFirstHeader("X-Dropbox-Metadata");
            if (header == null) {
                return null;
            }
            String string = header.getValue();
            Object object = JSONValue.parse((String)string);
            if (object == null) {
                return null;
            }
            Map map = (Map)object;
            return new Entry(map);
        }

        private static long parseFileSize(HttpResponse httpResponse, Entry entry) {
            long l = httpResponse.getEntity().getContentLength();
            if (l >= 0L) {
                return l;
            }
            if (entry != null) {
                return entry.bytes;
            }
            return -1L;
        }

        public final String getMimeType() {
            return this.mimeType;
        }

        @Deprecated
        public final long getContentLength() {
            return this.getFileSize();
        }

        public final long getFileSize() {
            return this.fileSize;
        }

        public final String getCharset() {
            return this.charset;
        }

        public final Entry getMetadata() {
            return this.metadata;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Entry {
        public long bytes;
        public String hash;
        public String icon;
        public boolean isDir;
        public String modified;
        public String clientMtime;
        public String path;
        public String root;
        public String size;
        public String mimeType;
        public String rev;
        public boolean thumbExists;
        public boolean isDeleted;
        public List<Entry> contents;
        public static final JsonExtractor<Entry> JsonExtractor = new JsonExtractor<Entry>(){

            @Override
            public Entry extract(JsonThing jsonThing) throws JsonExtractionException {
                return new Entry((Map)jsonThing.expectMap().internal);
            }
        };

        public Entry(Map<String, Object> map) {
            this.bytes = DropboxAPI.getFromMapAsLong(map, "bytes");
            this.hash = (String)map.get("hash");
            this.icon = (String)map.get("icon");
            this.isDir = DropboxAPI.getFromMapAsBoolean(map, "is_dir");
            this.modified = (String)map.get("modified");
            this.clientMtime = (String)map.get("client_mtime");
            this.path = (String)map.get("path");
            this.root = (String)map.get("root");
            this.size = (String)map.get("size");
            this.mimeType = (String)map.get("mime_type");
            this.rev = (String)map.get("rev");
            this.thumbExists = DropboxAPI.getFromMapAsBoolean(map, "thumb_exists");
            this.isDeleted = DropboxAPI.getFromMapAsBoolean(map, "is_deleted");
            Object object = map.get("contents");
            if (object != null && object instanceof JSONArray) {
                this.contents = new ArrayList<Entry>();
                for (Object e : (JSONArray)object) {
                    if (!(e instanceof Map)) continue;
                    this.contents.add(new Entry((Map)e));
                }
            } else {
                this.contents = null;
            }
        }

        public Entry() {
        }

        public String fileName() {
            int n = this.path.lastIndexOf(47);
            return this.path.substring(n + 1, this.path.length());
        }

        public String parentPath() {
            if (this.path.equals("/")) {
                return "";
            }
            int n = this.path.lastIndexOf(47);
            return this.path.substring(0, n + 1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Account
    implements Serializable {
        private static final long serialVersionUID = 2097522622341535732L;
        public final String country;
        public final String displayName;
        public final long quota;
        public final long quotaNormal;
        public final long quotaShared;
        public final long uid;
        public final String referralLink;

        protected Account(Map<String, Object> map) {
            this.country = (String)map.get("country");
            this.displayName = (String)map.get("display_name");
            this.uid = DropboxAPI.getFromMapAsLong(map, "uid");
            this.referralLink = (String)map.get("referral_link");
            Object object = map.get("quota_info");
            Map map2 = (Map)object;
            this.quota = DropboxAPI.getFromMapAsLong(map2, "quota");
            this.quotaNormal = DropboxAPI.getFromMapAsLong(map2, "normal");
            this.quotaShared = DropboxAPI.getFromMapAsLong(map2, "shared");
        }

        protected Account(String string, String string2, long l, String string3, long l2, long l3, long l4) {
            this.country = string;
            this.displayName = string2;
            this.uid = l;
            this.referralLink = string3;
            this.quota = l2;
            this.quotaNormal = l3;
            this.quotaShared = l4;
        }
    }
}

