package com.truchsess.send2car.geo.api;

import com.truchsess.send2car.geo.entity.Place;

import java.util.List;

import retrofit2.Call;
import retrofit2.http.GET;
import retrofit2.http.Query;

/**********************************************************************************************
 Copyright (C) 2018 Norbert Truchsess norbert.truchsess@t-online.de

 This program is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **********************************************************************************************/
public interface NominatimApi {

    public static final String NOMINATIM_URL = "https://nominatim.openstreetmap.org";

    @GET("reverse?format=jsonv2&addressdetails=1&extratags=1&namedetails=1")
    public Call<Place> reverse(@Query("lat") String lat, @Query("lon") String lon);

    @GET("search?format=jsonv2&addressdetails=1&extratags=1&namedetails=1")
    public Call<List<Place>> search(@Query("q") String query);

}
