CbResult callback(void* callBackData)
{
   App* app = (App*)callBackData;
   return app->elapsed_time() <500.0? CONTINUE:
          app->elapsed_time() <1000.0? HURRY_UP:
          STOP_NOW;
}

class GameView : public View
{
public:
   GameView(App& application): app(application),
      menu(80,  20, 180, 40,   "MENU", !flip_y),
      undo(220, 20, 320, 40,   "UNDO", !flip_y),
      animation(50)
   {
      lx = ly = 0;
      undo.background_color(red);
      menu.background_color(red);

      add_ctrl(undo);
      add_ctrl(menu);
   }

   void on_key(int x, int y, unsigned key, unsigned flags)
   {
      if (key == 27 || key == 0x4000010e /* Android BACK key*/)
      {
         undo.status(true);
         on_ctrl_change();
      }
   }

   virtual void on_ctrl_change()
   {
      app.wait_mode(true);
      if (app.gomoku.endOfTheGame())
      {
         animation = 0;
      }
      if (app.gomoku.currentPlayer() == WHITE && app.p1level
            || app.gomoku.currentPlayer() == BLACK && app.p2level)
      {
         app.wait_mode(false);
      }

      if (undo.status())
      {
         animation = 10;
         undo.status(false);
         if (undoList.empty())
            return;
         Move m = undoList.top(); undoList.pop();
         app.gomoku.undo(m);
         if (app.gomoku.currentPlayer() == WHITE  && app.p1level
               || app.gomoku.currentPlayer() == BLACK  && app.p2level)
         {
            if (undoList.empty())
               return;
            m = undoList.top(); undoList.pop();
            app.gomoku.undo(m);
         }
      }

      if (menu.status())
      {
         menu.status(false);
         app.changeView("menu");
      }
      app.force_redraw();
   }

   virtual void on_resize(int, int)
   {
      app.force_redraw();
      double w = app.rbuf_window().width();
      double h = app.rbuf_window().height();
      size = int(std::min(w*0.95, h*0.9));
      hshift = h - size;
      hshift -= hshift/4;
      wshift = w - size;
      wshift /= 2;
   }

   void enter()
   {
      app.play_music(rand()%4, 40);
   }

   virtual void on_idle()
   {
      if (animation)
      {
         animation--;
         app.wait_mode(false);
         usleep(1000);
         app.force_redraw();
         return;
      }

      if (app.gomoku.endOfTheGame())
      {
         app.wait_mode(true);
         return;
      }

      if (app.gomoku.currentPlayer() == WHITE && !app.p1level
            || app.gomoku.currentPlayer() == BLACK && !app.p2level)
      {
         app.wait_mode(true);
         return;
      }

      app.start_timer();
      Move m = ai_move(app.gomoku, app.gomoku.currentPlayer() == WHITE?
            app.p1level : app.p2level, callback, (void*)&app);
      app.gomoku.move(m.first, m.second);
      undoList.push(m);
      animation = app.gomoku.endOfTheGame()? 50: 20;
      app.cPoints += app.gomoku.endOfTheGame()? 1: 0;
      app.wait_mode(false);
      app.force_redraw();
      app.play_sound(
            app.gomoku.endOfTheGame()? 2:
            app.gomoku.currentPlayer() == WHITE? 0:1,
            500);

   }

   int pixToX(int x)
   {
      x -= wshift;
      if (x < 0) return -1;

      double wsize = size/(SIZE-1);
      return (x+wsize/2)/wsize;
   }
   int pixToY(int y)
   {
      y -= hshift;
      if (y < 0) return -1;

      double hsize = size/(SIZE-1);
      return (y+hsize/2)/hsize;
   }


   virtual void on_mouse_button_up(int x, int y, unsigned flags)
   {
      if (m_ctrls.on_mouse_button_up(x, y))
      {
         app.on_ctrl_change();
         app.force_redraw();
      }

      try {
         app.gomoku.move(pixToX(x), pixToY(y));
         animation = app.gomoku.endOfTheGame()? 50: 20;
         app.hPoints +=  app.gomoku.endOfTheGame()? 1: 0;
         undoList.push(Move(pixToX(x), pixToY(y)));
         app.play_sound(
               app.gomoku.endOfTheGame()? 2:
               app.gomoku.currentPlayer() == WHITE? 0:1,
               500);
      } catch (MoveNotValid& m) {}
      app.force_redraw();
      app.wait_mode(false);
   }

   virtual void on_mouse_button_down(int x, int y, unsigned flags)
   {
      if (m_ctrls.on_mouse_button_down(x, y))
      {
         app.on_ctrl_change();
         app.force_redraw();
         return;
      }
   }

   virtual void on_mouse_move(int x, int y, unsigned flags)
   {
      if (m_ctrls.on_mouse_move(x, y, (flags & agg::mouse_left) != 0))
      {
         app.on_ctrl_change();
         app.force_redraw();
         return;
      }

      if (! flags & agg::mouse_left)
         return;
   }
   virtual void on_multi_gesture(float x, float y,
         float dTheta, float dDist, int numFingers)
   {
   }


   virtual void on_draw()
   {
      pixfmt_type pf(app.rbuf_window());;
      renderer_base_type rbase(pf);
      agg::rasterizer_scanline_aa<> ras;
      agg::scanline_u8 sl;
      ras.reset();
      rbase.clear(lgray);

      double s = 1.0*size/(SIZE-1);

      int i;
      for (i = 0; i< SIZE; i++)
         rbase.blend_hline(wshift, s*i+hshift, size+wshift, lblue, 65);

      for (i = 0; i< SIZE; i++)
         rbase.blend_vline(s*i+wshift, hshift, size+hshift, lblue, 64);

      renderer_scanline_type ren_sl(rbase);
      for (int i = 0; i < SIZE; i++)
         for (int j = 0; j < SIZE; j++)
         {
            if (app.gomoku.getPoint(i, j) == EMPTY)
               continue;

            ren_sl.color(app.gomoku.getPoint(i, j) == WHITE?
                  agg::rgba(1, 1, 1, 0.9):
                  agg::rgba(0.1, 0.1, 0.1, 0.9));
            agg::ellipse e;
            ras.reset();
            e.init(wshift+s*i, hshift+s*j, s*0.4, s*0.4, 128);
            ras.add_path(e);
            agg::render_scanlines(ras, sl, ren_sl);

         }
      if (animation && app.gomoku.endOfTheGame())
      {
         ren_sl.color(agg::rgba(1, 0, 0, 0.02*animation--));
         ras.reset();
         for (int i = 0; i < 5; i++)
         {
            agg::ellipse e;
            e.init(wshift+s*app.gomoku.winnigRow[i].first,
                   hshift+s*app.gomoku.winnigRow[i].second,
                   s*0.4, s*0.4, 128);
            ras.add_path(e);
         }
         agg::render_scanlines(ras, sl, ren_sl);
      } else if (animation && !undoList.empty())
      {
         ren_sl.color(agg::rgba(1, 0, 0, 0.02*animation--));
         ras.reset();
         agg::ellipse e;
         Move m = undoList.top();
         e.init(wshift+s*m.first, hshift+s*m.second, s*0.4, s*0.4, 128);
         ras.add_path(e);
         agg::render_scanlines(ras, sl, ren_sl);
      }

      double scale = app.rbuf_window().width()/400.0;
      static agg::trans_affine shape_mtx; shape_mtx.reset();
      shape_mtx *= agg::trans_affine_scaling(scale);
      shape_mtx *= agg::trans_affine_translation(0, 0);
      undo.transform(shape_mtx);
      menu.transform(shape_mtx);

      agg::render_ctrl(ras, sl, rbase, undo);
      agg::render_ctrl(ras, sl, rbase, menu);
   }
private:
    App& app;
    std::stack<Move> undoList;
    int size, wshift, hshift;
    int lx, ly;
    agg::button_ctrl<agg::rgba8> undo;
    agg::button_ctrl<agg::rgba8> menu;
    int animation;
};

