class ResultView : public View
{
public:
   ResultView(App& application): app(application),
   newGame (20,  20, 120, 40,   "New Game",  !flip_y)
   {
      newGame.background_color(red);
      add_ctrl(newGame);
   }

   virtual void on_draw()
   {
      pixfmt_type   pf(app.rbuf_window());
      pixfmt_pre    pixf_pre(app.rbuf_window());
      agg::renderer_base<pixfmt_type> rbase(pf);
      renderer_base_pre rb_pre(pixf_pre);
      agg::rasterizer_scanline_aa<> ras;
      agg::scanline_u8 sl;
      agg::span_allocator<color_type> sa;
      ras.reset();
      rbase.clear(lgray);

      double scale = app.rbuf_window().width()/380.0;
      static agg::trans_affine shape_mtx; shape_mtx.reset();
      shape_mtx *= agg::trans_affine_scaling(scale);
      shape_mtx *= agg::trans_affine_translation(0, 0);
      newGame.transform(shape_mtx);

      int imgIdx = 9 + rand()%2;
      pixfmt_type img_pixf(app.rbuf_img(imgIdx));
      rbase.copy_from(app.rbuf_img(imgIdx), 0, app.rbuf_window().width()-app.rbuf_img(imgIdx).width(), 0);

      agg::render_ctrl(ras, sl, rbase, newGame);

      char string[200];
      sprintf(string, "Congratulations!\n\nYou finished the 24 game in %ds\n\n"
            "Top Times:\n\n%ds\n\n%ds\n\n%ds", app.gameSec,
            app.bestSec[0], app.bestSec[1], app.bestSec[2]);

      app.draw_text(40, 200*scale, 10*scale, string);
   }

   virtual void on_ctrl_change()
   {
      if (newGame.status())
      {
         newGame.status(false);
         app.changeView("game");
         app.start_timer();
         app.scores = 0;
      }
   }

   virtual void on_mouse_button_up(int x, int y, unsigned flags)
   {
      if (m_ctrls.on_mouse_button_up(x, y))
      {
         app.on_ctrl_change();
         app.force_redraw();
      }
   }

   virtual void on_mouse_button_down(int x, int y, unsigned flags)
   {
      if (m_ctrls.on_mouse_button_down(x, y))
      {
         app.on_ctrl_change();
         app.force_redraw();
         return;
      }
   }

private:
    App& app;
    agg::button_ctrl<agg::rgba8> newGame;
};
