package com.tomer.draw.gallery

import android.graphics.Rect
import android.support.v7.widget.RecyclerView
import android.view.View

/**
 * DrawEverywhere
 * Created by Tomer Rosenfeld on 7/29/17.
 */
class GridSpacingItemDecoration(private val spanCount: Int, private val spacing: Int, private val includeEdge: Boolean) : RecyclerView.ItemDecoration() {
	
	override fun getItemOffsets(outRect: Rect, view: View, parent: RecyclerView, state: RecyclerView.State?) {
		val position = parent.getChildAdapterPosition(view)
		val column = position % spanCount
		if (includeEdge) {
			outRect.left = spacing - column * spacing / spanCount
			outRect.right = (column + 1) * spacing / spanCount
			if (position < spanCount) {
				outRect.top = spacing
			}
			outRect.bottom = spacing
		} else {
			outRect.left = column * spacing / spanCount
			outRect.right = spacing - (column + 1) * spacing / spanCount
			if (position >= spanCount) {
				outRect.top = spacing
			}
		}
	}
}
