# Join the development
* Before you join development, please set up the project on your local machine, run it and go through the application completely. Press on any button you can find and see where it leads to. Explore.You'll be more familiar with what is where and might even get some cool ideas on how to improve various aspects of the app.
* If you would like to work on an issue, drop in a comment at the issue. If it is already assigned to someone, but there is no sign of any work being done, please free to drop in a comment so that the issue can be assigned to you if the previous assignee has dropped it entirely.

# Contributing

When contributing to this repository, please first discuss the change you wish to make via issue.

## Pull Request Process

1. Ensure any install or build dependencies are removed before the end of the layer when doing a
   build.
2. Check that there are no conflicts and your request passes [Travis](Travis-ci.org) build. Check the log of the pass test if it fails the build.
3. Give the description of the issue that you want to resolve in the pull request message. The format of the commit message to be fixed    - **Fixes #[issue number] [Description of the issue]** Example: **Fixes #529: Add toast warning in `MainActivity.java`**
4. Wait for the maintainers to review your pull request and do the changes if requested.

## Contributions Best Practices

### Commits

* Write clear meaningful git commit messages (Do read [here](http://chris.beams.io/posts/git-commit/))
* Make sure your PR's description contains GitHub's special keyword references that automatically close the related issue when the PR is merged. (For more info click [here]( https://github.com/blog/1506-closing-issues-via-pull-requests))
* When you make very very minor changes to a PR of yours (like for example fixing a failing Travis build or some small style corrections or minor changes requested by reviewers) make sure you squash your commits afterwards so that you don't have an absurd number of commits for a very small fix. (Learn how to squash at [here](https://davidwalsh.name/squash-commits-git ))
* When you're submitting a PR for a UI-related issue, it would be really awesome if you add a screenshot of your change or a link to a deployment where it can be tested out along with your PR. It makes it very easy for the reviewers and you'll also get reviews quicker.

### Feature Requests and Bug Reports
* When you file a feature request or when you are submitting a bug report to the [issue tracker](https://github.com/ctodobom/OpenNoteScanner/issues), make sure you add steps to reproduce it. Especially if that bug is some weird/rare one.

## Code of Conduct

### Our Standards

Examples of behavior that contributes to creating a positive environment
include:

* Using welcoming and inclusive language
* Being respectful of differing viewpoints and experiences
* Gracefully accepting constructive criticism
* Focusing on what is best for the community
* Showing empathy towards other community members

### Our Responsibilities

Project maintainers are responsible for clarifying the standards of acceptable
behavior and are expected to take appropriate and fair corrective action in
response to any instances of unacceptable behavior.

Project maintainers have the right and responsibility to remove, edit, or
reject comments, commits, code, issues, and other contributions
that are not aligned to this Code of Conduct, or to ban temporarily or
permanently any contributor for other behavior that they deem inappropriate,
threatening, offensive, or harmful.

