/*
 * Decompiled with CFR 0.152.
 */
package com.physicaloid.lib.usb.driver.uart;

import android.content.Context;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.util.Log;
import com.physicaloid.lib.UsbVidList;
import com.physicaloid.lib.framework.SerialCommunicator;
import com.physicaloid.lib.usb.UsbCdcConnection;
import com.physicaloid.lib.usb.UsbVidPid;
import com.physicaloid.lib.usb.driver.uart.ReadLisener;
import com.physicaloid.lib.usb.driver.uart.UartConfig;
import com.physicaloid.misc.RingBuffer;
import java.util.ArrayList;
import java.util.List;

public class UartCdcAcm
extends SerialCommunicator {
    private static final String TAG = UartCdcAcm.class.getSimpleName();
    private static final boolean DEBUG_SHOW = false;
    private static final int DEFAULT_BAUDRATE = 9600;
    private UsbCdcConnection mUsbConnetionManager;
    private UartConfig mUartConfig;
    private static final int RING_BUFFER_SIZE = 1024;
    private static final int USB_READ_BUFFER_SIZE = 256;
    private static final int USB_WRITE_BUFFER_SIZE = 256;
    private RingBuffer mBuffer;
    private boolean mReadThreadStop = true;
    private UsbDeviceConnection mConnection;
    private UsbEndpoint mEndpointIn;
    private UsbEndpoint mEndpointOut;
    private boolean isOpened;
    private Runnable mLoop = new Runnable(){

        @Override
        public void run() {
            int len = 0;
            byte[] rbuf = new byte[256];
            while (true) {
                try {
                    len = UartCdcAcm.this.mConnection.bulkTransfer(UartCdcAcm.this.mEndpointIn, rbuf, rbuf.length, 50);
                }
                catch (Exception e) {
                    Log.e((String)TAG, (String)e.toString());
                }
                if (len > 0) {
                    UartCdcAcm.this.mBuffer.add(rbuf, len);
                    UartCdcAcm.this.onRead(len);
                }
                if (UartCdcAcm.this.mReadThreadStop) {
                    return;
                }
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    };
    private List<ReadLisener> uartReadListenerList = new ArrayList<ReadLisener>();
    private boolean mStopReadListener = false;

    public UartCdcAcm(Context context) {
        super(context);
        this.mUsbConnetionManager = new UsbCdcConnection(context);
        this.mUartConfig = new UartConfig();
        this.mBuffer = new RingBuffer(1024);
        this.isOpened = false;
    }

    @Override
    public boolean open() {
        UsbVidList[] usbVidListArray = UsbVidList.values();
        int n = usbVidListArray.length;
        int n2 = 0;
        while (n2 < n) {
            UsbVidList id = usbVidListArray[n2];
            if (this.open(new UsbVidPid(id.getVid(), 0))) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean open(UsbVidPid ids) {
        if (this.mUsbConnetionManager.open(ids, true)) {
            this.mConnection = this.mUsbConnetionManager.getConnection();
            this.mEndpointIn = this.mUsbConnetionManager.getEndpointIn();
            this.mEndpointOut = this.mUsbConnetionManager.getEndpointOut();
            if (!this.init()) {
                return false;
            }
            if (!this.setBaudrate(9600)) {
                return false;
            }
            this.mBuffer.clear();
            this.startRead();
            this.isOpened = true;
            return true;
        }
        return false;
    }

    @Override
    public boolean close() {
        this.stopRead();
        this.isOpened = false;
        return this.mUsbConnetionManager.close();
    }

    @Override
    public int read(byte[] buf, int size) {
        return this.mBuffer.get(buf, size);
    }

    @Override
    public int write(byte[] buf, int size) {
        if (buf == null) {
            return 0;
        }
        int offset = 0;
        byte[] wbuf = new byte[256];
        while (offset < size) {
            int write_size = 256;
            if (offset + write_size > size) {
                write_size = size - offset;
            }
            System.arraycopy(buf, offset, wbuf, 0, write_size);
            int written_size = this.mConnection.bulkTransfer(this.mEndpointOut, wbuf, write_size, 100);
            if (written_size < 0) {
                return -1;
            }
            offset += written_size;
        }
        return offset;
    }

    private void stopRead() {
        this.mReadThreadStop = true;
    }

    private void startRead() {
        if (this.mReadThreadStop) {
            this.mReadThreadStop = false;
            new Thread(this.mLoop).start();
        }
    }

    @Override
    public boolean setUartConfig(UartConfig config) {
        boolean res = true;
        boolean ret = true;
        if (this.mUartConfig.baudrate != config.baudrate) {
            res = this.setBaudrate(config.baudrate);
            boolean bl = ret = ret && res;
        }
        if (this.mUartConfig.dataBits != config.dataBits) {
            res = this.setDataBits(config.dataBits);
            boolean bl = ret = ret && res;
        }
        if (this.mUartConfig.parity != config.parity) {
            res = this.setParity(config.parity);
            boolean bl = ret = ret && res;
        }
        if (this.mUartConfig.stopBits != config.stopBits) {
            res = this.setStopBits(config.stopBits);
            boolean bl = ret = ret && res;
        }
        if (this.mUartConfig.dtrOn != config.dtrOn || this.mUartConfig.rtsOn != config.rtsOn) {
            res = this.setDtrRts(config.dtrOn, config.rtsOn);
            ret = ret && res;
        }
        return ret;
    }

    private boolean init() {
        if (this.mConnection == null) {
            return false;
        }
        int ret = this.mConnection.controlTransfer(33, 34, 0, 0, null, 0, 0);
        return ret >= 0;
    }

    @Override
    public boolean isOpened() {
        return this.isOpened;
    }

    @Override
    public boolean setBaudrate(int baudrate) {
        byte[] baudByte = new byte[]{(byte)(baudrate & 0xFF), (byte)((baudrate & 0xFF00) >> 8), (byte)((baudrate & 0xFF0000) >> 16), (byte)((baudrate & 0xFF000000) >> 24)};
        byte[] byArray = new byte[7];
        byArray[0] = baudByte[0];
        byArray[1] = baudByte[1];
        byArray[2] = baudByte[2];
        byArray[3] = baudByte[3];
        byArray[6] = 8;
        int ret = this.mConnection.controlTransfer(33, 32, 0, 0, byArray, 7, 100);
        if (ret < 0) {
            return false;
        }
        this.mUartConfig.baudrate = baudrate;
        return true;
    }

    @Override
    public boolean setDataBits(int dataBits) {
        this.mUartConfig.dataBits = dataBits;
        return false;
    }

    @Override
    public boolean setParity(int parity) {
        this.mUartConfig.parity = parity;
        return false;
    }

    @Override
    public boolean setStopBits(int stopBits) {
        this.mUartConfig.stopBits = stopBits;
        return false;
    }

    @Override
    public boolean setDtrRts(boolean dtrOn, boolean rtsOn) {
        int ret;
        int ctrlValue = 0;
        if (dtrOn) {
            ctrlValue |= 1;
        }
        if (rtsOn) {
            ctrlValue |= 2;
        }
        if ((ret = this.mConnection.controlTransfer(33, 34, ctrlValue, 0, null, 0, 100)) < 0) {
            return false;
        }
        this.mUartConfig.dtrOn = dtrOn;
        this.mUartConfig.rtsOn = rtsOn;
        return true;
    }

    @Override
    public UartConfig getUartConfig() {
        return this.mUartConfig;
    }

    @Override
    public int getBaudrate() {
        return this.mUartConfig.baudrate;
    }

    @Override
    public int getDataBits() {
        return this.mUartConfig.dataBits;
    }

    @Override
    public int getParity() {
        return this.mUartConfig.parity;
    }

    @Override
    public int getStopBits() {
        return this.mUartConfig.stopBits;
    }

    @Override
    public boolean getDtr() {
        return this.mUartConfig.dtrOn;
    }

    @Override
    public boolean getRts() {
        return this.mUartConfig.rtsOn;
    }

    @Override
    public void clearBuffer() {
        this.mBuffer.clear();
    }

    @Override
    public void addReadListener(ReadLisener listener) {
        this.uartReadListenerList.add(listener);
    }

    @Override
    public void clearReadListener() {
        this.uartReadListenerList.clear();
    }

    @Override
    public void startReadListener() {
        this.mStopReadListener = false;
    }

    @Override
    public void stopReadListener() {
        this.mStopReadListener = true;
    }

    private void onRead(int size) {
        if (this.mStopReadListener) {
            return;
        }
        for (ReadLisener listener : this.uartReadListenerList) {
            listener.onRead(size);
        }
    }
}

