English | [中文](/README-cn.md)
# OpenHub
[![Releases](https://img.shields.io/badge/android-5.0%2B-brightgreen.svg)](https://play.google.com/store/apps/details?id=com.thirtydegreesray.openhub)
[![Releases](https://img.shields.io/github/release/ThirtyDegreesRay/OpenHub.svg)](https://github.com/ThirtyDegreesRay/OpenHub/releases/latest)

An **open-source** GitHub Android client app, faster and concise.

[![Google Play](https://raw.githubusercontent.com/ThirtyDegreesRay/OpenHub/master/art/google_play.png?raw=true)](https://play.google.com/store/apps/details?id=com.thirtydegreesray.openhub)
[![Coolapk](https://raw.githubusercontent.com/ThirtyDegreesRay/OpenHub/master/art/coolapk.png?raw=true)](https://www.coolapk.com/apk/com.thirtydegreesray.openhub)

## Features

### App
* One login types (OAuth)
* Light, dark, and AMOLED dark theme, multiple accent colors
* Markdown and code highlighting support
* English, Simplified Chinese, Hebrew, German, Hindi, Portuguese, Korea, Spanish, Traditional Chinese, Russian, Polish, Georgian, Italian, Dutch, Czech and Portuguese(Brazil) support
* Offline mode
* Supports trending repositories page for all languages
* Supports multi-account switching
* Search repositories and users
* Shortcut support
* Notification support
* Bookmark users or repositories
* Record trace of the repositories or users you have viewed
* View Github collections
* View Github featured topics
* Support disable loading network images while using mobile network

### Repositories
* View repository information and repository branches
* Star, watch, and fork repositories
* View repository files, commits, and activity
* Download source code, releases, and files
* View your private, public, forked, and starred repositories
* View trending repositories sorted by day, week, or month
* Search repositories
* View recent wiki updates

### Users
* View user info
* View user followers, following, and organizations
* View user public repositories, starred repositories, and activity
* View your private repositories
* Follow and unfollow users
* Search users

### Organizations
* View organization information
* View organization public repositories and activity
* View organization members

### Issues
* View issue information, comments, and events
* Create, open, and close issues
* Create, edit, and delete issue comments
* Edit, add, and delete your labels
* Write comments with previews
* View your created, assigned, and mentioned issues
* View repository issues

### Commits
* View commit information and files
* View file diff
* View repository commits

### And more
* OpenHub is growing, and trying to be a better GitHub client.

## Screenshots

| News | Drawer | Profile |
|:-:|:-:|:-:|
| ![news](https://raw.githubusercontent.com/ThirtyDegreesRay/OpenHub/master/art/news.png?raw=true) | ![drawer](https://raw.githubusercontent.com/ThirtyDegreesRay/OpenHub/master/art/drawer.png?raw=true) | ![profile](https://raw.githubusercontent.com/ThirtyDegreesRay/OpenHub/master/art/profile.png?raw=true) |

| Repository | Commit | Code |
|:-:|:-:|:-:|
| ![repo](https://raw.githubusercontent.com/ThirtyDegreesRay/OpenHub/master/art/repo.png?raw=true) | ![commit](https://raw.githubusercontent.com/ThirtyDegreesRay/OpenHub/master/art/commit.png?raw=true) | ![code](https://raw.githubusercontent.com/ThirtyDegreesRay/OpenHub/master/art/code.png?raw=true) |

## Thanks for open source

* [ButterKnife](https://github.com/JakeWharton/butterknife) Bind Android views and callbacks to fields and methods.
* [GreenDao](https://github.com/greenrobot/greenDAO) A light & fast ORM solution for Android that maps objects to SQLite databases.
* [EventBus](https://github.com/greenrobot/EventBus) Android optimized event bus that simplifies communication between Activities, Fragments, Threads, Services, etc.
* [RxJava](https://github.com/ReactiveX/RxJava) A library for composing asynchronous and event-based programs using observable sequences for the Java VM.
* [RxAndroid](https://github.com/ReactiveX/RxAndroid) RxJava bindings for Android.
* [Retrofit](https://github.com/square/retrofit) Type-safe HTTP client for Android and Java by Square, Inc.
* [Dagger](https://github.com/google/dagger) A fast dependency injector for Android and Java.
* [Glide](https://github.com/bumptech/glide) An image loading and caching library for Android focused on smooth scrolling.
* [code-prettify](https://github.com/google/code-prettify) An embeddable script that makes source-code snippets in HTML prettier.
* [DataAutoAccess](https://github.com/ThirtyDegreesRay/DataAutoAccess) A simple way to access android bundle data.
* [CircleImageView](https://github.com/hdodenhof/CircleImageView) A circular ImageView for Android.
* [Toasty](https://github.com/GrenderG/Toasty) The usual Toast, but with steroids 💪.
* [material-about-library](https://github.com/daniel-stoneuk/material-about-library) Makes it easy to create beautiful about screens for your apps.
* [material-dialogs](https://github.com/afollestad/material-dialogs) A beautiful, fluid, and customizable dialogs API.
* [GitHub-Trending](https://github.com/thedillonb/GitHub-Trending) Scrapes GitHub's Trending Pages.
* [RichText](https://github.com/zzhoujay/RichText) Rich text parser for Android, support markdown and html.
* [jsoup](https://github.com/jhy/jsoup) Java HTML Parser, with best of DOM, CSS, and jquery.
* [OctoDroid](https://github.com/slapperwan/gh4a) This application provides access to GitHub and lets you stay connected with your network.
* [FastHub](https://github.com/k0shk0sh/FastHub) FastHub the ultimate GitHub client for Android.

## Contributions(*Order by commit time*)
* [moriel5](https://github.com/moriel5) - Hebrew translation
* [Henry2o1o](https://github.com/Henry2o1o), [squeezer11](https://github.com/squeezer11), [ropaha](https://github.com/ropaha) - German translation
* [Edfgdz](https://github.com/Edfgdz) - Testing and suggest
* [pzhlkj6612](https://github.com/pzhlkj6612) - Improve the translation of Chinese readme
* [hiteshnayak305](https://github.com/hiteshnayak305) - Hindi translation
* [KcNirvana](https://github.com/KcNirvana) - Portuguese translation
* [sclickk](https://github.com/sclickk) - Improve English translation
* [Zazsona](https://github.com/Zazsona) - Add AMOLED theme
* [Aqueminivan](https://github.com/Aqueminivan) - Improve the translation of English readme
* [XF-zhjnc](https://github.com/XF-zhjnc) - Fix bugs
* [fergthh](https://github.com/fergthh) - Spanish translation
* [chiyi4488](https://github.com/chiyi4488) - Traditional Chinese translation
* [left4j](https://github.com/left4j) - Russian translation
* [TheParanoik](https://github.com/TheParanoik) - Polish translation
* [X1nto](https://github.com/X1nto) - Georgian translation
* [MerkeX](https://github.com/MerkeX) - Italian translation
* [Vistaus](https://github.com/Vistaus) - Dutch translation
* [pkubanek](https://github.com/pkubanek) - Czech translation
* [LouisUnnoficial](https://github.com/LouisUnnoficial) - Portuguese(Brazil) translation


## License
ThirtyDegreesRay:
> Copyright (C) 2017 ThirtyDegreesRay.
> Licensed under the [GPL-3.0](https://www.gnu.org/licenses/gpl.html).
> (See the [LICENSE](https://github.com/ThirtyDegreesRay/OpenHub/blob/master/LICENSE) file for the whole license text.)

Kosh(There are 13 files has some code copied from FastHub):
> Copyright (C) 2017 Kosh.
> Licensed under the [GPL-3.0](https://www.gnu.org/licenses/gpl.html) license.
> (See the [LICENSE](https://github.com/k0shk0sh/FastHub/blob/master/LICENSE) file for the whole license text.)
