app.factory('Settings', function() {
  return {
    all: function() {
      var settings = window.localStorage['settings'];
      if(settings) {
        return angular.fromJson(settings);
      }
      return {};
    },
    save: function(settings) {
      window.localStorage['settings'] = angular.toJson(settings);
    }
  }
});

app.factory('Books', function() {
  return {
    save: function(book) {
      // Find book index and replace it, then save the whole gang back to local storage.
      var saved_books = angular.fromJson(window.localStorage['books']);
      angular.forEach(saved_books, function(booker, idx) {
        if (booker.slug == book.slug) {
          saved_books[idx] = book;
        }
      });
      window.localStorage['books'] = angular.toJson(saved_books);
      return book;
    },

    save_all: function(books) {
      window.localStorage['books'] = angular.toJson(books);
      return true;
    },

    all: function() {
      var books = window.localStorage['books'];
      if (books) {
        return angular.fromJson(books);
      } else {
        return [];
      }
    },

    get: function(slug) {
      var books = this.all();
      var book = undefined;
      angular.forEach(books, function(b, idx) {
        if (b.slug == slug) {
          book = b;
        }
      });
      return book;
    }
  }
});
