package com.twofortyfouram.locale;

/**
 * Utility class containing constants for the Locale Developer Platform.
 */
/*
 * This class is NOT part of the public API.
 */
/* package */final class Constants
{
    /**
     * Log tag for logcat messages generated by the Locale Developer Platform
     */
    /*
     * This is NOT a public API. Third party apps should NOT use this log tag for their own log messages.
     */
    /* package */static final String LOG_TAG = "LocaleApiLibrary"; //$NON-NLS-1$

    /**
     * String package name for Locale.
     */
    /*
     * This is NOT a public API. Third parties should NOT rely on this being the only package name for Locale.
     */
    /* package */static final String LOCALE_PACKAGE = "com.twofortyfouram.locale"; //$NON-NLS-1$

    /**
     * Private constructor prevents instantiation
     *
     * @throws UnsupportedOperationException because this class cannot be instantiated.
     */
    private Constants()
    {
        throw new UnsupportedOperationException("This class is non-instantiable"); //$NON-NLS-1$
    }
}