package be.md.swiss.pairing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

import be.md.swiss.Pairing;
import be.md.swiss.Player;

public class Round {

	public  List<Pairing> pairings;
	public  int roundNumber;
	public  Player bye;
	public  Player BYE;
	public final Pairing byePairing;
	public final Set<Player> unpairedPlayers;

	private Round(int round, List<Pairing> pairings, Collection<Player> unpairedPlayers) {
		this.roundNumber = round;
		List<Pairing> tempPairings = new ArrayList<>();
		tempPairings.addAll(pairings);
		this.pairings = Collections.unmodifiableList(tempPairings);
		Set<Player> unpaired = new TreeSet<>(ComparatorFactory.getPlayerComparatorHighToLow());
		unpaired.addAll(unpairedPlayers);
		this.unpairedPlayers = Collections.unmodifiableSet(unpaired);
		if (!unpairedPlayers.isEmpty())
			bye = unpairedPlayers.iterator().next();
		else
			bye = null;
		byePairing = new ByePairing(bye);
	}

	@Override
	public String toString() {
		StringBuilder sb = new StringBuilder();
		sb.append("round:" + roundNumber + " ");
		sb.append("bye:" + bye + "\n");
		for (Pairing p : pairings)
			sb.append(p+"\n");
		return sb.toString();
	}


    public Player getBYE(Set<Player> players) {
        Set<Player> unPaired = new HashSet<Player>();
        List<Pairing> temp = new ArrayList<Pairing>();
        List<Player> Players_holder = new ArrayList<Player>();
        temp.addAll(pairings);
     
        for(Pairing p : temp){
        	Players_holder.add(p.getWhite());
            Players_holder.add(p.getBlack());
         }
     
        unPaired.addAll(players);
 
        
        for(Player p : Players_holder){
            if(unPaired.contains(p)){
                unPaired.remove(p);
            }
        }
        if(!unPaired.isEmpty()){
            BYE = unPaired.iterator().next();
        }
        return BYE;
    }

	public static Round mergeRounds(int roundNumber, Collection<Round> pairingsPerScoreGroup, Player bye) {
		Set<Pairing> allPairings = new HashSet<>();

		Set<Player> unpairedPlayersUnique = new TreeSet<Player>(ComparatorFactory.getPlayerComparatorHighToLow());
		for (Round round : pairingsPerScoreGroup) {
			allPairings.addAll(round.pairings);
			unpairedPlayersUnique.addAll(round.unpairedPlayers);
		}

		Set<Player> removeUs = new TreeSet<>(ComparatorFactory.getPlayerComparatorHighToLow());
		for (Player possibleUnpaired : unpairedPlayersUnique) {
			if (playerPlaysIn(possibleUnpaired, allPairings)) {
				removeUs.add(possibleUnpaired);
			}
		}
		unpairedPlayersUnique.removeAll(removeUs);
		if (bye != null) {
			unpairedPlayersUnique.add(bye);
		}
		return new Round(roundNumber, toList(allPairings), toList(unpairedPlayersUnique));
	}

	private static <T> List<T> toList(Set<T> unpairedPlayersUnique) {
		List<T> unpairedList = new ArrayList<>();
		unpairedList.addAll(unpairedPlayersUnique);
		return unpairedList;
	}

	private static boolean playerPlaysIn(Player floater, Collection<Pairing> pairingsToCheckForFloater) {
		for (Pairing pairing : pairingsToCheckForFloater) {
			if (pairing.containsPlayer(floater))
				return true;
		}
		return false;
	}

	public boolean hasBye() {
		return bye != null;
	}

	public static Round createRound(int round, List<Pairing> argPairings) {
		return new Round(round, argPairings, new ArrayList<Player>());
	}

	public static Round createRound(int round, List<Pairing> argPairings, Player argBye) {
		List<Player> unpaired = new ArrayList<Player>();
		unpaired.add(argBye);
		return new Round(round, argPairings, unpaired);
	}

	public static Round createRound(int roundNr, List<Pairing> pairings, Collection<Player> unpairedPlayers) {
		return new Round(roundNr, pairings, unpairedPlayers);
	}

	public boolean hasPairings() {
		return !pairings.isEmpty();
	}

}
