import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:flutter_custom_tabs/flutter_custom_tabs.dart';

void main() => runApp(new SciHubApp());

class SciHubApp extends StatelessWidget {
  
  @override
  Widget build(BuildContext context) {
    return MaterialApp(
      title: 'SciHub',
      theme: ThemeData(
        primarySwatch: Colors.red,
      ),
      home: LinkPage(),
    );
  }
}

class LinkPage extends StatefulWidget {
  LinkPage({Key key}) : super(key: key);

  @override
  _LinkPageState createState() => _LinkPageState();
}

class _LinkPageState extends State<LinkPage> {
  
  final String info = "Use your browser to find a research article's DOI, open the link with 'DOI to SciHub,' and then download from a domain below.";
  String _dataShared;
  String _selectedURL;
  bool dropdowndelta = false;
  
  @override
  void initState() {
    super.initState();
    getSharedText();       
  }

  List<DropdownMenuItem<String>> buildAndGetDropDownMenuItems(List websites) {
    List<DropdownMenuItem<String>> items = new List();
    for (String website in websites) {
      items.add(new DropdownMenuItem(value: website + _dataShared, child: new Text(website)));
    }
    return items;
  }

  @override
  Widget build(BuildContext context) {
    if (_dataShared == null) {
      _dataShared = '';
    }
    
    List _scihubsites = ['https://sci-hub.tw/', 'https://sci-hub.se/', 'https://sci-hub.fun/'];
    List<DropdownMenuItem<String>> _dropDownMenuItems;
    _dropDownMenuItems = buildAndGetDropDownMenuItems(_scihubsites);

    // Initializes with the first list item if dropdown selection hasn't been made
    if (dropdowndelta == false) {
      _selectedURL = _dropDownMenuItems[0].value;
    }

    double imagescale = (MediaQuery.of(context).size.height * 1.39) - 813.95;

    return Scaffold(
      backgroundColor: Colors.white,
        appBar: new AppBar(
          title: const Text('DOI to SciHub'),
          backgroundColor: Theme.of(context).primaryColorDark,
        ),
        body: new Container (
          child: new Center(
          child: ListView(
            padding: const EdgeInsets.only(left:20.0, top: 5, right: 20.0),
            children: [
            
            Image.asset(
              'assets/logo.jpg', 
              height: imagescale),
            new Padding(padding: EdgeInsets.only(top:20),),
            
            new Text(
              info,
              style: TextStyle(
                fontSize: 15),
              textAlign: TextAlign.center),
            new Padding(padding: EdgeInsets.only(top:20),),

            new FlatButton(
              child: Text(
                'What is SciHub?',
                style: TextStyle(
                  color:Colors.black,
                  fontSize: 15,
                  fontWeight: FontWeight.normal)),
              color: Colors.white,
              splashColor: Theme.of(context).primaryColorDark,
              onPressed: () => _launchURL(context, 'https://sci-hub.tw/about'),
            ),
            new Padding(padding: EdgeInsets.only(top:20),),
            
            new SizedBox(
              height: 1.0,
              child: new Center(
                child: new Container(
                  margin: new EdgeInsetsDirectional.only(start: 1.0, end: 1.0),
                  height: 1.0,
                  color: Theme.of(context).primaryColorDark)
              ),
            ),
            new Padding(padding: EdgeInsets.only(top:20),),
            
            new FlatButton(
            child: Text(
              _dataShared,
              style: TextStyle(
                fontSize: 15,
                fontWeight: FontWeight.normal),
              textAlign: TextAlign.center),
            onPressed: () => _launchURL(context, _dataShared),
            splashColor: Theme.of(context).primaryColorDark,
            highlightColor: Theme.of(context).primaryColorDark,
          ),
            new Padding(padding: EdgeInsets.only(top: 10),),
            
            new Column(
            crossAxisAlignment: CrossAxisAlignment.center,
            mainAxisAlignment: MainAxisAlignment.center,
            children: <Widget>[new DropdownButton(
                value: _selectedURL,
                items: _dropDownMenuItems,
                onChanged: changedDropDownItem,
                iconSize: 30,
                elevation: 16,
                style:TextStyle(
                  color: Colors.black,
                  fontSize: 16,
                  fontWeight: FontWeight.w800,
                  letterSpacing: 0.7)
            )]),
            new Padding(padding: EdgeInsets.only(top:30),),
            
            new RaisedButton(
              child: Text(
                'Download',
                style: TextStyle(
                  color:Colors.white,
                  fontSize: 16,
                  fontWeight: FontWeight.w700)
                ),
              color: Theme.of(context).primaryColorDark,
              elevation: 8.0,
              splashColor: Theme.of(context).primaryColor,
              onPressed: () => _launchURL(context, _selectedURL),
              )],
          ),
        ),
      ));
  }

  getSharedText() async {
    const platform = const MethodChannel('app.channel.shared.data');
    String sharedURL = await platform.invokeMethod("getURL");

    if (sharedURL != null) {
      setState(() {
        _dataShared = sharedURL;
      });
    }
  }

  void changedDropDownItem(String selectedURL) {
    setState(() {
      dropdowndelta = true;
      _selectedURL = selectedURL;
    });
  }
}

void _launchURL(BuildContext context, String site) async {
    try {
      await launch(
        site,
        option: new CustomTabsOption(
          toolbarColor: Theme.of(context).primaryColorDark,
          enableDefaultShare: true,
          enableUrlBarHiding: true,
          showPageTitle: true,
          animation: new CustomTabsAnimation.slideIn(),
          extraCustomTabs: <String>[
            // https://play.google.com/store/apps/details?id=org.mozilla.firefox
            'org.mozilla.firefox',
            // https://play.google.com/store/apps/details?id=com.microsoft.emmx
            'com.microsoft.emmx',
          ],
        ),
      );
    } catch (e) {
      debugPrint(e.toString());
    }
  }