package com.sgr_b2.compass.activities;

import java.text.ParseException;

import android.app.AlertDialog;
import android.content.DialogInterface;
import android.content.Intent;
import android.location.Location;
import android.net.Uri;
import android.os.Bundle;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.EditText;

import com.sgr_b2.compass.R;
import com.sgr_b2.compass.db.BookmarksProvider;
import com.sgr_b2.compass.db.POI;
import com.sgr_b2.compass.io.Alien;
import com.sgr_b2.compass.io.Alien.Coords;
import com.sgr_b2.compass.io.AlienFactory;
import com.sgr_b2.compass.jni.Utils;
import com.sgr_b2.compass.ui.UnitsFormatting;


public class AddEditActivity
	extends TemporaryBaseActivity
	implements OnClickListener {

	public static final int MODE_ADD = 1;
	public static final int MODE_EDIT = 2;

	private BookmarksProvider provider = null;

	private POI poi = null;
	private int mode = -1;
	private Location current_location = null;

	public class Extras {
		public static final String MODE = "mode";
		public static final String POI = "poi";
		public static final String LOCATION = "current_location";
	}

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);

		setContentView(R.layout.layout_addedit);

		this.provider = new BookmarksProvider(this);

		Intent intent = getIntent();
		Uri alien_uri = intent.getData();
		final String alien_uri_str = (alien_uri == null ? null : alien_uri.toString());

		this.mode = (alien_uri_str == null
			? intent.getIntExtra(Extras.MODE, -1)
			: AddEditActivity.MODE_ADD);
		this.poi = (POI)intent.getSerializableExtra(Extras.POI);
		this.current_location = (Location)intent.getParcelableExtra(Extras.LOCATION);

		assert(this.mode == MODE_ADD || this.mode == MODE_EDIT);
		assert(this.mode == MODE_ADD || this.poi != null);

		setTitle(this.mode == MODE_ADD
			? getResources().getString(R.string.title_add_bookmark)
			: getResources().getString(R.string.title_edit_bookmark));

		if (mode == MODE_ADD) {
			if (alien_uri_str == null) {
				this.poi = new POI(0, 0, "");
			}
			else {
				Alien alien = AlienFactory.createFromURI(alien_uri_str.toString());
				if (alien == null) { // that's odd
					showOKAlert(getResources().getString(R.string.message_unsupported_alien),
						true);
					return;
				}

				Coords coords = alien.unmarshall(alien_uri_str.toString());
				if (coords == null) {
					showOKAlert(getResources().getString(R.string.message_invalid_alien),
						true);
					return;
				}

				this.poi = new POI(coords.lat, coords.lon, "");
			}
		}

		assert(this.poi != null);

		Button ok = (Button)findViewById(R.id.ok_button);
		ok.setOnClickListener(this);

		EditText poi_title = (EditText)findViewById(R.id.title_text);
		EditText poi_lat = (EditText)findViewById(R.id.lat_text);
		EditText poi_lon = (EditText)findViewById(R.id.lon_text);

		if (mode == MODE_EDIT || alien_uri_str != null) {
			poi_title.setText(String.valueOf(this.poi.title));
			poi_lat.setText(UnitsFormatting.formatCoord(this.poi.lat));
			poi_lon.setText(UnitsFormatting.formatCoord(this.poi.lon));
		}
		else if (this.current_location != null) {
			poi_lat.setText(UnitsFormatting.formatCoord((float)this.current_location.getLatitude()));
			poi_lon.setText(UnitsFormatting.formatCoord((float)this.current_location.getLongitude()));
		}
	}

	@Override
	public void onDestroy() {
		super.onDestroy();

		if (this.provider != null) {
			this.provider.dispose();
		}
	}

	@Override
	public void onResume() {
		super.onResume();

		findViewById(R.id.text_location_preloaded)
			.setVisibility(this.current_location != null
				? View.VISIBLE : View.INVISIBLE);
	}

	private void maybeReplacePOI(final String title, final float lat, final float lon) {
		assert(this.poi != null);

		POI poi = this.provider.hasPOI(title);

		// new POI w/o conflicts
		if (poi == null && this.mode == MODE_ADD) {
			this.provider.addPOI(new POI(lat, lon, title));
			finish();

			return;
		}

		// same POI, no real conflict
		if (this.mode == MODE_EDIT
			&& (poi == null || this.poi.id == poi.id)) {
			this.provider.updatePOI(new POI(lat, lon, title, this.poi.id));
			finish();

			return;
		}

		assert(poi != null);

		// real conflict
		final BookmarksProvider provider = this.provider;
		final POI this_poi = this.poi;
		final int this_mode = this.mode;
		final int conflicting_id = poi.id;

		AlertDialog.Builder builder = new AlertDialog.Builder(this);
		builder.setTitle(getTitle());
		builder.setMessage(R.string.message_bookmark_exists);
		builder.setPositiveButton(android.R.string.yes, new DialogInterface.OnClickListener() {
			@Override
			public void onClick(DialogInterface dialog, int which) {
				// delete old (edited) bookmark
				if (this_mode == MODE_EDIT) {
					provider.deletePOI(this_poi.title);
				}

				// what if power is interrupted at this point?
				// this is terrifying

				// then update conflicting bookmark
				provider.updatePOI(new POI(lat, lon, title, conflicting_id));

				finish();
			}
		});
		builder.setNegativeButton(android.R.string.no, null);
		builder.show();
	}

	private void showOKAlert(final String message, final boolean quit) {
		AlertDialog.Builder builder = new AlertDialog.Builder(this);
		builder.setTitle(getTitle());
		builder.setMessage(message);
		builder.setPositiveButton(android.R.string.ok, new DialogInterface.OnClickListener() {
			@Override
			public void onClick(DialogInterface dialog, int which) {
				if (quit) {
					finish();
				}
			}
		});

		builder.show();
	}

	@Override
	public void onClick(View v) {
		String poi_title = ((EditText)findViewById(R.id.title_text)).getText().toString();
		String poi_lat = ((EditText)findViewById(R.id.lat_text)).getText().toString();
		String poi_lon = ((EditText)findViewById(R.id.lon_text)).getText().toString();

		if (poi_title.length() < 1) {
			showOKAlert(getResources().getString(R.string.message_invalid_title),
				false);
			return;
		}

		if (poi_lat.length() < 1 || poi_lon.length() < 1) {
			showOKAlert(getResources().getString(R.string.message_invalid_coords),
				false);
			return;
		}

		float lat = 0;
		float lon = 0;

		try {
			lat = UnitsFormatting.parseCoord(poi_lat);
			lon = UnitsFormatting.parseCoord(poi_lon);

			lat = Utils.sanitizeLat(lat);
			lon = Utils.sanitizeLon(lon);
		}
		catch (ParseException e) {
			showOKAlert(getResources().getString(R.string.message_invalid_coords),
				false);
			return;
		}

		maybeReplacePOI(poi_title, lat, lon);
	}
}
