/*
   Copyright 2014 John Selbie

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
*/


package com.selbie.wrek;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.preference.PreferenceManager;
import android.view.Menu;
import android.view.MenuItem;

class ScheduleItemTemp
{
    public String Title;
    public String Description;
    public String ShowTime;
    public String URL;
    public int PictureID;
}

public class MainActivity extends Activity
{
    public final static String TAG = MainActivity.class.getSimpleName();


    @Override
    protected void onCreate(Bundle savedInstanceState)
    {
        super.onCreate(savedInstanceState);

        setContentView(R.layout.activity_main);

        // load up our preferences
        PreferenceManager.setDefaultValues(this, R.xml.preferences, false);

        MediaPlayerService.setApplicationContext(this.getApplicationContext());
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu)
    {
        // Inflate the menu; this adds items to the action bar if it is present.
        getMenuInflater().inflate(R.menu.main, menu);
        return true;
    }

    @Override
    public boolean onMenuItemSelected(int featureId, MenuItem item)
    {
        if (item.getItemId() == R.id.action_settings)
        {
            Intent i = new Intent(this, SettingsActivity.class);
            this.startActivity(i);
        }
        else if (item.getItemId() == R.id.action_about)
        {
            Intent i = new Intent(this, AboutActivity.class);
            this.startActivity(i);
        }

        return false;

    }

    @Override
    protected void onStop()
    {
        super.onStop();
    }

}
