/*
 * Copyright (C) 2016 Jorge Ruesga
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.ruesga.rview.misc;

import android.util.Base64;
import android.util.Log;

import com.google.gson.Gson;
import com.ruesga.rview.gerrit.BuildConfig;
import com.ruesga.rview.gerrit.GsonHelper;
import com.ruesga.rview.gerrit.PlatformAbstractionLayer;

public class SerializationManager {

    private static class AndroidPlatformAbstractionLayer implements PlatformAbstractionLayer {
        private static final String TAG = "Rview";

        public AndroidPlatformAbstractionLayer() {
        }

        @Override
        public boolean isDebugBuild() {
            return BuildConfig.DEBUG;
        }

        @Override
        public void log(String message) {
            Log.i(TAG ,message);
        }

        @Override
        public byte[] encodeBase64(byte[] data) {
            return Base64.encode(data, Base64.NO_WRAP);
        }

        @Override
        public byte[] decodeBase64(byte[] data) {
            return Base64.decode(data, Base64.NO_WRAP);
        }

        @Override
        public boolean hasConnectivity() {
            return false;
        }
    }


    private static Gson sGson;

    public static Gson getInstance() {
        if (sGson == null) {
            sGson = GsonHelper.createGerritGsonBuilder(
                    false, new AndroidPlatformAbstractionLayer()).create();
        }
        return sGson;
    }
}
