/*
* Copyright (C) 2014 kas70
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program. If not, see <http://www.gnu.org/licenses/>.
*/

package com.platypus.dicer;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.media.MediaPlayer;
import android.os.Bundle;
import android.os.Vibrator;
import android.preference.PreferenceManager;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.View;
import android.widget.ImageView;



public class MainActivity extends Activity implements SharedPreferences.OnSharedPreferenceChangeListener{

    public static final String PREFS = "PrefsFile";
    protected boolean onedie = false;
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        //restore preferences
        SharedPreferences settings = getSharedPreferences(PREFS, 0);
        onedie = settings.getBoolean("onedie", true);
        SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(this);
        sp.registerOnSharedPreferenceChangeListener(this);
        setOnedie();
    }

    protected void onStop() {
        super.onStop();
        //store preferences
        SharedPreferences settings = getSharedPreferences(PREFS, 0);
        SharedPreferences.Editor editor = settings.edit();
        editor.putBoolean("onedie", onedie);
        editor.commit();
    }

    @Override
    protected void onResume() {
       setOnedie();
        super.onResume();
    }

    public void setOnedie(){
        if(onedie) {
            setContentView(R.layout.activity_main);
        }
        else{
            setContentView(R.layout.activity_main_twodies);
        }
        setImageListeners();
    }
    protected void setImageListeners(){
        final ImageView v =  (ImageView)findViewById(R.id.dice);
        final ImageView vtwo = (ImageView) findViewById(R.id.dice2);

        if(onedie) {
            v.setOnTouchListener(new View.OnTouchListener() {
                @Override
                public boolean onTouch(View view, MotionEvent motionEvent) {
                    final MediaPlayer mp = MediaPlayer.create(getApplicationContext(), R.raw.dicesound);
                    mp.setOnCompletionListener(new MediaPlayer.OnCompletionListener() {
                        public void onCompletion(MediaPlayer mp) {
                            mp.release();
                        }
                    });
                    mp.start();
                    Vibrator vibrator = (Vibrator) getSystemService(Context.VIBRATOR_SERVICE);
                    vibrator.vibrate(50);
                    switch (rollDice()) {
                        case 1:
                            v.setImageResource(R.drawable.dice1);
                            break;
                        case 2:
                            v.setImageResource(R.drawable.dice2);
                            break;
                        case 3:
                            v.setImageResource(R.drawable.dice3);
                            break;
                        case 4:
                            v.setImageResource(R.drawable.dice4);
                            break;
                        case 5:
                            v.setImageResource(R.drawable.dice5);
                            break;
                        case 6:
                            v.setImageResource(R.drawable.dice6);
                            break;
                    }
                    return false;
                }
            });
        }
        else{
            v.setOnTouchListener(new View.OnTouchListener() {
                @Override
                public boolean onTouch(View view, MotionEvent motionEvent) {
                    final MediaPlayer mp = MediaPlayer.create(getApplicationContext(), R.raw.dicesound);
                    mp.setOnCompletionListener(new MediaPlayer.OnCompletionListener() {
                        public void onCompletion(MediaPlayer mp) {
                            mp.release();
                        }
                    });
                    mp.start();
                    Vibrator vibrator = (Vibrator) getSystemService(Context.VIBRATOR_SERVICE);
                    vibrator.vibrate(50);
                    switch (rollDice()) {
                        case 1:
                            vtwo.setImageResource(R.drawable.dice1);
                            break;
                        case 2:
                            vtwo.setImageResource(R.drawable.dice2);
                            break;
                        case 3:
                            vtwo.setImageResource(R.drawable.dice3);
                            break;
                        case 4:
                            vtwo.setImageResource(R.drawable.dice4);
                            break;
                        case 5:
                            vtwo.setImageResource(R.drawable.dice5);
                            break;
                        case 6:
                            vtwo.setImageResource(R.drawable.dice6);
                            break;
                    }
                    switch (rollDice()) {
                        case 1:
                            v.setImageResource(R.drawable.dice1);
                            break;
                        case 2:
                            v.setImageResource(R.drawable.dice2);
                            break;
                        case 3:
                            v.setImageResource(R.drawable.dice3);
                            break;
                        case 4:
                            v.setImageResource(R.drawable.dice4);
                            break;
                        case 5:
                            v.setImageResource(R.drawable.dice5);
                            break;
                        case 6:
                            v.setImageResource(R.drawable.dice6);
                            break;
                    }
                    return false;
                }
            });

            vtwo.setOnTouchListener(new View.OnTouchListener() {
                @Override
                public boolean onTouch(View view, MotionEvent motionEvent) {
                    final MediaPlayer mp = MediaPlayer.create(getApplicationContext(), R.raw.dicesound);
                    mp.setOnCompletionListener(new MediaPlayer.OnCompletionListener() {
                        public void onCompletion(MediaPlayer mp) {
                            mp.release();
                        }
                    });
                    mp.start();
                    Vibrator vibrator = (Vibrator) getSystemService(Context.VIBRATOR_SERVICE);
                    vibrator.vibrate(50);
                    switch (rollDice()) {
                        case 1:
                            vtwo.setImageResource(R.drawable.dice1);
                            break;
                        case 2:
                            vtwo.setImageResource(R.drawable.dice2);
                            break;
                        case 3:
                            vtwo.setImageResource(R.drawable.dice3);
                            break;
                        case 4:
                            vtwo.setImageResource(R.drawable.dice4);
                            break;
                        case 5:
                            vtwo.setImageResource(R.drawable.dice5);
                            break;
                        case 6:
                            vtwo.setImageResource(R.drawable.dice6);
                            break;
                    }
                    switch (rollDice()) {
                        case 1:
                            v.setImageResource(R.drawable.dice1);
                            break;
                        case 2:
                            v.setImageResource(R.drawable.dice2);
                            break;
                        case 3:
                            v.setImageResource(R.drawable.dice3);
                            break;
                        case 4:
                            v.setImageResource(R.drawable.dice4);
                            break;
                        case 5:
                            v.setImageResource(R.drawable.dice5);
                            break;
                        case 6:
                            v.setImageResource(R.drawable.dice6);
                            break;
                    }
                    return false;
                }
            });
        }


    }

    //random number between 1 and 6
    protected int rollDice(){
        return (int)(Math.random()*6+1);
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        // Inflate the menu; this adds items to the action bar if it is present.
        MenuInflater mf = getMenuInflater();
        mf.inflate(R.menu.main, menu);
        return super.onCreateOptionsMenu(menu);
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        // Handle action bar item clicks here. The action bar will
        // automatically handle clicks on the Home/Up button, so long
        // as you specify a parent activity in AndroidManifest.xml.
        switch (item.getItemId()){
            case R.id.settings:
                openSettings(findViewById(R.id.settings));
                return true;
            case R.id.close:
                finish();
                return true;
        }
        return super.onOptionsItemSelected(item);
    }

    public void openSettings(View view) {
        Intent intent = new Intent(MainActivity.this, SettingsActivity.class);
        startActivity(intent);
    }

    public void onSharedPreferenceChanged(SharedPreferences sharedPreferences, String s) {
        SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(getBaseContext());
        String string = sp.getString("PREF_NUMBEROFDIES", "none");
        onedie = string.equals("1");
    }
}