package com.oF2pks.chairlock;

import android.Manifest;
import android.app.ActionBar;
import android.app.Activity;
import android.app.AlertDialog;
import android.app.ListFragment;
import android.app.LoaderManager;
import android.app.ProgressDialog;
import android.app.usage.UsageStatsManager;
import android.content.Intent;
import android.content.Loader;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.method.ScrollingMovementMethod;
import android.text.style.BackgroundColorSpan;
import android.text.style.RelativeSizeSpan;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.Filter;
import android.widget.Filterable;
import android.widget.ImageView;
import android.widget.SearchView;
import android.widget.SectionIndexer;
import android.widget.TextView;
import android.widget.Toast;

import com.oF2pks.applicationsinfo.*;
import com.oF2pks.applicationsinfo.utils.Utils;

import java.lang.ref.WeakReference;
import java.text.Collator;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;


public class LaunchListFragment extends ListFragment implements AdapterView.OnItemClickListener, SearchView.OnQueryTextListener,
        LoaderManager.LoaderCallbacks<List<PermissionItem>> {
    public static final String EXTRA_PACKAGE_NAME = "package_name";
    public static final String EXTRA_PACKAGE_PERM = "perm_name";

    private static Collator sCollator = Collator.getInstance();

    private static final int[] sSortMenuItemIdsMap = {R.id.action_sort_domain,R.id.action_sort_group,
            R.id.action_sort_name,R.id.action_sort_pkg,
            R.id.action_sort_installation,R.id.action_sort_sharedid,
            R.id.action_sort_size,R.id.action_sort_sha};

    private static final int SORT_DOMAIN = 0;
    private static final int SORT_GROUP = 1;
    private static final int SORT_NAME = 2;
    private static final int SORT_PKG = 3;
    private static final int SORT_INSTALLATION = 4;
    private static final int SORT_SHAREDID =5;
    private static final int SORT_SIZE = 6;
    private static final int SORT_SHA = 7;
    public static final String INSTANCE_STATE_SORT_BY = "sort_by";

    private Adapter mAdapter;
    private List<PermissionItem> mItemList = new ArrayList<>();
    private int mItemSizeRetrievedCount;
    private ProgressDialog mProgressDialog;
    private LaunchCallbacks mCallbacks;
    private Activity mActivity;
    private String mMiss;

    private int mSortBy;
    private String mLastClick;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setHasOptionsMenu(true);
        mProgressDialog = new ProgressDialog(mActivity);
        mProgressDialog.setTitle(R.string.loading_apps);
        mProgressDialog.setCancelable(false);

        ActionBar actionBar = getActivity().getActionBar();
        actionBar.setDisplayShowTitleEnabled(true);
        actionBar.setTitle("\u2211 "+getString(R.string.declared_premission));
        actionBar.setDisplayShowCustomEnabled(true);

        SearchView searchView = new SearchView(actionBar.getThemedContext());
        searchView.setOnQueryTextListener(this);

        ActionBar.LayoutParams layoutParams = new ActionBar.LayoutParams(ViewGroup.LayoutParams.WRAP_CONTENT,
                ViewGroup.LayoutParams.WRAP_CONTENT);
        actionBar.setCustomView(searchView, layoutParams);

        if (savedInstanceState != null) {
            mSortBy = savedInstanceState.getInt(INSTANCE_STATE_SORT_BY);
        }else mSortBy=SORT_NAME;
    }

    @Override
    public void onSaveInstanceState(Bundle outState) {
        outState.putInt(INSTANCE_STATE_SORT_BY, mSortBy);
        super.onSaveInstanceState(outState);
    }

    @Override
    public void onViewCreated(View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        getListView().setOnItemClickListener(this);
        getListView().setFastScrollEnabled(true);

        getListView().setOnItemLongClickListener(new AdapterView.OnItemLongClickListener() {

            @Override
            public boolean onItemLongClick(AdapterView<?> adapterView, View view, int i, long l) {
                Toast.makeText(getActivity(),  mAdapter.getItem(i).label, Toast.LENGTH_LONG).show();
                Intent viewAppIntent = new Intent(getActivity(), com.oF2pks.applicationsinfo.MainActivity.class);
                viewAppIntent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
                viewAppIntent.putExtra(EXTRA_PACKAGE_NAME, mAdapter.getItem(i).packageList);
                viewAppIntent.putExtra(EXTRA_PACKAGE_PERM, mAdapter.getItem(i).label);
                startActivity(viewAppIntent);
                return true;
            }
        });
        mAdapter = new Adapter(mActivity);
        setListAdapter(mAdapter);

        getLoaderManager().initLoader(0, null, this);
    }

    @Override
    public Loader<List<PermissionItem>> onCreateLoader(int i, Bundle bundle) {
        mProgressDialog.show();
        return new LaunchLoader(mActivity);
    }

    @Override
    public void onLoadFinished(Loader<List<PermissionItem>> loader, List<PermissionItem> applicationItems) {
        mItemList = applicationItems;
        RetrievePermissionsSigma();
        sortApplicationList();
        mAdapter.setDefaultList(mItemList);
        getActivity().getActionBar().setTitle("="+mItemList.size());

        //startRetrievingPackagesSize();//AI thread


        mProgressDialog.dismiss();
    }

    @Override
    public void onLoaderReset(Loader<List<PermissionItem>> loader) {
        mItemList = null;
        mAdapter.setDefaultList(null);

        mProgressDialog.dismiss();
    }

    @Override
    public void onAttach(Activity activity) {
        super.onAttach(activity);
        mCallbacks = (LaunchCallbacks) activity;
        mActivity = activity;
    }

    @Override
    public void onDetach() {
        super.onDetach();
        mCallbacks = null;
        mActivity = null;
    }

    @Override
    public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
        if (mCallbacks != null)
            mLastClick = mAdapter.getItem(i).applicationInfo.packageName;
            mCallbacks.onItemSelected(mAdapter.getItem(i).applicationInfo.packageName
                    ,mAdapter.getItem(i).packageList);
    }

    @Override
    public void onCreateOptionsMenu(Menu menu, MenuInflater inflater) {
        inflater.inflate(R.menu.fragment_launch_list, menu);
    }

    @Override
    public void onPrepareOptionsMenu(Menu menu) {
        super.onPrepareOptionsMenu(menu);
        menu.findItem(sSortMenuItemIdsMap[mSortBy]).setChecked(true);
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        final int id = item.getItemId();
        if (id == R.id.action_refresh) {
            getLoaderManager().restartLoader(0, null, this);
            if (mCallbacks != null && mLastClick != null && getActivity().findViewById(R.id.item_detail_container) != null){
                mCallbacks.onItemSelected(mLastClick, null);
                return true;
            }
        } else if (id == R.id.action_sort_name) {
            setSortBy(SORT_NAME);
            item.setChecked(true);
            return true;
        } else if (id == R.id.action_sort_pkg) {
            setSortBy(SORT_PKG);
            item.setChecked(true);
            return true;
        } else if (id == R.id.action_sort_domain) {
            setSortBy(SORT_DOMAIN);
            item.setChecked(true);
            return true;
        } else if (id == R.id.action_sort_group) {
            setSortBy(SORT_GROUP);
            item.setChecked(true);
            return true;
        } else if (id == R.id.action_sort_installation) {
            setSortBy(SORT_INSTALLATION);
            item.setChecked(true);
            return true;
        } else if (id == R.id.action_sort_sharedid) {
            setSortBy(SORT_SHAREDID);
            item.setChecked(true);
            return true;
        } else if (id == R.id.action_sort_sha) {
            setSortBy(SORT_SHA);
            item.setChecked(true);
            return true;
        } else if (id == R.id.action_sort_size) {
            setSortBy(SORT_SIZE);
            item.setChecked(true);
            return true;
        } else if (id == R.id.action_misses) {
            missesPerms();
            return true;
        } else if (id == R.id.action_duplicates) {
            duplicatesPerms();
            return true;
        } else if (id == R.id.action_packages) {
            startActivity(new Intent(getActivity(), MainActivity.class).putExtra(EXTRA_PACKAGE_PERM, "Onboard.packages"));
            return true;
        }
        return super.onOptionsItemSelected(item);
    }


    private void missesPerms() {
        TextView showText = new TextView(this.getActivity());
        showText.setMovementMethod(new ScrollingMovementMethod());
        showText.setTextIsSelectable(true);

        showText.setText(mMiss);

        new AlertDialog.Builder(this.getActivity())
                //.setTitle(R.string.about)
                .setView(showText)
                .setNegativeButton(android.R.string.ok, null)
                .show();
    }

    private void duplicatesPerms() {
        String dup ="";
        for (int i = 0; i < mItemList.size(); i++) {
            if (i>0 && mItemList.get(i).label.equals(mItemList.get(i-1).label))
                dup+= "\n\n"+ mItemList.get(i).sha.getFirst()
                        +"|"+mItemList.get(i-1).sha.getFirst()
                        +"\n"+mItemList.get(i).label;

        }
        TextView showText = new TextView(this.getActivity());
        showText.setMovementMethod(new ScrollingMovementMethod());
        showText.setTextIsSelectable(true);

        showText.setText(dup);

        new AlertDialog.Builder(this.getActivity())
                //.setTitle(R.string.about)
                .setView(showText)
                .setNegativeButton(android.R.string.ok, null)
                .show();

    }

    /**
     * Sort main list if provided value is valid.
     *
     * @param sort Must be one of SORT_*
     */
    private void setSortBy(int sort) {
        mSortBy = sort;
        sortApplicationList();

        if (mAdapter != null)
            mAdapter.notifyDataSetChanged();

        if (getListView() != null)
            checkFastScroll();
    }

    private void checkFastScroll() {
        getListView().setFastScrollEnabled(mSortBy == SORT_NAME);
    }

    public void sortApplicationList() {
        Collections.sort(mItemList, new Comparator<PermissionItem>() {
            @Override
            public int compare(PermissionItem item1, PermissionItem item2) {
                switch (mSortBy) {
                    case SORT_NAME:
                        return sCollator.compare(item1.label, item2.label);
                    case SORT_PKG:
                        return item1.applicationInfo.packageName.compareTo(item2.applicationInfo.packageName);
                    case SORT_DOMAIN:
                        boolean isSystem1 = (item1.applicationInfo.flags & ApplicationInfo.FLAG_SYSTEM) != 0;
                        boolean isSystem2 = (item2.applicationInfo.flags & ApplicationInfo.FLAG_SYSTEM) != 0;
                        return Utils.compareBooleans(isSystem1, isSystem2);
                    case SORT_INSTALLATION:
                        //Sort in decreasing order
                        return -item1.date.compareTo(item2.date);
                    case SORT_GROUP:
                        return item1.group.compareTo(item2.group);
                    case SORT_SIZE:
                        return item1.size.compareTo(item2.size);
                    case SORT_SHAREDID:
                        return item2.applicationInfo.uid - item1.applicationInfo.uid;
                    case SORT_SHA:
                        try {
                            return item1.sha.compareTo(item2.sha);
                        } catch (NullPointerException e) {

                        }
                    default:
                        return 0;
                }
            }
        });
    }

    @Override
    public boolean onQueryTextChange(String s) {
        mAdapter.getFilter().filter(s);
        return true;
    }

    @Override
    public boolean onQueryTextSubmit(String s) {
        return false;
    }

    private void RetrievePermissionsSigma() {
        boolean b = false;
        PackageManager mPackageManager = mActivity.getPackageManager();
        List<ApplicationInfo> applicationInfos = mPackageManager.getInstalledApplications(PackageManager.GET_META_DATA);
        for (ApplicationInfo applicationInfo : applicationInfos) {
            try {
                if (mPackageManager.getPackageInfo(applicationInfo.packageName,PackageManager.GET_PERMISSIONS).requestedPermissions != null){
                    String[] aPermUsed= mPackageManager.getPackageInfo(applicationInfo.packageName,PackageManager.GET_PERMISSIONS).requestedPermissions;

                    for (int i = 0; i < aPermUsed.length; i++) {
                        for (PermissionItem item : mItemList) {
                            if (aPermUsed[i].equals(item.label)) {
                                item.packageList += applicationInfo.packageName ;
                                item.size += -1000;
                                if (mPackageManager.checkPermission(aPermUsed[i], applicationInfo.packageName) == PackageManager.PERMISSION_GRANTED){
                                    item.size += -1;
                                    item.packageList += "*";
                                }
                                item.packageList+= "\n";
                                b = true;
                                //break;
                            }
                        }
                        if (!b) mMiss+="\n"+aPermUsed[i]+"\n"+applicationInfo.packageName+"\n\n";
                        b=false;
                    }
                }
            }catch (PackageManager.NameNotFoundException e){

            }
        }
    }

    static class Adapter extends BaseAdapter implements SectionIndexer, Filterable {

        static final String sections = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        static final DateFormat sSimpleDateFormat = new SimpleDateFormat("dd/MM/yyyy");// hh:mm:ss");
        static final Spannable.Factory sSpannableFactory = Spannable.Factory.getInstance();

        static class ViewHolder {
            ImageView icon;
            ImageView favorite_icon;
            TextView label;
            TextView packageName;
            TextView version;
            TextView isSystemApp;
            TextView date;
            TextView size;
            TextView sharedid;
            TextView issuer;
            TextView sha;
            TextView description;
            IconAsyncTask iconLoader;
        }

        private Activity mActivity;
        private LayoutInflater mLayoutInflater;
        private static PackageManager mPackageManager;
        private Filter mFilter;
        private String mConstraint;
        private List<PermissionItem> mDefaultList;
        private List<PermissionItem> mAdapterList;

        private int mColorGrey1;
        private int mColorGrey2;
        private int mOrange1;

        Adapter(Activity activity) {
            mActivity = activity;
            mLayoutInflater = activity.getLayoutInflater();
            mPackageManager = activity.getPackageManager();

            mColorGrey1 = activity.getResources().getColor(R.color.grey_1);
            mColorGrey2 = activity.getResources().getColor(R.color.grey_2);
            mOrange1 = activity.getResources().getColor(R.color.orange_1);
        }

        void setDefaultList(List<PermissionItem> list) {
            mDefaultList = list;
            mAdapterList = list;
            notifyDataSetChanged();
        }

        @Override
        public Filter getFilter() {
            if (mFilter == null)
                mFilter = new Filter() {
                    @Override
                    protected FilterResults performFiltering(CharSequence charSequence) {
                        String constraint = charSequence.toString().toLowerCase();
                        mConstraint = constraint;
                        FilterResults filterResults = new FilterResults();
                        if (constraint.length() == 0) {
                            filterResults.count = 0;
                            filterResults.values = null;
                            return filterResults;
                        }

                        List<PermissionItem> list = new ArrayList<>(mDefaultList.size());
                        for (PermissionItem item : mDefaultList) {
                            if (item.label.toLowerCase().contains(constraint) ||
                                    item.applicationInfo.packageName.contains(constraint) ||
                                    item.description.contains(constraint))
                                list.add(item);
                        }

                        filterResults.count = list.size();
                        filterResults.values = list;
                        return filterResults;
                    }

                    @Override
                    protected void publishResults(CharSequence charSequence, FilterResults filterResults) {
                        if (filterResults.values == null)
                            mAdapterList = mDefaultList;
                        else
                            mAdapterList = (List<PermissionItem>) filterResults.values;

                        notifyDataSetChanged();
                    }
                };
            return mFilter;
        }

        @Override
        public int getCount() {
            return mAdapterList == null ? 0 : mAdapterList.size();
        }

        @Override
        public PermissionItem getItem(int i) {
            return mAdapterList.get(i);
        }

        @Override
        public long getItemId(int i) {
            return i;
        }

        @Override
        public View getView(int i, View view, ViewGroup viewGroup) {
            ViewHolder holder;
            if (view == null) {
                view = mLayoutInflater.inflate(R.layout.launch_list_item, viewGroup, false);
                holder = new ViewHolder();
                holder.icon = (ImageView) view.findViewById(R.id.icon);
                holder.favorite_icon = (ImageView) view.findViewById(R.id.favorite_icon);
                holder.label = (TextView) view.findViewById(R.id.label);
                holder.packageName = (TextView) view.findViewById(R.id.packageName);
                holder.version = (TextView) view.findViewById(R.id.version);
                holder.isSystemApp = (TextView) view.findViewById(R.id.isSystem);
                holder.date = (TextView) view.findViewById(R.id.date);
                holder.size = (TextView) view.findViewById(R.id.size);
                holder.sharedid = (TextView) view.findViewById(R.id.shareid);
                holder.issuer = (TextView) view.findViewById(R.id.issuer);
                holder.sha = (TextView) view.findViewById(R.id.sha);
                holder.description = view.findViewById(R.id.description);
                view.setTag(holder);
            } else {
                holder = (ViewHolder) view.getTag();
                holder.iconLoader.cancel(true);
            }

            view.setBackgroundColor(i % 2 == 0 ? mColorGrey2 : mColorGrey1);

            PermissionItem item = mAdapterList.get(i);
            holder.version.setText((item.group));

            if (mConstraint != null && item.description.toLowerCase().contains(mConstraint))
                holder.description.setText(getHighlightedText(item.description));
            else
                holder.description.setText(item.description);

            ApplicationInfo info = item.applicationInfo;
            if (!info.enabled)
                view.setBackgroundColor(Color.LTGRAY);//holder.icon.setImageAlpha(50);//view.setBackgroundColor(Color.LTGRAY);
            holder.favorite_icon.setVisibility(item.star ? View.VISIBLE : View.INVISIBLE);

            holder.sharedid.setText(Integer.toString(info.uid));
            try {
                PackageInfo packageInfo = mPackageManager.getPackageInfo(info.packageName, 0);
                String sDate = sSimpleDateFormat.format(new Date(packageInfo.lastUpdateTime));
                if (packageInfo.firstInstallTime == packageInfo.lastUpdateTime) holder.date.setText(sDate);
                else {
                    SpannableString ssDate = new SpannableString(sDate + "-" + TimeUnit.DAYS.convert(packageInfo.lastUpdateTime-packageInfo.firstInstallTime,TimeUnit.MILLISECONDS));
                    ssDate.setSpan(new RelativeSizeSpan(.8f), 10, ssDate.length(), Spannable.SPAN_EXCLUSIVE_EXCLUSIVE);
                    holder.date.setText(ssDate);
                }
                if (packageInfo.sharedUserId != null) holder.sharedid.setTextColor(mOrange1);
                else holder.sharedid.setTextColor(Color.GRAY);
                holder.issuer.setText((String) item.sha.getFirst());
                holder.sha.setText((String) item.sha.getSecond());
            } catch (PackageManager.NameNotFoundException | NullPointerException e) {
                //Do nothing
            }

            holder.iconLoader = new IconAsyncTask(holder.icon, info);
            holder.iconLoader.execute();
            //KISS:? holder.icon.setImageDrawable(info.loadIcon(mPackageManager));

            if (mConstraint != null && item.label.toLowerCase().contains(mConstraint))
                holder.label.setText(getHighlightedText(item.label));
            else
                holder.label.setText(item.label);

            if (mConstraint != null && info.packageName.contains(mConstraint))
                holder.packageName.setText(getHighlightedText(info.packageName));
            else
                holder.packageName.setText(info.packageName);
            if ((info.flags & ApplicationInfo.FLAG_STOPPED) != 0)
                holder.packageName.setTextColor(Color.BLUE);
            else holder.packageName.setTextColor(Color.GRAY);

            if ((info.flags & ApplicationInfo.FLAG_HARDWARE_ACCELERATED) == 0)
                holder.version.setText("_" + holder.version.getText());
            if ((info.flags & ApplicationInfo.FLAG_DEBUGGABLE) != 0)
                holder.version.setText("debug" + holder.version.getText());
            if ((info.flags & ApplicationInfo.FLAG_TEST_ONLY) != 0)
                holder.version.setText("~" + holder.version.getText());


            if ((info.flags & ApplicationInfo.FLAG_SYSTEM) != 0)
                holder.isSystemApp.setText(mActivity.getString(R.string.system));
            else holder.isSystemApp.setText(mActivity.getString(R.string.user));
            if (Build.VERSION.SDK_INT >= 23) {
                UsageStatsManager mUsageStats;
                mUsageStats = mActivity.getSystemService(UsageStatsManager.class);
                if (mUsageStats.isAppInactive(info.packageName))
                    holder.version.setTextColor(Color.GREEN);
                else holder.version.setTextColor(Color.GRAY);
            }
            if (item.sha.getSecond().toString().contains("dangerous"))//(AppOpsManager.permissionToOp(item.permInfo.name) != null)
                holder.sha.setTextColor(Color.BLUE);
            else holder.sha.setTextColor(Color.GRAY);

            //holder.isSystemApp.setText(holder.isSystemApp.getText()+ getCategory(info.category, (char) 'c'));
            if ((info.flags & ApplicationInfo.FLAG_PERSISTENT) != 0)
                holder.isSystemApp.setTextColor(Color.MAGENTA);
            else holder.isSystemApp.setTextColor(Color.BLACK);
            if ((info.flags & ApplicationInfo.FLAG_LARGE_HEAP) != 0)
                holder.isSystemApp.setText(holder.isSystemApp.getText() + "#");
            if ((info.flags & ApplicationInfo.FLAG_ALLOW_CLEAR_USER_DATA) == 0)
                holder.label.setTextColor(Color.RED);
            else holder.label.setTextColor(Color.BLACK);
            if ((info.flags & ApplicationInfo.FLAG_SUSPENDED) != 0)
                holder.isSystemApp.setText(holder.isSystemApp.getText() + "°");
            if ((info.flags & ApplicationInfo.FLAG_MULTIARCH) != 0)
                holder.isSystemApp.setText(holder.isSystemApp.getText() + "X");
            if ((info.flags & ApplicationInfo.FLAG_HAS_CODE) == 0)
                holder.isSystemApp.setText(holder.isSystemApp.getText() + "0");
            if ((info.flags & ApplicationInfo.FLAG_VM_SAFE_MODE) != 0)
                holder.isSystemApp.setText(holder.isSystemApp.getText() + "?");
            //if ((info.flags & ApplicationInfo.FLAG_EXTRACT_NATIVE_LIBS) == 0) holder.isSystemApp.setText(holder.isSystemApp.getText()+"0");
            if (mPackageManager.checkPermission(Manifest.permission.READ_LOGS, info.packageName) == PackageManager.PERMISSION_GRANTED)
                holder.date.setTextColor(mOrange1);
            else holder.date.setTextColor(Color.GRAY);

            if (Build.VERSION.SDK_INT >= 26) {
                holder.size.setText(item.size + "\u2211");
                if ((info.flags & ApplicationInfo.FLAG_USES_CLEARTEXT_TRAFFIC) != 0)
                    holder.size.setTextColor(mOrange1);
                else holder.size.setTextColor(Color.GRAY);
            } else if (item.size != -1L)
                holder.size.setText(item.size+"\u2211");

            return view;
        }

        Spannable getHighlightedText(String s) {
            Spannable spannable = sSpannableFactory.newSpannable(s);
            int start = s.toLowerCase().indexOf(mConstraint);
            int end = start + mConstraint.length();
            spannable.setSpan(new BackgroundColorSpan(0xFFB7B7B7), start, end, Spannable.SPAN_EXCLUSIVE_EXCLUSIVE);
            return spannable;
        }

        @Override
        public int getPositionForSection(int section) {
            for (int i = 0; i < this.getCount(); i++) {
                String item = mAdapterList.get(i).label;
                if (item.length() > 0) {
                    if (item.charAt(0) == sections.charAt(section))
                        return i;
                }
            }
            return 0;
        }

        @Override
        public int getSectionForPosition(int i) {
            return 0;
        }

        @Override
        public Object[] getSections() {
            String[] sectionsArr = new String[sections.length()];
            for (int i = 0; i < sections.length(); i++)
                sectionsArr[i] = "" + sections.charAt(i);

            return sectionsArr;
        }

        private static class IconAsyncTask extends AsyncTask<Void, Integer, Drawable> {
            private WeakReference<ImageView> imageView = null;
            ApplicationInfo info;

            private IconAsyncTask (ImageView pImageViewWeakReference,ApplicationInfo info) {
                link(pImageViewWeakReference);
                this.info = info;
            }

            private void link (ImageView pImageViewWeakReference) {
                imageView = new WeakReference<ImageView>(pImageViewWeakReference);
                    }


            @Override
            protected void onPreExecute() {
                super.onPreExecute();
                if (imageView.get()!=null)
                    imageView.get().setVisibility(View.INVISIBLE);
            }

            @Override
            protected Drawable doInBackground(Void... voids) {
                if (!isCancelled())
                    return info.loadIcon(mPackageManager);
                return null;
            }

            @Override
            protected void onPostExecute(Drawable drawable) {
                super.onPostExecute(drawable);
                if (imageView.get()!=null){
                    imageView.get().setImageDrawable(drawable);
                    imageView.get().setVisibility(View.VISIBLE);

                }
            }
        }
    }
}
