/*
 * Decompiled with CFR 0.152.
 */
package com.nolanlawson.japanesenamegenerator.v3.util;

import com.nolanlawson.japanesenamegenerator.v3.util.IntegerSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringUtil {
    private static final IntegerSet vowels = new IntegerSet(new HashSet<Character>(Arrays.asList(Character.valueOf('a'), Character.valueOf('e'), Character.valueOf('i'), Character.valueOf('o'), Character.valueOf('u'))));
    public static final IntegerSet consonants = new IntegerSet(new HashSet<Character>(Arrays.asList(Character.valueOf('b'), Character.valueOf('c'), Character.valueOf('d'), Character.valueOf('f'), Character.valueOf('g'), Character.valueOf('h'), Character.valueOf('j'), Character.valueOf('k'), Character.valueOf('l'), Character.valueOf('m'), Character.valueOf('n'), Character.valueOf('p'), Character.valueOf('q'), Character.valueOf('r'), Character.valueOf('s'), Character.valueOf('t'), Character.valueOf('v'), Character.valueOf('w'), Character.valueOf('x'), Character.valueOf('z'))));

    public static List<String> stringToListOfStrings(String str) {
        ArrayList<String> result = new ArrayList<String>();
        for (char ch : str.toCharArray()) {
            result.add(Character.toString(ch));
        }
        return result;
    }

    public static boolean isVowel(char ch) {
        return vowels.contains(ch);
    }

    public static boolean isConsonant(char ch) {
        return consonants.contains(ch);
    }

    public static boolean isConsonantOrY(char ch) {
        return consonants.contains(ch) || ch == 'y';
    }

    public static String concat(char char1, char ... otherChars) {
        StringBuilder sb = new StringBuilder();
        sb.append(Character.toString(char1));
        for (char ch : otherChars) {
            sb.append(Character.toString(ch));
        }
        return sb.toString();
    }

    public static String[] quickSplit(String str, String delimiter) {
        ArrayList<String> result = new ArrayList<String>();
        int lastIndex = 0;
        int index = str.indexOf(delimiter);
        while (index != -1) {
            result.add(str.substring(lastIndex, index));
            lastIndex = index + delimiter.length();
            index = str.indexOf(delimiter, index + delimiter.length());
        }
        result.add(str.substring(lastIndex, str.length()));
        return result.toArray(new String[result.size()]);
    }

    public static String quickReplace(String originalString, String searchString, String replaceString) {
        StringBuilder sb = new StringBuilder(originalString);
        int index = sb.indexOf(searchString);
        while (index != -1) {
            sb.replace(index, index + searchString.length(), replaceString);
            index += replaceString.length();
            index = sb.indexOf(searchString, index);
        }
        return sb.toString();
    }

    public static String join(String delimiter, String[] strings) {
        if (strings.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String str : strings) {
            stringBuilder.append(" ").append(str);
        }
        return stringBuilder.substring(1);
    }
}

