/*
 * Decompiled with CFR 0.152.
 */
package com.nolanlawson.japanesenamegenerator.v3.util;

import java.lang.reflect.Array;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayUtil {
    public static boolean[] copyOf(boolean[] original, int newLength) {
        boolean[] copy = new boolean[newLength];
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }

    public static int[] copyOf(int[] original, int newLength) {
        int[] copy = new int[newLength];
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }

    public static int[] concatenate(int[] first, int[] second) {
        int i;
        int[] result = new int[first.length + second.length];
        for (i = 0; i < first.length; ++i) {
            result[i] = first[i];
        }
        for (i = 0; i < second.length; ++i) {
            result[i + first.length] = second[i];
        }
        return result;
    }

    public static boolean[] concatenate(boolean[] first, boolean[] second) {
        int i;
        boolean[] result = new boolean[first.length + second.length];
        for (i = 0; i < first.length; ++i) {
            result[i] = first[i];
        }
        for (i = 0; i < second.length; ++i) {
            result[i + first.length] = second[i];
        }
        return result;
    }

    public static <T> T[] copyOf(T[] original, int newLength) {
        return ArrayUtil.copyOf(original, newLength, original.getClass());
    }

    public static <T, U> T[] copyOf(U[] original, int newLength, Class<? extends T[]> newType) {
        Object[] copy = newType == Object[].class ? new Object[newLength] : (Object[])Array.newInstance(newType.getComponentType(), newLength);
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }
}

