/*
 * Decompiled with CFR 0.152.
 */
package com.nolanlawson.japanesenamegenerator.v3.pronunciation;

import com.nolanlawson.japanesenamegenerator.v3.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PronunciationGuide {
    private static String[] geminateConsonants = new String[]{"bb", "cch", "dd", "ff", "gg", "jj", "kk", "pp", "ss", "tt", "tch"};
    private static Map<String, String> guideHash = PronunciationGuide.getPronuncationGuideHash();

    public static List<Pair<String, String>> getPronunciationGuide(String roomaji) {
        ArrayList<Pair<String, String>> result = new ArrayList<Pair<String, String>>();
        for (int i = 0; i < roomaji.length(); ++i) {
            String bigram;
            String trigram;
            if (i < roomaji.length() - 2 && guideHash.containsKey(trigram = roomaji.substring(i, i + 3))) {
                result.add(Pair.create(trigram, guideHash.get(trigram)));
                i += 2;
                continue;
            }
            if (i < roomaji.length() - 1 && guideHash.containsKey(bigram = roomaji.substring(i, i + 2))) {
                result.add(Pair.create(bigram, guideHash.get(bigram)));
                ++i;
                continue;
            }
            String unigram = Character.toString(roomaji.charAt(i));
            if (!guideHash.containsKey(unigram)) continue;
            result.add(Pair.create(unigram, guideHash.get(unigram)));
        }
        HashSet resultSet = new HashSet();
        for (int i = 0; i < result.size(); ++i) {
            if (resultSet.contains(result.get(i))) {
                result.remove(i);
                --i;
                continue;
            }
            resultSet.add(result.get(i));
        }
        return result;
    }

    private static Map<String, String> getPronuncationGuideHash() {
        HashMap<String, String> result = new HashMap<String, String>(){
            {
                this.put("a", "like the \"a\" in \"father\"");
                this.put("o", "like the \"o\" in \"orange\"");
                this.put("u", "like  the \"u\" in \"hula\"");
                this.put("i", "like the \"ee\" in \"bee\"");
                this.put("e", "like the \"ey\" in \"hey\"");
                this.put("aa", "like the \"a\" in \"father,\" but held twice as long");
                this.put("oo", "like the \"o\" in \"orange,\" but held twice as long");
                this.put("ou", "like the \"o\" in \"orange,\" but held twice as long");
                this.put("uu", "like  the \"u\" in \"hula,\" but held twice as long");
                this.put("ii", "like the \"ee\" in \"bee,\" but held twice as long");
                this.put("ee", "like the \"ey\" in \"hey,\" but held twice as long");
                this.put("ei", "like the \"ey\" in \"hey,\" but held twice as long");
                this.put("oi", "like the  \"oy\" in \"boy\"");
                this.put("ai", "like the  \"ai\" in \"samurai\"");
                this.put("r", "pronounced similar to the \"tt\" in \"kitty\" (American accent only), or the Spanish \"r\" as in \"pero\" (dog)");
                this.put("t", "like the  \"t\" in \"tea\"; never like the \"t\" in \"petal\" (in American accents)");
                this.put("d", "like the  \"d\" in \"day\"; never like the \"d\" in \"pedal\" (in American accents)");
            }
        };
        String geminateConsonantExplanation = "Double consonants are pronounced with a short pause preceding the consonant";
        for (String geminateConsonant : geminateConsonants) {
            if (geminateConsonant.equals("tt")) {
                result.put(geminateConsonant, (String)result.get("t") + ". " + geminateConsonantExplanation);
                continue;
            }
            if (geminateConsonant.equals("dd")) {
                result.put(geminateConsonant, (String)result.get("d") + ". " + geminateConsonantExplanation);
                continue;
            }
            result.put(geminateConsonant, geminateConsonantExplanation);
        }
        return result;
    }
}

