/*
 * Decompiled with CFR 0.152.
 */
package com.nolanlawson.japanesenamegenerator.v3.katakana;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RomaajiMassager {
    private static Pattern mPattern1 = Pattern.compile("(m)([pbfw])");
    private static Pattern shPattern = Pattern.compile("(sh)([^aioeuy]|$)");
    private static Pattern tsPattern = Pattern.compile("(ts)([^aioeu]|$)");
    private static Pattern sPattern = Pattern.compile("(s)([^aeiouyhs]|$)");
    private static Pattern bPattern = Pattern.compile("(b)([^aeiouyb]|$)");
    private static Pattern fPattern = Pattern.compile("(f)([^aeiouf]|$)");
    private static Pattern gPattern = Pattern.compile("(g)([^aeiouyg]|$)");
    private static Pattern kPattern = Pattern.compile("(k)([^aeiouyk]|$)");
    private static Pattern mPattern2 = Pattern.compile("(m)([^aeiouy]|$)");
    private static Pattern pPattern = Pattern.compile("(p)([^aeiouyp]|$)");
    private static Pattern rPattern = Pattern.compile("(r)([^aeiouy]|$)");
    private static Pattern zPattern = Pattern.compile("(z)([^aeiouz]|$)");
    private static Pattern tPattern = Pattern.compile("(t)([^aeiouyst]|ch|$)");
    private static Pattern dPattern = Pattern.compile("(d)([^aeiouyd]|$)");
    private static Pattern hPattern = Pattern.compile("(h)([^aeiouy]|$)");
    private static Pattern chPattern = Pattern.compile("(ch)([^aeiouy]|$)");
    private static Pattern jPattern = Pattern.compile("(j)([^aeiouyj]|$)");
    private static Pattern wPattern = Pattern.compile("(w)([^aeiou]|$)");
    private static Pattern yPattern = Pattern.compile("(y)([^aeiou]|$)");
    private static Pattern nnPattern = Pattern.compile("(nn)([^aeiouy]|$)");

    public String massageMalformedRomaaji(String romaaji) {
        Matcher matcher;
        if (romaaji == null || romaaji.equals("")) {
            return romaaji;
        }
        for (Pattern pattern : new Pattern[]{mPattern1}) {
            matcher = pattern.matcher(romaaji);
            romaaji = matcher.replaceAll("n$2");
        }
        for (Pattern pattern : new Pattern[]{shPattern, tsPattern, sPattern, bPattern, fPattern, gPattern, kPattern, mPattern2, pPattern, rPattern, zPattern, yPattern}) {
            matcher = pattern.matcher(romaaji);
            romaaji = matcher.replaceAll("$1u$2");
        }
        for (Pattern pattern : new Pattern[]{tPattern, dPattern, hPattern}) {
            matcher = pattern.matcher(romaaji);
            romaaji = matcher.replaceAll("$1o$2");
        }
        for (Pattern pattern : new Pattern[]{chPattern, jPattern}) {
            matcher = pattern.matcher(romaaji);
            romaaji = matcher.replaceAll("$1i$2");
        }
        for (Pattern pattern : new Pattern[]{wPattern}) {
            matcher = pattern.matcher(romaaji);
            romaaji = matcher.replaceAll("$2");
        }
        for (Pattern pattern : new Pattern[]{nnPattern}) {
            matcher = pattern.matcher(romaaji);
            romaaji = matcher.replaceAll("n$2");
        }
        return romaaji;
    }
}

