/*
 * Decompiled with CFR 0.152.
 */
package com.nolanlawson.japanesenamegenerator.v3.katakana;

import com.nolanlawson.japanesenamegenerator.v3.katakana.Katakana;
import com.nolanlawson.japanesenamegenerator.v3.katakana.KatakanaParseException;
import com.nolanlawson.japanesenamegenerator.v3.util.StringUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class KatakanaConverter {
    private static Pattern invalidInputChars = Pattern.compile("[^a-z']");

    public String convertToKatakana(String romaaji) throws KatakanaParseException {
        String replacementString;
        String originalRomaaji = romaaji;
        if (romaaji == null) {
            throw new IllegalArgumentException("Null string: " + originalRomaaji);
        }
        Matcher matcher = invalidInputChars.matcher(romaaji.toLowerCase().trim());
        if ((romaaji = matcher.replaceAll("")).equals("")) {
            throw new IllegalArgumentException("String has no valid characters: '" + originalRomaaji + "'");
        }
        StringBuffer sb = new StringBuffer(romaaji);
        for (int i = 0; i < sb.length(); i += replacementString.length()) {
            int replacedStringSize;
            char ch = sb.charAt(i);
            if (ch == 'n' && i < sb.length() - 1 && (StringUtil.isConsonant(sb.charAt(i + 1)) || sb.charAt(i + 1) == '\'')) {
                replacementString = this.convertN(ch);
                replacedStringSize = sb.charAt(i + 1) == '\'' ? 2 : 1;
            } else if (ch == 'n' && i == sb.length() - 1) {
                replacementString = this.convertN(ch);
                replacedStringSize = 1;
            } else if ((ch == 's' || ch == 'c') && i < sb.length() - 1 && sb.charAt(i + 1) == 'h' && i < sb.length() - 2 && StringUtil.isVowel(sb.charAt(i + 2)) || StringUtil.isConsonant(ch) && i < sb.length() - 1 && sb.charAt(i + 1) == 'y' && i < sb.length() - 2 && StringUtil.isVowel(sb.charAt(i + 2)) || ch == 't' && i < sb.length() - 1 && sb.charAt(i + 1) == 's') {
                if (i < sb.length() - 3 && StringUtil.isVowel(sb.charAt(i + 3))) {
                    replacementString = this.convertConsonantConsonantVowelVowel(ch, sb.charAt(i + 1), sb.charAt(i + 2), sb.charAt(i + 3));
                    replacedStringSize = 4;
                } else {
                    replacementString = this.convertConsonantConsonantVowel(ch, sb.charAt(i + 1), sb.charAt(i + 2));
                    replacedStringSize = 3;
                }
            } else if (ch != 'n' && StringUtil.isConsonant(ch) && i < sb.length() - 1 && StringUtil.isConsonant(sb.charAt(i + 1))) {
                replacementString = this.convertSmallTsu();
                replacedStringSize = 1;
            } else if ((StringUtil.isConsonant(ch) || ch == 'y') && i < sb.length() - 1 && StringUtil.isVowel(sb.charAt(i + 1))) {
                if (i < sb.length() - 2 && StringUtil.isVowel(sb.charAt(i + 2))) {
                    replacementString = this.convertConsonantVowelVowel(ch, sb.charAt(i + 1), sb.charAt(i + 2));
                    replacedStringSize = 3;
                    if (replacementString.indexOf(Katakana.PROLONGED_SOUND_MARK.getChar()) == -1) {
                        replacementString = replacementString.substring(0, replacementString.length() - 1);
                        replacedStringSize = 2;
                    }
                } else {
                    replacementString = this.convertConsonantVowel(ch, sb.charAt(i + 1));
                    replacedStringSize = 2;
                }
            } else if (StringUtil.isVowel(ch)) {
                if (i < sb.length() - 1 && StringUtil.isVowel(sb.charAt(i + 1))) {
                    replacementString = this.convertVowelVowel(ch, sb.charAt(i + 1));
                    replacedStringSize = 2;
                    if (replacementString.indexOf(Katakana.PROLONGED_SOUND_MARK.getChar()) == -1) {
                        replacementString = replacementString.substring(0, replacementString.length() - 1);
                        replacedStringSize = 1;
                    }
                } else {
                    replacementString = this.convertVowel(ch);
                    replacedStringSize = 1;
                }
            } else {
                throw new KatakanaParseException(romaaji, i);
            }
            sb.replace(i, i + replacedStringSize, replacementString);
        }
        String result = sb.toString();
        for (int j = 0; j < result.length(); ++j) {
            Character.UnicodeBlock unicodeBlock = Character.UnicodeBlock.of(result.charAt(j));
            if (unicodeBlock == Character.UnicodeBlock.KATAKANA || unicodeBlock == Character.UnicodeBlock.KATAKANA_PHONETIC_EXTENSIONS) continue;
            throw new KatakanaParseException(romaaji, j);
        }
        return sb.toString();
    }

    private String convertConsonantConsonantVowelVowel(char consonant1, char consonant2, char vowel1, char vowel2) {
        String convertedFirstThreeChars = this.convertConsonantConsonantVowel(consonant1, consonant2, vowel1);
        String convertedVowel2 = Character.toString(this.convertVowelVowel(vowel1, vowel2).charAt(1));
        return convertedFirstThreeChars + convertedVowel2;
    }

    private String convertConsonantVowelVowel(char consonant, char vowel1, char vowel2) {
        String convertedFirstTwoChars = this.convertConsonantVowel(consonant, vowel1);
        String convertedVowel2 = Character.toString(this.convertVowelVowel(vowel1, vowel2).charAt(1));
        return convertedFirstTwoChars + convertedVowel2;
    }

    private String convertVowelVowel(char vowel1, char vowel2) {
        switch (vowel1) {
            case 'i': {
                if (vowel2 != 'i') break;
                return this.convertLengthenedVowel(vowel1);
            }
            case 'e': {
                if (vowel2 != 'e' && vowel2 != 'i') break;
                return this.convertLengthenedVowel(vowel1);
            }
            case 'a': {
                if (vowel2 != 'a') break;
                return this.convertLengthenedVowel(vowel1);
            }
            case 'o': {
                if (vowel2 != 'o' && vowel2 != 'u') break;
                return this.convertLengthenedVowel(vowel1);
            }
            case 'u': {
                if (vowel2 != 'u') break;
                return this.convertLengthenedVowel(vowel1);
            }
        }
        return this.convertVowel(vowel1) + this.convertVowel(vowel2);
    }

    private String convertLengthenedVowel(char vowel) {
        return Katakana.valueOf(Character.toString(Character.toUpperCase(vowel))).getString() + Katakana.PROLONGED_SOUND_MARK.getString();
    }

    private String convertVowel(char vowel) {
        return Katakana.valueOf(Character.toString(Character.toUpperCase(vowel))).getString();
    }

    private String convertConsonantVowel(char consonant, char vowel) {
        if (consonant == 'f' && vowel != 'u') {
            return StringUtil.concat(Katakana.FU.getChar(), this.getSmallVowel(vowel));
        }
        if (consonant == 'd' && vowel == 'u') {
            return StringUtil.concat(Katakana.DO.getChar(), this.getSmallVowel(vowel));
        }
        if (consonant == 'd' && vowel == 'i') {
            return StringUtil.concat(Katakana.DE.getChar(), this.getSmallVowel(vowel));
        }
        if (consonant == 't' && vowel == 'u') {
            return StringUtil.concat(Katakana.TO.getChar(), this.getSmallVowel(vowel));
        }
        if (consonant == 't' && vowel == 'i') {
            return StringUtil.concat(Katakana.TE.getChar(), this.getSmallVowel(vowel));
        }
        if (consonant == 'j') {
            if (vowel == 'e') {
                return StringUtil.concat(Katakana.JI.getChar(), Katakana.SMALL_E.getChar());
            }
            if (vowel == 'i') {
                return Katakana.JI.getString();
            }
            return StringUtil.concat(Katakana.JI.getChar(), this.getSmallPalatalizedVowel(vowel));
        }
        if (consonant == 'y' && vowel == 'e') {
            return StringUtil.concat(Katakana.I.getChar(), Katakana.SMALL_E.getChar());
        }
        if (consonant == 'y' && vowel == 'i') {
            return Katakana.I.getString();
        }
        if (consonant == 'w') {
            if (vowel == 'u') {
                return Katakana.U.getString();
            }
            if (vowel == 'a') {
                return Katakana.WA.getString();
            }
            return StringUtil.concat(Katakana.U.getChar(), this.getSmallVowel(vowel));
        }
        return Katakana.valueOf(StringUtil.concat(consonant, vowel).toUpperCase()).getString();
    }

    private String convertN(char n) {
        return Katakana.N.getString();
    }

    private String convertConsonantConsonantVowel(char consonant1, char consonant2, char vowel) {
        String convertedVowel;
        String convertedConsonants;
        boolean palatalized = true;
        if (consonant2 == 'y') {
            convertedConsonants = Katakana.valueOf(StringUtil.concat(consonant1, 'i').toUpperCase()).getString();
        } else if (consonant1 == 't' && consonant2 == 's') {
            convertedConsonants = Katakana.TSU.getString();
            palatalized = false;
        } else {
            convertedConsonants = Katakana.valueOf(StringUtil.concat(consonant1, consonant2, 'i').toUpperCase()).getString();
        }
        switch (vowel) {
            case 'i': {
                convertedVowel = palatalized ? "" : Katakana.SMALL_I.getString();
                break;
            }
            case 'e': {
                convertedVowel = Katakana.SMALL_E.getString();
                break;
            }
            case 'a': {
                convertedVowel = palatalized ? Katakana.SMALL_YA.getString() : Katakana.SMALL_A.getString();
                break;
            }
            case 'o': {
                convertedVowel = palatalized ? Katakana.SMALL_YO.getString() : Katakana.SMALL_O.getString();
                break;
            }
            default: {
                convertedVowel = palatalized ? Katakana.SMALL_YU.getString() : "";
            }
        }
        return convertedConsonants + convertedVowel;
    }

    private String convertSmallTsu() {
        return Katakana.SMALL_TU.getString();
    }

    private char getSmallVowel(char vowel) {
        return Katakana.valueOf("SMALL_" + Character.toUpperCase(vowel)).getChar();
    }

    private char getSmallPalatalizedVowel(char vowel) {
        return Katakana.valueOf("SMALL_Y" + Character.toUpperCase(vowel)).getChar();
    }
}

