/*
 * Decompiled with CFR 0.152.
 */
package com.nolanlawson.japanesenamegenerator.v3.katakana;

import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Katakana {
    SMALL_A('\u30a1'),
    A('\u30a2'),
    SMALL_I('\u30a3'),
    I('\u30a4'),
    SMALL_U('\u30a5'),
    U('\u30a6'),
    SMALL_E('\u30a7'),
    E('\u30a8'),
    SMALL_O('\u30a9'),
    O('\u30aa'),
    KA('\u30ab'),
    GA('\u30ac'),
    KI('\u30ad'),
    GI('\u30ae'),
    KU('\u30af'),
    GU('\u30b0'),
    KE('\u30b1'),
    GE('\u30b2'),
    KO('\u30b3'),
    GO('\u30b4'),
    SA('\u30b5'),
    ZA('\u30b6'),
    SI('\u30b7'),
    SHI('\u30b7'),
    ZI('\u30b8'),
    JI('\u30b8'),
    SU('\u30b9'),
    ZU('\u30ba'),
    SE('\u30bb'),
    ZE('\u30bc'),
    SO('\u30bd'),
    ZO('\u30be'),
    TA('\u30bf'),
    DA('\u30c0'),
    TI('\u30c1'),
    CHI('\u30c1'),
    DI('\u30c2'),
    SMALL_TU('\u30c3'),
    SMALL_TSU('\u30c3'),
    TU('\u30c4'),
    TSU('\u30c4'),
    DU('\u30c5'),
    DZU('\u30c5'),
    TE('\u30c6'),
    DE('\u30c7'),
    TO('\u30c8'),
    DO('\u30c9'),
    NA('\u30ca'),
    NI('\u30cb'),
    NU('\u30cc'),
    NE('\u30cd'),
    NO('\u30ce'),
    HA('\u30cf'),
    BA('\u30d0'),
    PA('\u30d1'),
    HI('\u30d2'),
    BI('\u30d3'),
    PI('\u30d4'),
    HU('\u30d5'),
    FU('\u30d5'),
    BU('\u30d6'),
    PU('\u30d7'),
    HE('\u30d8'),
    BE('\u30d9'),
    PE('\u30da'),
    HO('\u30db'),
    BO('\u30dc'),
    PO('\u30dd'),
    MA('\u30de'),
    MI('\u30df'),
    MU('\u30e0'),
    ME('\u30e1'),
    MO('\u30e2'),
    SMALL_YA('\u30e3'),
    YA('\u30e4'),
    SMALL_YU('\u30e5'),
    YU('\u30e6'),
    SMALL_YO('\u30e7'),
    YO('\u30e8'),
    RA('\u30e9'),
    RI('\u30ea'),
    RU('\u30eb'),
    RE('\u30ec'),
    RO('\u30ed'),
    SMALL_WA('\u30ee'),
    WA('\u30ef'),
    WI('\u30f0'),
    WE('\u30f1'),
    WO('\u30f2'),
    N('\u30f3'),
    VU('\u30f4'),
    SMALL_KA('\u30f5'),
    SMALL_KE('\u30f6'),
    VA('\u30f7'),
    VI('\u30f8'),
    VE('\u30f9'),
    VO('\u30fa'),
    PROLONGED_SOUND_MARK('\u30fc'),
    DOT('\u30fb');

    private char ch;
    private String str;
    private static Map<Character, String> reverseLookupMap;

    private Katakana(char ch) {
        this.ch = ch;
        this.str = Character.toString(ch);
    }

    public char getChar() {
        return this.ch;
    }

    public String getString() {
        return this.str;
    }

    public static String reverseLookup(char ch) {
        return reverseLookupMap.get(Character.valueOf(ch));
    }

    private static Map<Character, String> buildReverseLookupMap() {
        HashMap<Character, String> result = new HashMap<Character, String>();
        for (Katakana katakana : Katakana.values()) {
            String existingString = (String)result.get(Character.valueOf(katakana.ch));
            String currentString = katakana.name().toLowerCase();
            if (existingString != null && currentString.length() <= existingString.length() && (!currentString.equals("ji") || !existingString.equals("zi")) && (!currentString.equals("fu") || !existingString.equals("hu"))) continue;
            result.put(Character.valueOf(katakana.ch), currentString);
        }
        return result;
    }

    static {
        reverseLookupMap = Katakana.buildReverseLookupMap();
    }
}

